/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import java.net.URI;

public class RepoInfo {
    private static final String VERSION_PARAM = "v";
    private static final String LAST_SESSION_ID_PARAM = "ls";
    public String host;
    public boolean secure;
    public String namespace;
    public String internalHost;

    public String toString() {
        return "http" + (this.secure ? "s" : "") + "://" + this.host;
    }

    public String toDebugString() {
        return "(host=" + this.host + ", secure=" + this.secure + ", ns=" + this.namespace + " internal=" + this.internalHost + ")";
    }

    public URI getConnectionURL(String optLastSessionId) {
        String scheme = this.secure ? "wss" : "ws";
        String url = scheme + "://" + this.internalHost + "/.ws?ns=" + this.namespace + "&" + VERSION_PARAM + "=" + "5";
        if (optLastSessionId != null) {
            url = url + "&ls=" + optLastSessionId;
        }
        return URI.create(url);
    }

    public boolean isCacheableHost() {
        return this.internalHost.startsWith("s-");
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isDemoHost() {
        return this.host.contains(".firebaseio-demo.com");
    }

    public boolean isCustomHost() {
        return !this.host.contains(".firebaseio.com") && !this.host.contains(".firebaseio-demo.com");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepoInfo repoInfo = (RepoInfo)o;
        if (this.secure != repoInfo.secure) {
            return false;
        }
        if (!this.host.equals(repoInfo.host)) {
            return false;
        }
        return this.namespace.equals(repoInfo.namespace);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + (this.secure ? 1 : 0);
        result = 31 * result + this.namespace.hashCode();
        return result;
    }
}

