/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.Collections;
import java.util.List;
import org.jparsec.internal.util.Strings;

public final class ParseTree {
    private final String name;
    private final int beginIndex;
    private final int endIndex;
    private final Object value;
    private final List<ParseTree> children;

    ParseTree(String name, int beginIndex, int endIndex, Object value, List<ParseTree> children) {
        this.name = name;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.value = value;
        this.children = Collections.unmodifiableList(children);
    }

    public String getName() {
        return this.name;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public Object getValue() {
        return this.value;
    }

    public List<ParseTree> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name).append(": ");
        if (this.children.isEmpty()) {
            builder.append(this.value);
        } else {
            builder.append("{\n");
            Strings.join(builder, ",\n", this.children);
            builder.append("\n}");
        }
        return builder.toString();
    }
}

