/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.index;

import com.intellij.indexing.shared.download.SharedIndexAuthParams;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.index.PySharedIndexes;
import com.jetbrains.python.index.PySharedIndexesBundle;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/index/PyPackageSharedIndexLookupRequest;", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "name", "", "version", "(Ljava/lang/String;Ljava/lang/String;)V", "authId", "Lcom/intellij/indexing/shared/download/SharedIndexAuthParams;", "getAuthId", "()Lcom/intellij/indexing/shared/download/SharedIndexAuthParams;", "kind", "getKind", "()Ljava/lang/String;", "presentableChunkName", "getPresentableChunkName", "baseUrl", "equals", "", "other", "", "extractMajorMinor", "pkgVersion", "hashCode", "", "indexUrls", "", "toString", "intellij.python.sharedIndexes.downloadable"})
@SourceDebugExtension(value={"SMAP\nPyPackageSharedIndexSuggestion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackageSharedIndexSuggestion.kt\ncom/jetbrains/python/index/PyPackageSharedIndexLookupRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
final class PyPackageSharedIndexLookupRequest
implements SharedIndexLookupRequest {
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final String kind;

    public PyPackageSharedIndexLookupRequest(@NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.name = name;
        this.version = version;
        this.kind = "python";
    }

    @NotNull
    public String getKind() {
        return this.kind;
    }

    @NotNull
    public String baseUrl() {
        return PySharedIndexes.INSTANCE.getPythonFeedUrl();
    }

    @NotNull
    public String getPresentableChunkName() {
        Object[] objectArray = new Object[]{this.name, this.version};
        String string = PySharedIndexesBundle.message("presentable.chunk.name.python.pkg", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public SharedIndexAuthParams getAuthId() {
        return null;
    }

    @NotNull
    public List<String> indexUrls() {
        List main = CollectionsKt.listOf((Object)(PySharedIndexes.INSTANCE.getPythonFeedUrl() + "/package/" + this.name + "/" + this.version));
        String versionMajorMinor = this.extractMajorMinor(this.version);
        return versionMajorMinor == null ? main : CollectionsKt.plus((Collection)main, (Object)(PySharedIndexes.INSTANCE.getPythonFeedUrl() + "/major-minor-version/" + this.name + "/" + versionMajorMinor));
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.version.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PyPackageSharedIndexLookupRequest && Intrinsics.areEqual((Object)this.name, (Object)((PyPackageSharedIndexLookupRequest)other).name) && Intrinsics.areEqual((Object)this.version, (Object)((PyPackageSharedIndexLookupRequest)other).version);
    }

    @NotNull
    public String toString() {
        return "PyPackageIndexLookupRequest(" + this.name + ", " + this.version + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String extractMajorMinor(String pkgVersion) {
        List list;
        List it = list = VersionComparatorUtil.splitVersionString((String)pkgVersion);
        boolean bl = false;
        if (it.size() <= 2) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        List list2 = list;
        if (list2 == null) {
            return null;
        }
        List tokens = list2;
        List list3 = CollectionsKt.take((Iterable)tokens, (int)2);
        String major = (String)list3.get(0);
        String minor = (String)list3.get(1);
        String string = major;
        if (string == null) return null;
        Integer n = StringsKt.toIntOrNull((String)string);
        if (n == null) return null;
        String string2 = minor;
        if (string2 == null) return null;
        Integer n2 = StringsKt.toIntOrNull((String)string2);
        if (n2 == null) return null;
        String string3 = major + "." + minor;
        return string3;
    }
}

