/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.jcef.impl.IncrementalDOMBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/FileSchemeResourcesProcessor;", "Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/IncrementalDOMBuilder$FileSchemeResourceProcessingStrategy;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "()V", "resources", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "actuallyProcess", "fixedPath", "calculateResourceKey", "canProvide", "", "resourceName", "clear", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "processFileSchemeResource", "basePath", "Ljava/nio/file/Path;", "originalUri", "Ljava/net/URI;", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nFileSchemeResourcesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSchemeResourcesProcessor.kt\norg/intellij/plugins/markdown/ui/preview/jcef/impl/FileSchemeResourcesProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class FileSchemeResourcesProcessor
implements IncrementalDOMBuilder.FileSchemeResourceProcessingStrategy,
ResourceProvider {
    @NotNull
    private final HashMap<String, String> resources = new HashMap();

    @Override
    @Nullable
    public String processFileSchemeResource(@NotNull Path basePath, @NotNull URI originalUri) {
        Path resolvedPath;
        block10: {
            block9: {
                String string;
                block8: {
                    block7: {
                        String string2;
                        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
                        Intrinsics.checkNotNullParameter((Object)originalUri, (String)"originalUri");
                        string = originalUri.getPath();
                        if (string == null) break block7;
                        String it = string2 = string;
                        boolean bl = false;
                        string = !(((CharSequence)it).length() == 0) ? string2 : null;
                        if (string != null) break block8;
                    }
                    return null;
                }
                String path = string;
                if (SystemInfo.isWindows && StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                    char[] cArray = new char[]{'/', '\\'};
                    path = StringsKt.trimStart((String)path, (char[])cArray);
                }
                resolvedPath = basePath.resolve(path);
                Intrinsics.checkNotNull((Object)resolvedPath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(resolvedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block9;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(resolvedPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block10;
            }
            return null;
        }
        String string = FileUtil.toSystemIndependentName((String)((Object)resolvedPath).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String fixedPath = string;
        return this.actuallyProcess(fixedPath);
    }

    private final String actuallyProcess(String fixedPath) {
        String string = this.calculateResourceKey(fixedPath);
        if (string == null) {
            return null;
        }
        String key = string;
        ((Map)this.resources).put(key, fixedPath);
        return PreviewStaticServer.Companion.getStaticUrl(this, key);
    }

    public final void clear() {
        this.resources.clear();
    }

    private final String calculateResourceKey(String fixedPath) {
        Path path = Path.of(fixedPath, new String[0]);
        Path path2 = path.getFileName();
        if (path2 == null) {
            return null;
        }
        Path name = path2;
        MessageDigest messageDigest = DigestUtil.md5();
        String string = fixedPath;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = StringUtil.toHexString((byte[])messageDigest.digest(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(...)");
        String hash = string2;
        return "fileSchemeResource/" + hash + "-" + name;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return ((Map)this.resources).containsKey(resourceName);
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        String string = this.resources.get(resourceName);
        if (string == null) {
            return null;
        }
        String fixedPath = string;
        return ResourceProvider.Companion.loadExternalResource$default(ResourceProvider.Companion, new File(fixedPath), null, 2, null);
    }
}

