/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class FStringsAnnotator
extends PyAnnotator {
    @Override
    public void visitPyFStringFragment(@NotNull PyFStringFragment node) {
        PsiElement typeConversion;
        if (node == null) {
            FStringsAnnotator.$$$reportNull$$$0(0);
        }
        if ((typeConversion = node.getTypeConversion()) != null) {
            String conversionChar = typeConversion.getText().substring(1);
            if (conversionChar.isEmpty()) {
                this.report(typeConversion, PyPsiBundle.message("ANN.fstrings.missing.conversion.character", new Object[0]));
            } else if (conversionChar.length() > 1 || "sra".indexOf(conversionChar.charAt(0)) < 0) {
                this.report(typeConversion, PyPsiBundle.message("ANN.fstrings.illegal.conversion.character", conversionChar));
            }
        }
    }

    @Override
    public void visitPyFormattedStringElement(@NotNull PyFormattedStringElement node) {
        if (node == null) {
            FStringsAnnotator.$$$reportNull$$$0(1);
        }
        String wholeNodeText = node.getText();
        for (TextRange textRange : node.getLiteralPartRanges()) {
            int i = textRange.getStartOffset();
            while (i < textRange.getEndOffset()) {
                int nextOffset = FStringsAnnotator.skipNamedUnicodeEscape(wholeNodeText, i, textRange.getEndOffset());
                if (i != nextOffset) {
                    i = nextOffset;
                    continue;
                }
                char c = wholeNodeText.charAt(i);
                if (c == '}') {
                    if (i + 1 < textRange.getEndOffset() && wholeNodeText.charAt(i + 1) == '}') {
                        i += 2;
                        continue;
                    }
                    this.reportCharacter(node, i, PyPsiBundle.message("ANN.fstrings.single.right.brace.not.allowed.inside.fstrings", new Object[0]));
                }
                ++i;
            }
        }
    }

    private static int skipNamedUnicodeEscape(@NotNull String nodeText, int offset, int endOffset) {
        if (nodeText == null) {
            FStringsAnnotator.$$$reportNull$$$0(2);
        }
        if (StringUtil.startsWith((CharSequence)nodeText, (int)offset, (CharSequence)"\\N{")) {
            int rightBraceOffset = nodeText.indexOf(125, offset + 3);
            return rightBraceOffset < 0 ? endOffset : rightBraceOffset + 1;
        }
        return offset;
    }

    public void reportCharacter(@NotNull PsiElement element, int offset, @NotNull @InspectionMessage String message) {
        if (element == null) {
            FStringsAnnotator.$$$reportNull$$$0(3);
        }
        if (message == null) {
            FStringsAnnotator.$$$reportNull$$$0(4);
        }
        int nodeStartOffset = element.getTextRange().getStartOffset();
        this.getHolder().newAnnotation(HighlightSeverity.ERROR, message).range(TextRange.from((int)offset, (int)1).shiftRight(nodeStartOffset)).create();
    }

    public void report(@NotNull PsiElement element, @NotNull @InspectionMessage String error) {
        if (element == null) {
            FStringsAnnotator.$$$reportNull$$$0(5);
        }
        if (error == null) {
            FStringsAnnotator.$$$reportNull$$$0(6);
        }
        this.getHolder().newAnnotation(HighlightSeverity.ERROR, error).range(element).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/FStringsAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFStringFragment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFormattedStringElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "skipNamedUnicodeEscape";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCharacter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

