/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.pathValidation.PlatformAndRoot;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.add.PyAddNewEnvCollector;
import com.jetbrains.python.sdk.add.PyAddNewVirtualEnvFromFilePanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00052\b\b\u0001\u0010&\u001a\u00020\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewVirtualEnvFromFilePanel;", "Ljavax/swing/JPanel;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "suggestedRequirementsTxtOrSetupPy", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/module/Module;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "baseSdkField", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "envData", "Lcom/jetbrains/python/sdk/add/PyAddNewVirtualEnvFromFilePanel$Data;", "getEnvData", "()Lcom/jetbrains/python/sdk/add/PyAddNewVirtualEnvFromFilePanel$Data;", "initialBaseSdk", "initialPath", "", "initialRequirementsTxtOrSetupPy", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "projectBasePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getProjectBasePath", "()Ljava/lang/String;", "requirementsTxtOrSetupPyField", "baseSdkToEventField", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvCollector$Companion$InputData;", "initial", "result", "logData", "", "pathToEventField", "requirementsTxtOrSetupPyPathToEventField", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvCollector$Companion$RequirementsTxtOrSetupPyData;", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "defaultButtonName", "Data", "intellij.python.community.impl"})
public final class PyAddNewVirtualEnvFromFilePanel
extends JPanel {
    @NotNull
    private final Module module;
    @NotNull
    private final PySdkPathChoosingComboBox baseSdkField;
    @NotNull
    private final TextFieldWithBrowseButton pathField;
    @NotNull
    private final TextFieldWithBrowseButton requirementsTxtOrSetupPyField;
    @Nullable
    private Sdk initialBaseSdk;
    @NotNull
    private final String initialPath;
    @NotNull
    private final String initialRequirementsTxtOrSetupPy;

    public PyAddNewVirtualEnvFromFilePanel(@NotNull Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable VirtualFile suggestedRequirementsTxtOrSetupPy) {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        this.module = module;
        this.baseSdkField = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
        this.pathField = new TextFieldWithBrowseButton();
        this.requirementsTxtOrSetupPyField = new TextFieldWithBrowseButton();
        TextFieldWithBrowseButton $this$_init__u24lambda_u240 = textFieldWithBrowseButton = this.pathField;
        boolean bl = false;
        $this$_init__u24lambda_u240.setText(FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(this.getProjectBasePath())));
        $this$_init__u24lambda_u240.addBrowseFolderListener(PySdkBundle.message("python.venv.location.chooser", new Object[0]), null, this.module.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton $this$_init__u24lambda_u243 = textFieldWithBrowseButton = this.requirementsTxtOrSetupPyField;
        boolean bl2 = false;
        Object object = suggestedRequirementsTxtOrSetupPy;
        if (object != null && (object = object.getPath()) != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl3 = false;
            $this$_init__u24lambda_u243.setText(FileUtil.toSystemDependentName((String)it));
            $this$_init__u24lambda_u243.setTextFieldPreferredWidth(((String)it).length());
        }
        $this$_init__u24lambda_u243.addBrowseFolderListener(PyBundle.message("sdk.create.venv.dependencies.chooser", new Object[0]), null, this.module.getProject(), FileChooserDescriptorFactory.createSingleFileDescriptor().withFileFilter(arg_0 -> PyAddNewVirtualEnvFromFilePanel.lambda$3$lambda$2(2.2.INSTANCE, arg_0)));
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent(PySdkBundle.message("python.venv.location.label", new Object[0]), (JComponent)this.pathField).addLabeledComponent(PySdkBundle.message("python.venv.base.label", new Object[0]), (JComponent)((Object)this.baseSdkField)).addLabeledComponent(PyBundle.message("sdk.create.venv.dependencies.label", new Object[0]), (JComponent)this.requirementsTxtOrSetupPyField).getPanel();
        this.add((Component)formPanel, "North");
        PyAddSdkPanelKt.addBaseInterpretersAsync(this.baseSdkField, existingSdks, this.module, (UserDataHolder)new UserDataHolderBase(), (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                initialBaseSdk = baseSdkField.getSelectedSdk();
            }
        }));
        String string = this.pathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.initialPath = string;
        String string2 = this.requirementsTxtOrSetupPyField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.initialRequirementsTxtOrSetupPy = string2;
    }

    public /* synthetic */ PyAddNewVirtualEnvFromFilePanel(Module module, List list, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            virtualFile = null;
        }
        this(module, list, virtualFile);
    }

    @NotNull
    public final Data getEnvData() {
        String string = this.pathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Sdk sdk2 = this.baseSdkField.getSelectedSdk();
        String string2 = this.requirementsTxtOrSetupPyField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return new Data(string, sdk2, string2);
    }

    private final String getProjectBasePath() {
        String string = BasePySdkExtKt.getBasePath(this.module);
        if (string == null) {
            string = this.module.getProject().getBasePath();
        }
        return string;
    }

    @NotNull
    public final List<ValidationInfo> validateAll(@NlsContexts.Button @NotNull String defaultButtonName) {
        Intrinsics.checkNotNullParameter((Object)defaultButtonName, (String)"defaultButtonName");
        Object[] objectArray = new ValidationInfo[]{PyAddSdkPanel.Companion.validateEnvironmentDirectoryLocation(this.pathField, PlatformAndRoot.Companion.getLocal()), PyAddSdkPanel.Companion.validateSdkComboBox(this.baseSdkField, defaultButtonName)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public final void logData() {
        Data data = this.getEnvData();
        String path2 = data.component1();
        Sdk baseSdk = data.component2();
        String requirementsTxtOrSetupPyPath = data.component3();
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PyAddNewEnvCollector.Companion.logVirtualEnvFromFileData$intellij_python_community_impl(project, this.pathToEventField(this.initialPath, path2), this.baseSdkToEventField(this.initialBaseSdk, baseSdk), this.requirementsTxtOrSetupPyPathToEventField(this.initialRequirementsTxtOrSetupPy, requirementsTxtOrSetupPyPath));
    }

    private final PyAddNewEnvCollector.Companion.InputData pathToEventField(String initial, String result2) {
        return StringsKt.isBlank((CharSequence)initial) ? (StringsKt.isBlank((CharSequence)result2) ? PyAddNewEnvCollector.Companion.InputData.BLANK_UNCHANGED : PyAddNewEnvCollector.Companion.InputData.SPECIFIED) : (!Intrinsics.areEqual((Object)initial, (Object)result2) ? PyAddNewEnvCollector.Companion.InputData.CHANGED : PyAddNewEnvCollector.Companion.InputData.UNCHANGED);
    }

    private final PyAddNewEnvCollector.Companion.InputData baseSdkToEventField(Sdk initial, Sdk result2) {
        return initial == null ? (result2 == null ? PyAddNewEnvCollector.Companion.InputData.BLANK_UNCHANGED : PyAddNewEnvCollector.Companion.InputData.SPECIFIED) : (!Intrinsics.areEqual((Object)initial, (Object)result2) ? PyAddNewEnvCollector.Companion.InputData.CHANGED : PyAddNewEnvCollector.Companion.InputData.UNCHANGED);
    }

    private final PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData requirementsTxtOrSetupPyPathToEventField(String initial, String result2) {
        return StringsKt.isBlank((CharSequence)initial) ? (StringsKt.isBlank((CharSequence)result2) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.BLANK_UNCHANGED : (StringsKt.endsWith((String)result2, (String)".txt", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.TXT_SPECIFIED : (StringsKt.endsWith((String)result2, (String)".py", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.PY_SPECIFIED : PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.OTHER_SPECIFIED))) : (!Intrinsics.areEqual((Object)initial, (Object)result2) ? (StringsKt.endsWith((String)initial, (String)".txt", (boolean)true) ? (StringsKt.endsWith((String)result2, (String)".py", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_TXT_TO_PY : (StringsKt.endsWith((String)result2, (String)".txt", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_TXT_TO_TXT : PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_TXT_TO_OTHER)) : (StringsKt.endsWith((String)initial, (String)".py", (boolean)true) ? (StringsKt.endsWith((String)result2, (String)".py", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_PY_TO_PY : (StringsKt.endsWith((String)result2, (String)".txt", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_PY_TO_TXT : PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_PY_TO_OTHER)) : (StringsKt.endsWith((String)result2, (String)".py", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_OTHER_TO_PY : (StringsKt.endsWith((String)result2, (String)".txt", (boolean)true) ? PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_OTHER_TO_TXT : PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.CHANGED_OTHER_TO_OTHER)))) : PyAddNewEnvCollector.Companion.RequirementsTxtOrSetupPyData.UNCHANGED);
    }

    private static final boolean lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0010\u0010\u0002\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0010\u0010\b\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000f\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0013\u0010\u0011\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u0005H\u00c6\u0003J=\u0010\u0012\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\b\u0002\u0010\b\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u0002\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\b\u001a\f0\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewVirtualEnvFromFilePanel$Data;", "", "path", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/SystemDependent;", "baseSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "requirementsTxtOrSetupPyPath", "(Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;)V", "getBaseSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getPath", "()Ljava/lang/String;", "getRequirementsTxtOrSetupPyPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.python.community.impl"})
    public static final class Data {
        @NotNull
        private final String path;
        @Nullable
        private final Sdk baseSdk;
        @NotNull
        private final String requirementsTxtOrSetupPyPath;

        public Data(@NotNull String path2, @Nullable Sdk baseSdk, @NotNull String requirementsTxtOrSetupPyPath) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)requirementsTxtOrSetupPyPath, (String)"requirementsTxtOrSetupPyPath");
            this.path = path2;
            this.baseSdk = baseSdk;
            this.requirementsTxtOrSetupPyPath = requirementsTxtOrSetupPyPath;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final Sdk getBaseSdk() {
            return this.baseSdk;
        }

        @NotNull
        public final String getRequirementsTxtOrSetupPyPath() {
            return this.requirementsTxtOrSetupPyPath;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @Nullable
        public final Sdk component2() {
            return this.baseSdk;
        }

        @NotNull
        public final String component3() {
            return this.requirementsTxtOrSetupPyPath;
        }

        @NotNull
        public final Data copy(@NotNull String path2, @Nullable Sdk baseSdk, @NotNull String requirementsTxtOrSetupPyPath) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)requirementsTxtOrSetupPyPath, (String)"requirementsTxtOrSetupPyPath");
            return new Data(path2, baseSdk, requirementsTxtOrSetupPyPath);
        }

        public static /* synthetic */ Data copy$default(Data data, String string, Sdk sdk2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = data.path;
            }
            if ((n & 2) != 0) {
                sdk2 = data.baseSdk;
            }
            if ((n & 4) != 0) {
                string2 = data.requirementsTxtOrSetupPyPath;
            }
            return data.copy(string, sdk2, string2);
        }

        @NotNull
        public String toString() {
            return "Data(path=" + this.path + ", baseSdk=" + this.baseSdk + ", requirementsTxtOrSetupPyPath=" + this.requirementsTxtOrSetupPyPath + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + (this.baseSdk == null ? 0 : this.baseSdk.hashCode());
            result2 = result2 * 31 + this.requirementsTxtOrSetupPyPath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)data.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.baseSdk, (Object)data.baseSdk)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.requirementsTxtOrSetupPyPath, (Object)data.requirementsTxtOrSetupPyPath);
        }
    }
}

