/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.run.PyVirtualEnvReaderKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PyTerminalBundle;
import com.jetbrains.python.sdk.PyVirtualEnvTerminalSettings;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ/\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/sdk/PyVirtualEnvTerminalCustomizer;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "()V", "customizeCommandAndEnvironment", "", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "command", "envs", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/lang/String;Ljava/util/Map;)[Ljava/lang/String;", "generateCommandForPowerShell", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkHomePath", "Lcom/intellij/openapi/vfs/VirtualFile;", "powershellName", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)[Ljava/lang/String;", "getCondaActivationCommand", "condaPath", "Ljava/nio/file/Path;", "getConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "isShellIntegrationAvailable", "", "shellPath", "intellij.python.terminal"})
@SourceDebugExtension(value={"SMAP\nPyVirtualEnvTerminalCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyVirtualEnvTerminalCustomizer.kt\ncom/jetbrains/python/sdk/PyVirtualEnvTerminalCustomizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n1#2:183\n10#3:184\n*S KotlinDebug\n*F\n+ 1 PyVirtualEnvTerminalCustomizer.kt\ncom/jetbrains/python/sdk/PyVirtualEnvTerminalCustomizer\n*L\n42#1:184\n*E\n"})
public final class PyVirtualEnvTerminalCustomizer
extends LocalTerminalCustomizer {
    /*
     * Unable to fully structure code
     */
    private final String[] generateCommandForPowerShell(Sdk sdk, VirtualFile sdkHomePath, String powershellName) {
        block7: {
            var5_4 = sdk.getSdkAdditionalData();
            v0 = var5_4 instanceof PythonSdkAdditionalData != false ? (PythonSdkAdditionalData)var5_4 : null;
            if (!((v0 != null ? v0.getFlavor() : null) instanceof CondaEnvSdkFlavor)) break block7;
            v1 = PyCondaPackageService.Companion.getCondaExecutable(sdk.getHomePath());
            if (v1 != null) {
                it = v1;
                $i$a$-let-PyVirtualEnvTerminalCustomizer$generateCommandForPowerShell$condaPath$1 = false;
                v2 = Paths.get(it, new String[0]);
                v3 = v2;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
            } else {
                v3 = null;
            }
            condaPath = v3;
            condaActivationCommand = null;
            if (condaPath == null) ** GOTO lbl-1000
            v4 = new LinkOption[]{};
            if (Files.exists(condaPath, Arrays.copyOf(v4, v4.length)) && Files.isExecutable(condaPath)) {
                condaActivationCommand = this.getCondaActivationCommand(condaPath, sdkHomePath);
            } else lbl-1000:
            // 2 sources

            {
                $i$f$logger = false;
                v5 = Logger.getInstance(PyVirtualEnvTerminalCustomizer.class);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                v5.warn("Can't find " + condaPath + ", will not activate conda");
                var7_5 = new Object[]{"conda"};
                v6 = PyTerminalBundle.message("powershell.conda.not.activated", var7_5);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"message(...)");
                condaActivationCommand = v6;
            }
            var6_10 = new String[]{powershellName, "-ExecutionPolicy", "RemoteSigned", "-NoExit", "-Command", condaActivationCommand};
            return var6_10;
        }
        v7 = sdkHomePath.getParent().findChild("activate.ps1");
        if (v7 == null) {
            return null;
        }
        virtualEnvProfile = v7;
        if (virtualEnvProfile.exists()) {
            var5_4 = new String[6];
            var5_4[0] = powershellName;
            var5_4[1] = "-ExecutionPolicy";
            var5_4[2] = "RemoteSigned";
            var5_4[3] = "-NoExit";
            var5_4[4] = "-File";
            Intrinsics.checkNotNullExpressionValue((Object)virtualEnvProfile.getPath(), (String)"getPath(...)");
            v8 = var5_4;
        } else {
            v8 = null;
        }
        return v8;
    }

    private final String getCondaActivationCommand(Path condaPath, VirtualFile sdkHomePath) {
        Object[] objectArray = new Object[]{condaPath};
        String string = PyTerminalBundle.message("powershell.conda.not.activated", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String errorMessage = StringsKt.replace$default((String)string, (char)'\'', (char)'\"', (boolean)false, (int)4, null);
        return StringsKt.trimIndent((String)("\n        & '" + StringUtil.escapeChar((String)((Object)condaPath).toString(), (char)'\'') + "' shell.powershell hook | Out-String | Invoke-Expression ; \n        try { \n          conda activate '" + StringUtil.escapeChar((String)sdkHomePath.getParent().getPath(), (char)'\'') + "' \n        } catch { \n          Write-Host('" + StringUtil.escapeChar((String)errorMessage, (char)'\'') + "') \n        }\n        "));
    }

    @NotNull
    public String[] customizeCommandAndEnvironment(@NotNull Project project, @Nullable String workingDirectory, @NotNull String[] command, @NotNull Map<String, String> envs) {
        VirtualFile sdkHomePath;
        Sdk sdk2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Ref.ObjectRef sdkByDirectory = new Ref.ObjectRef();
        if (workingDirectory != null) {
            ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<Sdk>)sdkByDirectory, project, workingDirectory){
                final /* synthetic */ Ref.ObjectRef<Sdk> $sdkByDirectory;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $workingDirectory;
                {
                    this.$sdkByDirectory = $sdkByDirectory;
                    this.$project = $project;
                    this.$workingDirectory = $workingDirectory;
                    super(0);
                }

                public final void invoke() {
                    this.$sdkByDirectory.element = PySdkUtil.findSdkForDirectory(this.$project, Paths.get(this.$workingDirectory, new String[0]), false);
                }
            }));
        }
        if ((sdk2 = (Sdk)sdkByDirectory.element) != null && (PythonSdkUtil.isVirtualEnv(sdk2) || PythonSdkUtil.isConda(sdk2)) && PyVirtualEnvTerminalSettings.Companion.getInstance(project).getVirtualEnvActivate() && (sdkHomePath = sdk2.getHomeDirectory()) != null && !(command.length == 0)) {
            String shellPath = command[0];
            Path path2 = Paths.get(shellPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            String shellName = PathsKt.getName((Path)path2);
            Object[] objectArray = new String[]{"powershell.exe", "pwsh.exe"};
            if (ArraysKt.contains((Object[])objectArray, (Object)shellName)) {
                String[] stringArray = this.generateCommandForPowerShell(sdk2, sdkHomePath, shellName);
                if (stringArray == null) {
                    stringArray = command;
                }
                return stringArray;
            }
            if (this.isShellIntegrationAvailable(shellPath)) {
                Pair<String, String> pair = PyVirtualEnvReaderKt.findActivateScript(sdkHomePath.getPath(), shellPath);
                if (pair != null) {
                    Pair<String, String> activate = pair;
                    boolean bl = false;
                    envs.put("JEDITERM_SOURCE", (String)activate.getFirst());
                    String string = (String)activate.getSecond();
                    if (string == null) {
                        string = "";
                    }
                    envs.put("JEDITERM_SOURCE_ARGS", string);
                }
            } else {
                Map<String, String> map = PySdkUtil.activateVirtualEnv(sdk2);
                Intrinsics.checkNotNullExpressionValue(map, (String)"activateVirtualEnv(...)");
                Map<String, String> envVars = map;
                if (envVars.isEmpty()) {
                    Logger.getInstance(PyVirtualEnvTerminalCustomizer.class).warn("No vars found to activate in " + sdk2.getHomePath());
                }
                envs.putAll(envVars);
            }
        }
        return command;
    }

    private final boolean isShellIntegrationAvailable(String shellPath) {
        if (TerminalOptionsProvider.Companion.getInstance().getShellIntegration()) {
            String shellName = new File(shellPath).getName();
            return Intrinsics.areEqual((Object)shellName, (Object)"bash") || SystemInfo.isMac && Intrinsics.areEqual((Object)shellName, (Object)"sh") || Intrinsics.areEqual((Object)shellName, (Object)"zsh") || Intrinsics.areEqual((Object)shellName, (Object)"fish");
        }
        return false;
    }

    @NotNull
    public UnnamedConfigurable getConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new UnnamedConfigurable(project){
            @NotNull
            private final PyVirtualEnvTerminalSettings settings;
            @NotNull
            private JCheckBox myCheckbox;
            {
                this.settings = PyVirtualEnvTerminalSettings.Companion.getInstance($project);
                this.myCheckbox = new JCheckBox(PyTerminalBundle.message("activate.virtualenv.checkbox.text", new Object[0]));
            }

            @NotNull
            public final PyVirtualEnvTerminalSettings getSettings() {
                return this.settings;
            }

            @NotNull
            public final JCheckBox getMyCheckbox() {
                return this.myCheckbox;
            }

            public final void setMyCheckbox(@NotNull JCheckBox jCheckBox) {
                Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"<set-?>");
                this.myCheckbox = jCheckBox;
            }

            @NotNull
            public JCheckBox createComponent() {
                return this.myCheckbox;
            }

            public boolean isModified() {
                return this.myCheckbox.isSelected() != this.settings.getVirtualEnvActivate();
            }

            public void apply() {
                this.settings.setVirtualEnvActivate(this.myCheckbox.isSelected());
            }

            public void reset() {
                this.myCheckbox.setSelected(this.settings.getVirtualEnvActivate());
            }
        };
    }
}

