/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkComparator;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.Comparator;

public class PreferredSdkComparator
implements Comparator<Sdk> {
    public static final PreferredSdkComparator INSTANCE = new PreferredSdkComparator();

    @Override
    public int compare(Sdk o1, Sdk o2) {
        int languageLevelDifference;
        int flavor2weight;
        int venv2weight;
        int detectedWeight2;
        int remote2Weight;
        for (PySdkComparator comparator : PySdkComparator.EP_NAME.getExtensionList()) {
            int result2 = comparator.compare(o1, o2);
            if (result2 == 0) continue;
            return result2;
        }
        PythonSdkFlavor<?> flavor1 = PythonSdkFlavor.getFlavor(o1);
        PythonSdkFlavor<?> flavor2 = PythonSdkFlavor.getFlavor(o2);
        int remote1Weight = PythonSdkUtil.isRemote(o1) ? 0 : 1;
        int n = remote2Weight = PythonSdkUtil.isRemote(o2) ? 0 : 1;
        if (remote1Weight != remote2Weight) {
            return remote2Weight - remote1Weight;
        }
        int detectedWeight1 = o1 instanceof PyDetectedSdk ? 0 : 1;
        int n2 = detectedWeight2 = o2 instanceof PyDetectedSdk ? 0 : 1;
        if (detectedWeight1 != detectedWeight2) {
            return detectedWeight2 - detectedWeight1;
        }
        int venv1weight = PythonSdkUtil.isVirtualEnv(o1) || PythonSdkUtil.isCondaVirtualEnv(o1) ? 0 : 1;
        int n3 = venv2weight = PythonSdkUtil.isVirtualEnv(o2) || PythonSdkUtil.isCondaVirtualEnv(o2) ? 0 : 1;
        if (venv1weight != venv2weight) {
            return venv2weight - venv1weight;
        }
        int flavor1weight = flavor1 instanceof CPythonSdkFlavor ? 1 : 0;
        int n4 = flavor2weight = flavor2 instanceof CPythonSdkFlavor ? 1 : 0;
        if (flavor1weight != flavor2weight) {
            return flavor2weight - flavor1weight;
        }
        if (flavor1 != null && flavor2 != null && (languageLevelDifference = flavor1.getLanguageLevel(o1).compareTo(flavor2.getLanguageLevel(o2))) != 0) {
            return -languageLevelDifference;
        }
        return -Comparing.compare((Comparable)((Object)o1.getVersionString()), (Comparable)((Object)o2.getVersionString()));
    }
}

