/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonTemplateRunner;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddFunctionQuickFix
implements LocalQuickFix {
    private final String myIdentifier;
    private final String myModuleName;

    public AddFunctionQuickFix(@NotNull String identifier, String moduleName) {
        if (identifier == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(0);
        }
        this.myIdentifier = identifier;
        this.myModuleName = moduleName;
    }

    @NotNull
    public String getName() {
        String string = PyPsiBundle.message("QFIX.create.function.in.module", this.myIdentifier, this.myModuleName);
        if (string == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.create.function.in.module", new Object[0]);
        if (string == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(4);
        }
        try {
            PsiElement problemElement = descriptor2.getPsiElement();
            if (!(problemElement instanceof PyQualifiedExpression)) {
                return;
            }
            PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
            if (qualifier == null) {
                PyFromImportStatement fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyFromImportStatement.class);
                if (fromImport == null) {
                    return;
                }
                qualifier = fromImport.getImportSource();
            }
            if (qualifier == null) {
                return;
            }
            PyType type2 = TypeEvalContext.userInitiated(problemElement.getProject(), problemElement.getContainingFile()).getType(qualifier);
            if (!(type2 instanceof PyModuleType)) {
                return;
            }
            PyFile file = ((PyModuleType)type2).getModule();
            PyUtil.sure(file);
            PyUtil.sure(FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file));
            PyFunctionBuilder builder = new PyFunctionBuilder(this.myIdentifier, problemElement);
            PsiElement problemParent = problemElement.getParent();
            if (problemParent instanceof PyCallExpression) {
                PyExpression[] args2;
                PyArgumentList arglist = ((PyCallExpression)problemParent).getArgumentList();
                if (arglist == null) {
                    return;
                }
                for (PyExpression arg : args2 = arglist.getArguments()) {
                    if (arg instanceof PyKeywordArgument) {
                        builder.parameter(((PyKeywordArgument)arg).getKeyword());
                        continue;
                    }
                    if (arg instanceof PyReferenceExpression) {
                        PyReferenceExpression refex = (PyReferenceExpression)arg;
                        builder.parameter(refex.getReferencedName());
                        continue;
                    }
                    builder.parameter("param");
                }
            } else if (problemParent != null) {
                for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                    List<String> params = extension.getFunctionParametersFromUsage(problemElement);
                    if (params == null) continue;
                    for (String param : params) {
                        builder.parameter(param);
                    }
                    break;
                }
            }
            WriteAction.run(() -> {
                PyFunction function = builder.buildFunction();
                function = (PyFunction)file.add(function);
                AddFunctionQuickFix.showTemplateBuilder(function, file);
            });
        }
        catch (IncorrectOperationException ignored) {
            PythonUiService.getInstance().showBalloonError(project, PyPsiBundle.message("QFIX.failed.to.add.function", new Object[0]));
        }
    }

    private static void showTemplateBuilder(PyFunction method, @NotNull PsiFile file) {
        if (file == null) {
            AddFunctionQuickFix.$$$reportNull$$$0(5);
        }
        method = (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)method);
        ParamHelper.walkDownParamArray(method.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        builder.replaceElement((PsiElement)method.getStatementList(), "return None");
        PythonTemplateRunner.runTemplate(file, builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showTemplateBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

