/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ift;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.ift.PythonLessonsBundle;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import com.jetbrains.python.sdk.configuration.PyProjectVirtualEnvConfiguration;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;
import training.statistic.LearningInternalProblems;
import training.statistic.LessonStartingWay;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010!\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J\u001c\u0010$\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010\u0017H\u0016J=\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u00192!\u0010*\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u00120+H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010/\u001a\u0004\u0018\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\u0006\u00100\u001a\u000201H\u0002J\u001e\u00102\u001a\u00020\u00122\u0014\u00103\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00120+H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR:\u0010\u000b\u001a(\u0012\u0004\u0012\u00020\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\u0002\b\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"Lcom/jetbrains/python/ift/PythonBasedLangSupport;", "Ltraining/lang/AbstractLangSupport;", "()V", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "sampleFilePath", "", "getSampleFilePath", "()Ljava/lang/String;", "sdkConfigurationTasks", "Lkotlin/Function2;", "Ltraining/dsl/LessonContext;", "Ltraining/learn/course/KLesson;", "Lkotlin/ParameterName;", "name", "lesson", "", "Lkotlin/ExtensionFunctionType;", "getSdkConfigurationTasks", "()Lkotlin/jvm/functions/Function2;", "applyBaseSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "preferredSdk", "existingSdks", "", "module", "Lcom/intellij/openapi/module/Module;", "applyProjectSdk", "sdk", "checkSdk", "createAndSetVenvSdk", "getExistingSdks", "getSdkForProject", "selectedSdk", "installAndOpenLearningProject", "contentRoot", "Ljava/nio/file/Path;", "projectToClose", "postInitCallback", "Lkotlin/Function1;", "learnProject", "isSdkConfigured", "", "showSdkChoosingDialog", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "startFromWelcomeFrame", "startCallback", "intellij.python.featuresTrainer"})
public abstract class PythonBasedLangSupport
extends AbstractLangSupport {
    @NotNull
    private final ReadMeCreator readMeCreator = new ReadMeCreator();
    @NotNull
    private final String sampleFilePath;
    @NotNull
    private final Function2<LessonContext, KLesson, Unit> sdkConfigurationTasks = (Function2)new Function2<LessonContext, KLesson, Unit>(this){
        final /* synthetic */ PythonBasedLangSupport this$0;
        {
            this.this$0 = $receiver;
            super(2);
        }

        public final void invoke(@NotNull LessonContext $this$null, @NotNull KLesson lesson) {
            Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            $this$null.task((Function1)new Function1<TaskContext, Unit>(this.this$0, lesson){
                final /* synthetic */ PythonBasedLangSupport this$0;
                final /* synthetic */ KLesson $lesson;
                {
                    this.this$0 = $receiver;
                    this.$lesson = $lesson;
                    super(1);
                }

                public final void invoke(@NotNull TaskContext $this$task) {
                    Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                    $this$task.stateCheck((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0){
                        final /* synthetic */ PythonBasedLangSupport this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                            Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                            return this.this$0.isSdkConfigured($this$stateCheck.getProject());
                        }
                    });
                    String configureCallbackId2 = LearningUiManager.INSTANCE.addCallback((Function0)new Function0<Unit>($this$task){
                        final /* synthetic */ TaskContext $this_task;
                        {
                            this.$this_task = $this_task;
                            super(0);
                        }

                        public final void invoke() {
                            Module module = (Module)ArraysKt.singleOrNull((Object[])PyStatisticToolsKt.getModules(this.$this_task.getProject()));
                            if (module == null) {
                                return;
                            }
                            Module module2 = module;
                            PyInterpreterInspection.InterpreterSettingsQuickFix.showPythonInterpreterSettings(this.$this_task.getProject(), module2);
                        }
                    });
                    if (this.this$0.getUseUserProjects() || UtilsKt.isLearningProject((Project)$this$task.getProject(), (String)this.this$0.getPrimaryLanguage())) {
                        Object[] objectArray = new Object[]{configureCallbackId2};
                        TaskContext.showWarning$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("no.interpreter.in.learning.project", objectArray), (boolean)false, (LearningInternalProblems)LearningInternalProblems.NO_SDK_CONFIGURED, (Function1)((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0){
                            final /* synthetic */ PythonBasedLangSupport this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$showWarning) {
                                Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$this$showWarning");
                                return !this.this$0.isSdkConfigured($this$showWarning.getProject());
                            }
                        }), (int)2, null);
                    } else {
                        String openCallbackId2 = LearningUiManager.INSTANCE.addCallback((Function0)new Function0<Unit>($this$task, this.$lesson){
                            final /* synthetic */ TaskContext $this_task;
                            final /* synthetic */ KLesson $lesson;
                            {
                                this.$this_task = $this_task;
                                this.$lesson = $lesson;
                                super(0);
                            }

                            public final void invoke() {
                                CourseManager.Companion.getInstance().openLesson(this.$this_task.getProject(), (Lesson)this.$lesson, LessonStartingWay.NO_SDK_RESTART, true, true);
                            }
                        });
                        Object[] objectArray = new Object[]{openCallbackId2, configureCallbackId2};
                        TaskContext.showWarning$default((TaskContext)$this$task, (String)PythonLessonsBundle.INSTANCE.message("no.interpreter.in.user.project", objectArray), (boolean)false, null, (Function1)((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0){
                            final /* synthetic */ PythonBasedLangSupport this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$showWarning) {
                                Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$this$showWarning");
                                return !this.this$0.isSdkConfigured($this$showWarning.getProject());
                            }
                        }), (int)6, null);
                    }
                }
            });
        }
    };

    public PythonBasedLangSupport() {
        this.sampleFilePath = "src/sandbox.py";
    }

    @NotNull
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    public void installAndOpenLearningProject(@NotNull Path contentRoot, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        OpenProjectTask openProjectTask2 = OpenProjectTaskKt.OpenProjectTask((Function1)((Function1)new Function1<OpenProjectTaskBuilder, Unit>(projectToClose){
            final /* synthetic */ Project $projectToClose;
            {
                this.$projectToClose = $projectToClose;
                super(1);
            }

            public final void invoke(@NotNull OpenProjectTaskBuilder $this$OpenProjectTask) {
                Intrinsics.checkNotNullParameter((Object)$this$OpenProjectTask, (String)"$this$OpenProjectTask");
                $this$OpenProjectTask.setProjectToClose(this.$projectToClose);
                $this$OpenProjectTask.setProjectCreatedWithWizard(true);
            }
        }));
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(contentRoot, (LangSupport)this, openProjectTask2, postInitCallback);
    }

    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (selectedSdk != null) {
            Module module = (Module)ArraysKt.first((Object[])PyStatisticToolsKt.getModules(project));
            List<Sdk> existingSdks = this.getExistingSdks();
            return this.applyBaseSdk(project, selectedSdk, existingSdks, module);
        }
        if (PySdkExtKt.getPythonSdk(project) != null) {
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> PythonBasedLangSupport.getSdkForProject$lambda$0(this, project));
        return null;
    }

    @RequiresBackgroundThread
    private final void createAndSetVenvSdk(Project project) {
        Module module = (Module)ArraysKt.first((Object[])PyStatisticToolsKt.getModules(project));
        List<Sdk> existingSdks = this.getExistingSdks();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks(existingSdks, module, (UserDataHolder)project);
        Sdk preferredSdk = PyProjectVirtualEnvConfiguration.findPreferredVirtualEnvBaseSdk(baseSdks);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, project, preferredSdk, existingSdks, module){
            final /* synthetic */ PythonBasedLangSupport this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Sdk $preferredSdk;
            final /* synthetic */ List<Sdk> $existingSdks;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$preferredSdk = $preferredSdk;
                this.$existingSdks = $existingSdks;
                this.$module = $module;
                super(0);
            }

            public final void invoke() {
                Sdk venvSdk = PythonBasedLangSupport.access$applyBaseSdk(this.this$0, this.$project, this.$preferredSdk, this.$existingSdks, this.$module);
                if (venvSdk != null) {
                    this.this$0.applyProjectSdk(venvSdk, this.$project);
                }
            }
        }), (int)1, null);
    }

    private final Sdk applyBaseSdk(Project project, Sdk preferredSdk, List<? extends Sdk> existingSdks, Module module) {
        Sdk sdk2;
        Sdk venvSdk;
        String string = FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(project.getBasePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String venvRoot = string;
        Sdk sdk3 = venvSdk = PyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously$default(preferredSdk, existingSdks, venvRoot, project.getBasePath(), project, module, (UserDataHolder)project, false, false, null, 896, null);
        if (sdk3 != null) {
            Sdk sdk4;
            Sdk it = sdk4 = sdk3;
            boolean bl = false;
            SdkConfigurationUtil.addSdk((Sdk)it);
            sdk2 = sdk4;
        } else {
            sdk2 = null;
        }
        return sdk2;
    }

    public void applyProjectSdk(@NotNull Sdk sdk2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyProjectSdkConfiguration.INSTANCE.setReadyToUseSdk(project, (Module)ArraysKt.first((Object[])PyStatisticToolsKt.getModules(project)), sdk2);
    }

    private final List<Sdk> getExistingSdks() {
        List<Sdk> list = PyConfigurableInterpreterList.getInstance(null).getAllPythonSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllPythonSdks(...)");
        Iterable iterable = list;
        PreferredSdkComparator preferredSdkComparator = PreferredSdkComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)preferredSdkComparator, (String)"INSTANCE");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)preferredSdkComparator);
    }

    public void checkSdk(@Nullable Sdk sdk2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    public void startFromWelcomeFrame(@NotNull Function1<? super Sdk, Unit> startCallback) {
        Intrinsics.checkNotNullParameter(startCallback, (String)"startCallback");
        Sdk[] sdkArray = PyConfigurableInterpreterList.getInstance(null).getModel().getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getSdks(...)");
        Sdk[] sdkArray2 = sdkArray;
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray2, sdkArray2.length));
        List<Sdk> list = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValidPythonSdks(...)");
        List<Sdk> existingSdks = list;
        ApplicationManager.getApplication().executeOnPooledThread(() -> PythonBasedLangSupport.startFromWelcomeFrame$lambda$2(existingSdks, this, startCallback));
    }

    private final Sdk showSdkChoosingDialog(List<? extends Sdk> existingSdks, UserDataHolder context) {
        PySdkPathChoosingComboBox baseSdkField = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
        JLabel warningPlaceholder = new JLabel();
        JPanel formPanel = FormBuilder.createFormBuilder().addComponent((JComponent)warningPlaceholder).addLabeledComponent(PySdkBundle.message("python.venv.base.label", new Object[0]), (JComponent)((Object)baseSdkField)).getPanel();
        formPanel.setPreferredSize(new Dimension(Math.max(formPanel.getPreferredSize().width, 500), formPanel.getPreferredSize().height));
        Project project = ProjectManager.getInstance().getDefaultProject();
        DialogWrapper dialog2 = new DialogWrapper(formPanel, project){
            final /* synthetic */ JPanel $formPanel;
            {
                this.$formPanel = $formPanel;
                super($super_call_param$1);
                this.setTitle(PyBundle.message("sdk.select.path", new Object[0]));
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                JPanel jPanel = this.$formPanel;
                Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"$formPanel");
                return jPanel;
            }
        };
        PyAddSdkPanelKt.addBaseInterpretersAsync(baseSdkField, existingSdks, null, context, (Function0<Unit>)((Function0)new Function0<Unit>(baseSdkField, warningPlaceholder){
            final /* synthetic */ PySdkPathChoosingComboBox $baseSdkField;
            final /* synthetic */ JLabel $warningPlaceholder;
            {
                this.$baseSdkField = $baseSdkField;
                this.$warningPlaceholder = $warningPlaceholder;
                super(0);
            }

            public final void invoke() {
                Sdk selectedSdk = this.$baseSdkField.getSelectedSdk();
                if (selectedSdk instanceof PySdkToInstall) {
                    PySdkToInstall pySdkToInstall = (PySdkToInstall)selectedSdk;
                    String string = Messages.getOkButton();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOkButton(...)");
                    String installationWarning = pySdkToInstall.getInstallationWarning(string);
                    this.$warningPlaceholder.setText("<html>" + installationWarning + "</html>");
                } else {
                    this.$warningPlaceholder.setText("");
                }
            }
        }));
        dialog2.setTitle(PythonLessonsBundle.INSTANCE.message("choose.python.sdk.to.start.learning.header", new Object[0]));
        return dialog2.showAndGet() ? baseSdkField.getSelectedSdk() : null;
    }

    public boolean isSdkConfigured(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PySdkExtKt.getPythonSdk(project) != null;
    }

    @NotNull
    public Function2<LessonContext, KLesson, Unit> getSdkConfigurationTasks() {
        return this.sdkConfigurationTasks;
    }

    private static final void getSdkForProject$lambda$0(PythonBasedLangSupport this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.createAndSetVenvSdk($project);
    }

    private static final void startFromWelcomeFrame$lambda$2(List $existingSdks, PythonBasedLangSupport this$0, Function1 $startCallback) {
        Intrinsics.checkNotNullParameter((Object)$existingSdks, (String)"$existingSdks");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$startCallback, (String)"$startCallback");
        UserDataHolderBase context = new UserDataHolderBase();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks($existingSdks, null, (UserDataHolder)context);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(baseSdks, this$0, (List<Sdk>)$existingSdks, context, (Function1<? super Sdk, Unit>)$startCallback){
            final /* synthetic */ List<Sdk> $baseSdks;
            final /* synthetic */ PythonBasedLangSupport this$0;
            final /* synthetic */ List<Sdk> $existingSdks;
            final /* synthetic */ UserDataHolderBase $context;
            final /* synthetic */ Function1<Sdk, Unit> $startCallback;
            {
                this.$baseSdks = $baseSdks;
                this.this$0 = $receiver;
                this.$existingSdks = $existingSdks;
                this.$context = $context;
                this.$startCallback = $startCallback;
                super(0);
            }

            public final void invoke() {
                if (this.$baseSdks.isEmpty()) {
                    Sdk sdk2 = PythonBasedLangSupport.access$showSdkChoosingDialog(this.this$0, this.$existingSdks, (UserDataHolder)this.$context);
                    if (sdk2 != null) {
                        this.$startCallback.invoke((Object)sdk2);
                    }
                } else {
                    this.$startCallback.invoke(null);
                }
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ Sdk access$applyBaseSdk(PythonBasedLangSupport $this, Project project, Sdk preferredSdk, List existingSdks, Module module) {
        return $this.applyBaseSdk(project, preferredSdk, existingSdks, module);
    }

    public static final /* synthetic */ Sdk access$showSdkChoosingDialog(PythonBasedLangSupport $this, List existingSdks, UserDataHolder context) {
        return $this.showSdkChoosingDialog(existingSdks, context);
    }
}

