/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarTypeImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocStringTypeProvider
extends PyTypeProviderBase {
    @Override
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull TypeEvalContext context) {
        String typeText;
        PyClass pyClass;
        StructuredDocString docString;
        if (param == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(0);
        }
        if (func == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(2);
        }
        if ((docString = func.getStructuredDocString()) == null && (pyClass = PyUtil.turnConstructorIntoClass(func)) != null) {
            docString = pyClass.getStructuredDocString();
        }
        if (docString != null && StringUtil.isNotEmpty((String)(typeText = docString.getParamType(param.getName())))) {
            Ref<PyType> typeRef = this.parseType(func, typeText, context);
            if (param.isPositionalContainer()) {
                return Ref.create((Object)PyTypeUtil.toPositionalContainerType(param, (PyType)typeRef.get()));
            }
            if (param.isKeywordContainer()) {
                return Ref.create((Object)PyTypeUtil.toKeywordContainerType(param, (PyType)typeRef.get()));
            }
            return typeRef;
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getReturnType(@NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        String typeText;
        StructuredDocString docString;
        if (callable == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(4);
        }
        if (callable instanceof PyDocStringOwner && (docString = ((PyDocStringOwner)((Object)callable)).getStructuredDocString()) != null && StringUtil.isNotEmpty((String)(typeText = docString.getReturnType()))) {
            Ref<PyType> typeRef = this.parseType(callable, typeText, context);
            if (callable instanceof PyFunction) {
                return Ref.create((Object)PyTypingTypeProvider.toAsyncIfNeeded((PyFunction)callable, (PyType)typeRef.get()));
            }
            return typeRef;
        }
        return null;
    }

    @NotNull
    private Ref<PyType> parseType(@NotNull PyCallable callable, @NotNull String typeText, @NotNull TypeEvalContext context) {
        PyType type2;
        if (callable == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(5);
        }
        if (typeText == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(7);
        }
        if ((type2 = PyTypeParser.getTypeByName((PsiElement)callable, typeText, context)) != null) {
            type2.assertValid("from docstring");
        }
        this.setTypeVarScopeOwners(type2, callable, context);
        Ref ref = Ref.create((Object)type2);
        if (ref == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(8);
        }
        return ref;
    }

    @Override
    @Nullable
    public PyType getGenericType(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyType returnType;
        PyFunction init;
        if (cls == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(10);
        }
        if ((init = cls.findInitOrNew(true, context)) != null && (returnType = (PyType)Ref.deref(this.getReturnType(init, context))) instanceof PyCollectionType) {
            return returnType;
        }
        return null;
    }

    private void setTypeVarScopeOwners(@Nullable PyType type2, @NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        PyType classGenericType;
        if (callable == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyDocStringTypeProvider.$$$reportNull$$$0(12);
        }
        if (!(callable instanceof PyFunction)) {
            return;
        }
        PyFunction pyFunction = (PyFunction)callable;
        PyTypeChecker.Generics typeParameters = PyTypeChecker.collectGenerics(type2, context);
        if (typeParameters.isEmpty()) {
            return;
        }
        PyClass pyClass = pyFunction.getContainingClass();
        Function<PyGenericType, PyQualifiedNameOwner> findScopeOwner = typeVar -> pyFunction;
        if (PyUtil.isInitOrNewMethod((PsiElement)callable)) {
            findScopeOwner = typeVar -> pyClass;
        } else if (pyClass != null && (classGenericType = this.getGenericType(pyClass, context)) != null) {
            PyTypeChecker.Generics classTypeParameters = PyTypeChecker.collectGenerics(classGenericType, context);
            Set classTypeVarNames = ContainerUtil.map2Set(classTypeParameters.getTypeVars(), PyGenericType::getName);
            findScopeOwner = typeVar -> classTypeVarNames.contains(typeVar.getName()) ? pyClass : pyFunction;
        }
        for (PyTypeParameterType typeParam : typeParameters.getAllTypeParameters()) {
            if (!(typeParam instanceof PyTypeVarTypeImpl)) continue;
            PyTypeVarTypeImpl typeVar2 = (PyTypeVarTypeImpl)typeParam;
            typeVar2.setScopeOwner(findScopeOwner.apply(typeVar2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocStringTypeProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocStringTypeProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGenericType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTypeVarScopeOwners";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

