/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.ReplaceSubstringFunction;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a`\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\rj\b\u0012\u0004\u0012\u00020\u0002`\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\r0\u00112 \u0010\u0012\u001a\u001c\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0002\u0018\u00010\rj\n\u0012\u0004\u0012\u00020\u0002\u0018\u0001`\u000f2\u0006\u0010\u0013\u001a\u00020\u0002\u001a&\u0010\f\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002\u001a&\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e\u001a(\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b\u001a\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0010\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020 \u001a\"\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001e\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$\u001a \u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020%H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u001f\u001a\u0004\u0018\u00010(\u001a\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u000e\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-\u001a\u000e\u0010.\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 \u001a\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202\u001a\u001c\u0010/\u001a\u0002002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a8\u00063"}, d2={"addDefaultEnvironments", "", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "envs", "appendBasicMappings", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/intellij/remote/RemoteSdkProperties;", "constructPyPathAndWorkingDirCommand", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "pythonPath", "", "workingDirFunction", "command", "workingDir", "createTargetEnvironmentPathMapper", "consoleSettings", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "targetEnvironment", "findPythonSdkAndModule", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/module/Module;", "contextModule", "getConsoleCommunication", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "element", "Lcom/intellij/psi/PsiElement;", "getConsoleSdk", "getPathMapper", "remoteSdkAdditionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "getPythonConsoleData", "Lcom/jetbrains/python/parsing/console/PythonConsoleData;", "Lcom/intellij/lang/ASTNode;", "hasConsoleKey", "", "isConsoleView", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInPydevConsole", "setCorrectStdOutEncoding", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.python.community.impl"})
@JvmName(name="PydevConsoleRunnerUtil")
public final class PydevConsoleRunnerUtil {
    @NotNull
    public static final PyRemotePathMapper createTargetEnvironmentPathMapper(@NotNull Project project, @NotNull Sdk sdk2, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @NotNull TargetEnvironment targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        PyRemotePathMapper pyRemotePathMapper = PydevConsoleRunnerUtil.getPathMapper(project, sdk2, consoleSettings);
        if (pyRemotePathMapper == null) {
            pyRemotePathMapper = new PyRemotePathMapper();
        }
        PyRemotePathMapper pathMapper = pyRemotePathMapper;
        for (TargetEnvironment.UploadableVolume volume : targetEnvironment.getUploadVolumes().values()) {
            pathMapper.addMapping(((Object)volume.getLocalRoot()).toString(), volume.getTargetRoot(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return pathMapper;
    }

    @Nullable
    public static final PyRemotePathMapper getPathMapper(@NotNull Project project, @Nullable Sdk sdk2, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        if (sdk2 == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        return sdkAdditionalData instanceof PyTargetAwareAdditionalData ? PydevConsoleRunnerUtil.getPathMapper(project, consoleSettings, (PyTargetAwareAdditionalData)sdkAdditionalData) : (sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase ? PydevConsoleRunnerUtil.getPathMapper(project, consoleSettings, (PyRemoteSdkAdditionalDataBase)sdkAdditionalData) : null);
    }

    private static final PyRemotePathMapper getPathMapper(Project project, PyConsoleOptions.PyConsoleSettings consoleSettings, PyTargetAwareAdditionalData data) {
        PyRemotePathMapper remotePathMapper;
        block0: {
            remotePathMapper = PydevConsoleRunnerUtil.appendBasicMappings(project, data);
            PathMappingSettings pathMappingSettings = consoleSettings.getMappingSettings();
            if (pathMappingSettings == null) break block0;
            PathMappingSettings mappingSettings = pathMappingSettings;
            boolean bl = false;
            remotePathMapper.addAll(mappingSettings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return remotePathMapper;
    }

    private static final PyRemotePathMapper appendBasicMappings(Project project, RemoteSdkProperties data) {
        PyRemotePathMapper pathMapper = new PyRemotePathMapper();
        PythonRemoteInterpreterManager.addHelpersMapping(data, pathMapper);
        pathMapper.addAll(data.getPathMappings().getPathMappings(), PyRemotePathMapper.PyPathMappingType.SYS_PATH);
        RemoteMappingsManager.Mappings mappings = RemoteMappingsManager.getInstance((Project)project).getForServer("python", data.getSdkId());
        if (mappings != null) {
            pathMapper.addAll(mappings.getSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return pathMapper;
    }

    @NotNull
    public static final PyRemotePathMapper getPathMapper(@NotNull Project project, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @NotNull PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        Intrinsics.checkNotNullParameter((Object)remoteSdkAdditionalData, (String)"remoteSdkAdditionalData");
        PyRemotePathMapper pyRemotePathMapper = PythonRemoteInterpreterManager.appendBasicMappings(project, null, remoteSdkAdditionalData);
        Intrinsics.checkNotNullExpressionValue((Object)pyRemotePathMapper, (String)"appendBasicMappings(...)");
        PyRemotePathMapper remotePathMapper = pyRemotePathMapper;
        PathMappingSettings mappingSettings = consoleSettings.getMappingSettings();
        if (mappingSettings != null) {
            remotePathMapper.addAll(mappingSettings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return remotePathMapper;
    }

    @NotNull
    public static final Pair<Sdk, Module> findPythonSdkAndModule(@NotNull Project project, @Nullable Module contextModule) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk2 = null;
        Module module = null;
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"getPythonConsoleSettings(...)");
        PyConsoleOptions.PyConsoleSettings settings = pyConsoleSettings;
        String sdkHome = settings.getSdkHome();
        if (sdkHome != null) {
            sdk2 = PythonSdkUtil.findSdkByPath(sdkHome);
            if (settings.getModuleName() != null) {
                ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
                String string = settings.getModuleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
                module = moduleManager.findModuleByName(string);
            } else {
                module = contextModule;
                if (module == null && !(ModuleManager.Companion.getInstance(project).getModules().length == 0)) {
                    module = ModuleManager.Companion.getInstance(project).getModules()[0];
                }
            }
        }
        if (sdk2 == null && settings.isUseModuleSdk()) {
            if (contextModule != null) {
                module = contextModule;
            } else if (settings.getModuleName() != null) {
                ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
                String string = settings.getModuleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
                module = moduleManager.findModuleByName(string);
            }
            if (module != null && PythonSdkUtil.findPythonSdk(module) != null) {
                sdk2 = PythonSdkUtil.findPythonSdk(module);
            }
        } else if (contextModule != null) {
            if (module == null) {
                module = contextModule;
            }
            if (sdk2 == null) {
                sdk2 = PythonSdkUtil.findPythonSdk(module);
            }
        }
        if (sdk2 == null) {
            for (Module m : ModuleManager.Companion.getInstance(project).getModules()) {
                if (PythonSdkUtil.findPythonSdk(m) == null) continue;
                sdk2 = PythonSdkUtil.findPythonSdk(m);
                module = m;
                break;
            }
        }
        if (sdk2 == null && PythonSdkUtil.getAllSdks().size() > 0) {
            sdk2 = PythonSdkUtil.getAllSdks().get(0);
        }
        Pair pair = Pair.create((Object)sdk2, (Object)module);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    @NotNull
    public static final String constructPyPathAndWorkingDirCommand(@NotNull Collection<String> pythonPath, @Nullable String workingDir, @NotNull String command) {
        Intrinsics.checkNotNullParameter(pythonPath, (String)"pythonPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (workingDir != null) {
            pythonPath.add(workingDir);
        }
        String path2 = CollectionsKt.joinToString$default((Iterable)pythonPath, (CharSequence)", ", null, null, (int)0, null, (Function1)constructPyPathAndWorkingDirCommand.path.1.INSTANCE, (int)30, null);
        return StringsKt.replace$default((String)command, (String)"WORKING_DIR_AND_PYTHON_PATHS", (String)path2, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final Function<TargetEnvironment, String> constructPyPathAndWorkingDirCommand(@NotNull Collection<Function<TargetEnvironment, String>> pythonPath, @Nullable Function<TargetEnvironment, String> workingDirFunction, @NotNull String command) {
        Intrinsics.checkNotNullParameter(pythonPath, (String)"pythonPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (workingDirFunction != null) {
            pythonPath.add(workingDirFunction);
        }
        Function path2 = TargetEnvironmentFunctions.andThenJoinToString((Function)TargetEnvironmentFunctions.toLinkedSetFunction((Iterable)pythonPath), (CharSequence)", ", (Function1)constructPyPathAndWorkingDirCommand.path.2.INSTANCE);
        return (Function)((Object)new ReplaceSubstringFunction(command, "WORKING_DIR_AND_PYTHON_PATHS", path2));
    }

    @NotNull
    public static final Map<String, String> addDefaultEnvironments(@NotNull Sdk sdk2, @NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        PydevConsoleRunnerUtil.setCorrectStdOutEncoding(envs);
        PythonEnvUtil.initPythonPath(envs, true, (Collection<String>)PythonCommandLineState.getAddedPaths(sdk2));
        return envs;
    }

    private static final void setCorrectStdOutEncoding(Map<String, String> envs) {
        Charset defaultCharset = PydevConsoleRunnerImpl.CONSOLE_CHARSET;
        String encoding = defaultCharset.name();
        PythonEnvUtil.setPythonIOEncoding(PythonEnvUtil.setPythonUnbuffered(envs), encoding);
    }

    public static final void setCorrectStdOutEncoding(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Charset defaultCharset = PydevConsoleRunnerImpl.CONSOLE_CHARSET;
        commandLine.setCharset(defaultCharset);
        PythonEnvUtil.setPythonIOEncoding(commandLine.getEnvironment(), defaultCharset.name());
    }

    public static final boolean isInPydevConsole(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PydevConsoleElement || PydevConsoleRunnerUtil.getConsoleCommunication(element) != null || PydevConsoleRunnerUtil.hasConsoleKey(element);
    }

    private static final boolean hasConsoleKey(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2.getVirtualFile() == null) {
            return false;
        }
        Boolean inConsole = (Boolean)element.getContainingFile().getVirtualFile().getUserData(PythonConsoleView.CONSOLE_KEY);
        return inConsole != null && inConsole != false;
    }

    public static final boolean isConsoleView(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getUserData(PythonConsoleView.CONSOLE_KEY), (Object)true);
    }

    @Nullable
    public static final PythonConsoleData getPythonConsoleData(@Nullable ASTNode element) {
        if (element == null || element.getPsi() == null || element.getPsi().getContainingFile() == null) {
            return null;
        }
        VirtualFile virtualFile = PydevConsoleRunnerImpl.getConsoleFile(element.getPsi().getContainingFile());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return (PythonConsoleData)file.getUserData(PyConsoleUtil.PYTHON_CONSOLE_DATA);
    }

    private static final ConsoleCommunication getConsoleCommunication(PsiElement element) {
        PsiFile containingFile;
        PsiFile psiFile = containingFile = element.getContainingFile();
        return psiFile != null ? (ConsoleCommunication)psiFile.getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY) : null;
    }

    @Nullable
    public static final Sdk getConsoleSdk(@NotNull PsiElement element) {
        PsiFile containingFile;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = containingFile = element.getContainingFile();
        return psiFile != null ? (Sdk)psiFile.getCopyableUserData(PydevConsoleRunner.CONSOLE_SDK) : null;
    }
}

