/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.ConditionUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 I2\u00020\u0001:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001fH\u0002J \u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(H\u0016J\b\u00100\u001a\u000201H\u0016J \u00102\u001a\u00020-2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0002J \u00105\u001a\u00020-2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(2\u0006\u00106\u001a\u000207H\u0002J(\u00108\u001a\u00020-2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(2\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u00020\u001fH\u0002J(\u0010:\u001a\u00020-2\u0006\u0010)\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(2\u0006\u00106\u001a\u000207H\u0002J \u0010;\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u00062\u0006\u00106\u001a\u000207H\u0002J\u0018\u0010>\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u0010?\u001a\u00020\u0006H\u0002J\u0010\u0010@\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0002J\u0014\u0010A\u001a\u00020-*\u00020B2\u0006\u0010C\u001a\u00020\u0005H\u0002J\u000e\u0010D\u001a\u0004\u0018\u00010\u001f*\u00020\u0006H\u0002J\u0013\u0010E\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\bF*\u00020\u0006H\u0002J\u0014\u0010G\u001a\u00020\u000e*\u00020\u00062\u0006\u00109\u001a\u00020\u001fH\u0002J\f\u0010H\u001a\u00020-*\u00020\u0006H\u0002R\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\n*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u000e*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0018\u0010\u0011\u001a\u00020\u000e*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u000e*\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u000e*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u000e*\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u001f\u0010\u0018\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0019*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0018\u0010\u001e\u001a\u00020\u001f*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001f\u0010\"\u001a\t\u0018\u00010#\u00a2\u0006\u0002\b\u0019*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006J"}, d2={"Lcom/jetbrains/python/codeInsight/intentions/PyInvertIfConditionIntention;", "Lcom/jetbrains/python/codeInsight/intentions/PyBaseIntentionAction;", "()V", "attachedComments", "", "Lcom/intellij/psi/PsiComment;", "Lcom/intellij/psi/PsiElement;", "getAttachedComments", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "childComment", "Lkotlin/internal/NoInfer;", "getChildComment", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiComment;", "isAttachedServiceComment", "", "(Lcom/intellij/psi/PsiComment;)Z", "isInlineServiceComment", "isPylintComment", "isTerminableStatement", "(Lcom/intellij/psi/PsiElement;)Z", "isTerminated", "Lcom/jetbrains/python/psi/PyStatementList;", "(Lcom/jetbrains/python/psi/PyStatementList;)Z", "isTerminationStatement", "lastSignificantChild", "Lorg/jetbrains/annotations/Nullable;", "getLastSignificantChild", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "nextMovableSibling", "getNextMovableSibling", "parentStatementListContainer", "Lcom/jetbrains/python/psi/PyStatementListContainer;", "getParentStatementListContainer", "(Lcom/intellij/psi/PsiElement;)Lcom/jetbrains/python/psi/PyStatementListContainer;", "prevSignificantNode", "Lcom/intellij/lang/ASTNode;", "getPrevSignificantNode", "(Lcom/intellij/lang/ASTNode;)Lcom/intellij/lang/ASTNode;", "createTerminationStatement", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "targetStatement", "doInvoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "", "invertConditional", "expression", "Lcom/jetbrains/python/psi/PyConditionalExpression;", "invertIfStatementComplete", "statement", "Lcom/jetbrains/python/psi/PyIfStatement;", "invertIfStatementFollowup", "terminableStatement", "invertIfStatementIncomplete", "isAvailable", "isAvailableForIfStatement", "element", "switchAttachedComments", "oppositeAnchor", "switchInlineComments", "appendInlineComment", "Lcom/jetbrains/python/psi/PyStatementPart;", "comment", "findTerminableParent", "findTerminationStatement", "Lorg/jetbrains/annotations/NotNull;", "isValuableTerminationStatement", "trimTrailingWhiteSpace", "Companion", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyInvertIfConditionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyInvertIfConditionIntention.kt\ncom/jetbrains/python/codeInsight/intentions/PyInvertIfConditionIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,383:1\n74#2:384\n74#2:385\n74#2:407\n74#2:408\n74#2:409\n74#2:416\n1#3:386\n3630#4,10:387\n1109#4,2:410\n1282#4,2:414\n4098#4,11:424\n5135#4,6:437\n959#5,7:397\n1747#5,3:404\n959#5,7:417\n1549#5:443\n1620#5,3:444\n179#6,2:412\n179#6,2:435\n*S KotlinDebug\n*F\n+ 1 PyInvertIfConditionIntention.kt\ncom/jetbrains/python/codeInsight/intentions/PyInvertIfConditionIntention\n*L\n50#1:384\n57#1:385\n93#1:407\n99#1:408\n280#1:409\n340#1:416\n72#1:387,10\n282#1:410,2\n318#1:414,2\n346#1:424,11\n376#1:437,6\n73#1:397,7\n74#1:404,3\n343#1:417,7\n377#1:443\n377#1:444,3\n316#1:412,2\n360#1:435,2\n*E\n"})
public final class PyInvertIfConditionIntention
extends PyBaseIntentionAction {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet insignificantTokenSet;
    @Deprecated
    @NotNull
    public static final String PYLINT_COMMENT_PREFIX = "# pylint:";

    public PyInvertIfConditionIntention() {
        this.setText(PyPsiBundle.message("INTN.invert.if.condition", new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement psiElement = file.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement == null) {
            return false;
        }
        PsiElement $this$parentsOfType_u24default$iv = element = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        PyConditionalExpression conditionalExpression = (PyConditionalExpression)SequencesKt.firstOrNull((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, PyConditionalExpression.class, (boolean)withSelf$iv));
        if (conditionalExpression != null) {
            if (conditionalExpression.getCondition() == null) return false;
            if (conditionalExpression.getFalsePart() == null) return false;
            PyExpression pyExpression = conditionalExpression.getCondition();
            Intrinsics.checkNotNull((Object)pyExpression);
            if (!ConditionUtil.isValidConditionExpression(pyExpression)) return false;
            return true;
        }
        PsiElement $this$parentsOfType_u24default$iv2 = element;
        boolean withSelf$iv2 = true;
        boolean $i$f$parentsOfType2 = false;
        PyIfStatement ifStatement = (PyIfStatement)SequencesKt.firstOrNull((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv2, PyIfStatement.class, (boolean)withSelf$iv2));
        if (ifStatement == null) return false;
        PyIfPart[] pyIfPartArray = ifStatement.getElifParts();
        Intrinsics.checkNotNullExpressionValue((Object)pyIfPartArray, (String)"getElifParts(...)");
        if (((Object[])pyIfPartArray).length != 0) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!this.isAvailableForIfStatement(element, ifStatement)) return false;
        PyExpression pyExpression = ifStatement.getIfPart().getCondition();
        if (pyExpression == null) return true;
        PyExpression p0 = pyExpression;
        boolean bl2 = false;
        boolean bl3 = ConditionUtil.isValidConditionExpression(p0);
        if (!bl3) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAvailableForIfStatement(PsiElement element, PyIfStatement statement) {
        boolean containsConditionErrors;
        if (statement.getIfPart().getCondition() != null) {
            boolean bl;
            void $this$any$iv;
            Iterable $this$takeWhile$iv;
            Iterable $this$dropWhile$iv;
            PsiElement[] psiElementArray = statement.getIfPart().getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] objectArray = psiElementArray;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList<void> list$iv = new ArrayList<void>();
            for (void item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                PsiElement it = (PsiElement)item$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)statement.getIfPart().getCondition())) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            $this$dropWhile$iv = CollectionsKt.drop((Iterable)list$iv, (int)1);
            boolean $i$f$takeWhile = false;
            ArrayList list$iv2 = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                PsiElement it = (PsiElement)item$iv;
                boolean bl3 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)statement.getIfPart().getStatementList()))) break;
                list$iv2.add(item$iv);
            }
            $this$takeWhile$iv = list$iv2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl4 = false;
                    if (!(it instanceof PsiErrorElement)) continue;
                    return false;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
        }
        boolean bl = containsConditionErrors = false;
        if (containsConditionErrors) {
            return false;
        }
        Sequence parents2 = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.parents((PsiElement)element, (boolean)false), (Function1)((Function1)new Function1<PsiElement, Boolean>(statement){
            final /* synthetic */ PyIfStatement $statement;
            {
                this.$statement = $statement;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)this.$statement);
            }
        }));
        PyStatementList pyStatementList = statement.getIfPart().getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"getStatementList(...)");
        if (SequencesKt.contains((Sequence)parents2, (Object)pyStatementList)) {
            return false;
        }
        PyElsePart elsePart = statement.getElsePart();
        if (elsePart == null) return true;
        PyStatementList pyStatementList2 = elsePart.getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList2, (String)"getStatementList(...)");
        if (SequencesKt.contains((Sequence)parents2, (Object)pyStatementList2)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doInvoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        block9: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                v0 = file.findElementAt(editor.getCaretModel().getOffset());
                if (v0 == null) {
                    return;
                }
                $this$parentsOfType_u24default$iv = element = v0;
                withSelf$iv = true;
                $i$f$parentsOfType = false;
                conditionalExpression = (PyConditionalExpression)SequencesKt.firstOrNull((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, PyConditionalExpression.class, (boolean)withSelf$iv));
                if (conditionalExpression != null) {
                    this.invertConditional(project, file, conditionalExpression);
                    return;
                }
                $this$parentsOfType_u24default$iv = element;
                withSelf$iv = true;
                $i$f$parentsOfType = false;
                ifStatement = (PyIfStatement)SequencesKt.firstOrNull((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, PyIfStatement.class, (boolean)withSelf$iv));
                if (ifStatement == null) break block9;
                elsePart = ifStatement.getElsePart();
                if (elsePart != null) {
                    this.invertIfStatementComplete(project, file, ifStatement);
                    return;
                }
                terminableStatement = this.findTerminableParent((PsiElement)ifStatement);
                if (terminableStatement == null) {
                    this.invertIfStatementIncomplete(project, editor, file, ifStatement);
                    return;
                }
                v1 = ifStatement.getIfPart().getStatementList();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getStatementList(...)");
                ifIsTerminated = this.isTerminated(v1);
                if (!ifIsTerminated) {
                    v2 = ifStatement.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getParent(...)");
                    if (!Intrinsics.areEqual((Object)this.getLastSignificantChild(v2), (Object)ifStatement)) {
                        this.invertIfStatementIncomplete(project, editor, file, ifStatement);
                        return;
                    }
                }
                if (!ifIsTerminated) break block10;
                it = this.getParentStatementListContainer((PsiElement)ifStatement);
                $i$a$-let-PyInvertIfConditionIntention$doInvoke$1 = false;
                if (this.isTerminableStatement((PsiElement)it)) ** GOTO lbl-1000
                v3 = it.getStatementList();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getStatementList(...)");
                if (!this.isTerminated(v3)) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (v4) {
                    this.invertIfStatementIncomplete(project, editor, file, ifStatement);
                    return;
                }
            }
            this.invertIfStatementFollowup(project, file, ifStatement, terminableStatement);
            return;
        }
        throw new IncorrectOperationException("Is not a condition");
    }

    private final void invertConditional(Project project, PsiFile file, PyConditionalExpression expression) {
        PyExpression falsePart = expression.getFalsePart();
        if (falsePart != null) {
            PyExpression pyExpression = expression.getCondition();
            if (pyExpression != null) {
                PyExpression it = pyExpression;
                boolean bl = false;
                it.replace((PsiElement)ConditionUtil.getInvertedConditionExpression(project, file, it));
            }
            PsiElement originalFalsePart = falsePart.copy();
            falsePart.replace((PsiElement)expression.getTruePart());
            expression.getTruePart().replace(originalFalsePart);
        }
    }

    private final void invertIfStatementComplete(Project project, PsiFile file, PyIfStatement statement) {
        PyExpression pyExpression = statement.getIfPart().getCondition();
        if (pyExpression != null) {
            PyExpression it = pyExpression;
            boolean bl = false;
            it.replace((PsiElement)ConditionUtil.getInvertedConditionExpression(project, file, it));
        }
        PyStatementList pyStatementList = statement.getIfPart().getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"getStatementList(...)");
        PyStatementList ifStatements = pyStatementList;
        PyElsePart pyElsePart = statement.getElsePart();
        Intrinsics.checkNotNull((Object)pyElsePart);
        PyStatementList pyStatementList2 = pyElsePart.getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList2, (String)"getStatementList(...)");
        PyStatementList elseStatements = pyStatementList2;
        PsiElement ifLastChild = ifStatements.getLastChild();
        PsiElement elseLastChild = elseStatements.getLastChild();
        elseStatements.addRange(ifStatements.getFirstChild(), ifLastChild);
        ifStatements.addRange(elseStatements.getFirstChild(), elseLastChild);
        ifStatements.deleteChildRange(ifStatements.getFirstChild(), ifLastChild);
        elseStatements.deleteChildRange(elseStatements.getFirstChild(), elseLastChild);
        PyElsePart pyElsePart2 = statement.getElsePart();
        Intrinsics.checkNotNull((Object)pyElsePart2);
        this.switchAttachedComments(statement, (PsiElement)pyElsePart2);
        this.switchInlineComments(statement);
    }

    private final void invertIfStatementIncomplete(Project project, Editor editor2, PsiFile file, PyIfStatement statement) {
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"forElement(...)");
        LanguageLevel level = languageLevel;
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        PyIfStatement pyIfStatement = generator.createFromText(level, PyIfStatement.class, "if a:\n\tpass\nelse:\n\tpass");
        Intrinsics.checkNotNullExpressionValue((Object)pyIfStatement, (String)"createFromText(...)");
        PyIfStatement completeStatement = pyIfStatement;
        PyExpression condition2 = statement.getIfPart().getCondition();
        if (condition2 != null) {
            PyExpression invertedCondition = ConditionUtil.getInvertedConditionExpression(project, file, condition2);
            PyExpression pyExpression = completeStatement.getIfPart().getCondition();
            Intrinsics.checkNotNull((Object)pyExpression);
            pyExpression.replace((PsiElement)invertedCondition);
        } else {
            PyExpression pyExpression = completeStatement.getIfPart().getCondition();
            Intrinsics.checkNotNull((Object)pyExpression);
            pyExpression.delete();
        }
        PyElsePart pyElsePart = completeStatement.getElsePart();
        Intrinsics.checkNotNull((Object)pyElsePart);
        pyElsePart.getStatementList().replace((PsiElement)statement.getIfPart().getStatementList());
        PyIfPart pyIfPart = statement.getIfPart();
        Intrinsics.checkNotNullExpressionValue((Object)pyIfPart, (String)"getIfPart(...)");
        PsiComment ifComment = this.getChildComment((PsiElement)pyIfPart);
        if (ifComment != null) {
            PyElsePart pyElsePart2 = completeStatement.getElsePart();
            Intrinsics.checkNotNull((Object)pyElsePart2);
            this.appendInlineComment(pyElsePart2, ifComment);
        }
        PsiElement psiElement = statement.replace((PsiElement)completeStatement);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyIfStatement");
        PyIfStatement newStatement = (PyIfStatement)psiElement;
        PyElsePart pyElsePart3 = newStatement.getElsePart();
        Intrinsics.checkNotNull((Object)pyElsePart3);
        this.switchAttachedComments(newStatement, (PsiElement)pyElsePart3);
        TextRange passStatementRange = newStatement.getIfPart().getStatementList().getStatements()[0].getTextRange();
        editor2.getCaretModel().getPrimaryCaret().setSelection(passStatementRange.getStartOffset(), passStatementRange.getEndOffset());
        editor2.getCaretModel().getPrimaryCaret().moveToOffset(passStatementRange.getEndOffset());
    }

    private final void invertIfStatementFollowup(Project project, PsiFile file, PyIfStatement statement, PyStatementListContainer terminableStatement) {
        PsiElement followupTerminator;
        PyExpression pyExpression = statement.getIfPart().getCondition();
        if (pyExpression != null) {
            PyExpression it = pyExpression;
            boolean bl = false;
            it.replace((PsiElement)ConditionUtil.getInvertedConditionExpression(project, file, it));
        }
        PyStatementList pyStatementList = statement.getIfPart().getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"getStatementList(...)");
        PyStatementList ifStatements = pyStatementList;
        PsiElement parent = statement.getParent();
        PsiElement ifFirstChild = ifStatements.getFirstChild();
        PsiElement ifLastChild = ifStatements.getLastChild();
        PsiElement followupFirstChild = this.getNextMovableSibling((PsiElement)statement);
        PsiElement followupLastChild = parent.getLastChild();
        parent.addRange(ifFirstChild, ifLastChild);
        if (followupFirstChild != null) {
            ifStatements.addRange(followupFirstChild, followupLastChild);
        }
        PsiElement psiElement = this.getNextMovableSibling((PsiElement)statement);
        Intrinsics.checkNotNull((Object)psiElement);
        this.switchAttachedComments(statement, psiElement);
        ifStatements.deleteChildRange(ifFirstChild, ifLastChild);
        if (followupFirstChild != null) {
            parent.deleteChildRange(followupFirstChild, followupLastChild);
        }
        PsiElement psiElement2 = statement.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
        if (this.isTerminationStatement(this.getLastSignificantChild(psiElement2))) {
            PsiElement psiElement3 = statement.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getParent(...)");
            v5 = this.getLastSignificantChild(psiElement3);
        } else {
            v5 = followupTerminator = null;
        }
        if (followupTerminator != null && !this.isValuableTerminationStatement(followupTerminator, terminableStatement)) {
            followupTerminator.delete();
            PsiElement psiElement4 = statement.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getParent(...)");
            this.trimTrailingWhiteSpace(psiElement4);
        }
        if (!this.isTerminated(ifStatements)) {
            PsiElement psiElement5 = statement.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"getParent(...)");
            if (!Intrinsics.areEqual((Object)this.getLastSignificantChild(psiElement5), (Object)statement) && this.findTerminationStatement((PsiElement)ifStatements) == null) {
                ifStatements.add(this.createTerminationStatement(file, project, terminableStatement));
            }
        }
        CodeEditUtil.markToReformat((ASTNode)parent.getNode(), (boolean)true);
        CodeEditUtil.markToReformat((ASTNode)ifStatements.getNode(), (boolean)true);
    }

    private final void switchAttachedComments(PyIfStatement statement, PsiElement oppositeAnchor) {
        List<PsiComment> oppositeComments = this.getAttachedComments(oppositeAnchor);
        List<PsiComment> ifComments = this.getAttachedComments((PsiElement)statement);
        if (!((Collection)ifComments).isEmpty()) {
            oppositeAnchor.getParent().addRangeBefore((PsiElement)CollectionsKt.first(ifComments), (PsiElement)CollectionsKt.last(ifComments), oppositeAnchor);
            statement.getParent().deleteChildRange((PsiElement)CollectionsKt.first(ifComments), (PsiElement)CollectionsKt.last(ifComments));
        }
        if (!((Collection)oppositeComments).isEmpty()) {
            statement.getParent().addRangeBefore((PsiElement)CollectionsKt.first(oppositeComments), (PsiElement)CollectionsKt.last(oppositeComments), (PsiElement)statement);
            oppositeAnchor.getParent().deleteChildRange((PsiElement)CollectionsKt.first(oppositeComments), (PsiElement)CollectionsKt.last(oppositeComments));
        }
    }

    private final void switchInlineComments(PyIfStatement statement) {
        PsiComment elseComment;
        PsiComment ifComment;
        PyElsePart elsePart;
        PyIfPart ifPart;
        block7: {
            block6: {
                PyIfPart pyIfPart = statement.getIfPart();
                Intrinsics.checkNotNullExpressionValue((Object)pyIfPart, (String)"getIfPart(...)");
                ifPart = pyIfPart;
                PyElsePart pyElsePart = statement.getElsePart();
                if (pyElsePart == null) {
                    return;
                }
                elsePart = pyElsePart;
                ifComment = this.getChildComment((PsiElement)ifPart);
                elseComment = this.getChildComment((PsiElement)elsePart);
                PsiComment psiComment = ifComment;
                if (psiComment != null ? this.isInlineServiceComment(psiComment) : false) break block6;
                PsiComment psiComment2 = elseComment;
                boolean bl = psiComment2 != null ? this.isInlineServiceComment(psiComment2) : false;
                if (!bl) break block7;
            }
            return;
        }
        if (ifComment != null) {
            this.appendInlineComment(elsePart, ifComment);
            ifComment.delete();
        }
        if (elseComment != null) {
            this.appendInlineComment(ifPart, elseComment);
            elseComment.delete();
        }
    }

    private final boolean isTerminated(PyStatementList $this$isTerminated) {
        Object element$iv2;
        PyStatementList currentElement;
        ControlFlow controlFlow;
        block2: {
            PsiElement $this$parentsOfType_u24default$iv = (PsiElement)$this$isTerminated;
            boolean withSelf$iv = true;
            boolean $i$f$parentsOfType = false;
            ControlFlow controlFlow2 = ControlFlowCache.getControlFlow((ScopeOwner)SequencesKt.first((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, ScopeOwner.class, (boolean)withSelf$iv)));
            Intrinsics.checkNotNullExpressionValue((Object)controlFlow2, (String)"getControlFlow(...)");
            controlFlow = controlFlow2;
            currentElement = $this$isTerminated;
            Instruction[] instructionArray = controlFlow.getInstructions();
            Intrinsics.checkNotNullExpressionValue((Object)instructionArray, (String)"getInstructions(...)");
            Object[] $this$first$iv = instructionArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Instruction it = (Instruction)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElement(), (Object)currentElement)) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Instruction currentInstruction = (Instruction)element$iv2;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        result2.element = true;
        ControlFlowUtil.iterate((int)currentInstruction.num(), (Instruction[])controlFlow.getInstructions(), arg_0 -> PyInvertIfConditionIntention._get_isTerminated_$lambda$8((Function1)new Function1<Instruction, ControlFlowUtil.Operation>(currentInstruction, currentElement, result2, this){
            final /* synthetic */ Instruction $currentInstruction;
            final /* synthetic */ PyStatementList $currentElement;
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ PyInvertIfConditionIntention this$0;
            {
                this.$currentInstruction = $currentInstruction;
                this.$currentElement = $currentElement;
                this.$result = $result;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final ControlFlowUtil.Operation invoke(Instruction instruction) {
                ControlFlowUtil.Operation operation;
                block7: {
                    block6: {
                        if (Intrinsics.areEqual((Object)instruction, (Object)this.$currentInstruction)) {
                            operation = ControlFlowUtil.Operation.NEXT;
                            return operation;
                        }
                        if (instruction instanceof ReadWriteInstruction) {
                            operation = ControlFlowUtil.Operation.NEXT;
                            return operation;
                        }
                        if (instruction.getElement() == null) break block6;
                        PsiElement psiElement = instruction.getElement();
                        Intrinsics.checkNotNull((Object)psiElement);
                        if (SequencesKt.contains((Sequence)PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)false), (Object)this.$currentElement)) break block7;
                    }
                    this.$result.element = false;
                    operation = ControlFlowUtil.Operation.BREAK;
                    return operation;
                }
                if (PyInvertIfConditionIntention.access$isTerminationStatement(this.this$0, instruction.getElement())) {
                    operation = ControlFlowUtil.Operation.CONTINUE;
                    return operation;
                }
                operation = ControlFlowUtil.Operation.NEXT;
                return operation;
            }
        }, arg_0), (boolean)false);
        return result2.element;
    }

    private final boolean isTerminableStatement(PsiElement $this$isTerminableStatement) {
        return $this$isTerminableStatement instanceof PyFunction || $this$isTerminableStatement instanceof PyForPart || $this$isTerminableStatement instanceof PyWhilePart;
    }

    private final boolean isTerminationStatement(PsiElement $this$isTerminationStatement) {
        return $this$isTerminationStatement instanceof PyReturnStatement || $this$isTerminationStatement instanceof PyRaiseStatement || $this$isTerminationStatement instanceof PyContinueStatement || $this$isTerminationStatement instanceof PyBreakStatement;
    }

    private final PyStatementListContainer findTerminableParent(PsiElement $this$findTerminableParent) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.parents((PsiElement)$this$findTerminableParent, (boolean)false);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!this.isTerminableStatement(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final PsiElement findTerminationStatement(PsiElement $this$findTerminationStatement) {
        Object object;
        block1: {
            PsiElement[] psiElementArray = $this$findTerminationStatement.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$firstOrNull$iv = psiElementArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!this.isTerminationStatement(it)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final boolean isValuableTerminationStatement(PsiElement $this$isValuableTerminationStatement, PyStatementListContainer terminableStatement) {
        return $this$isValuableTerminationStatement instanceof PyReturnStatement && (((PyReturnStatement)$this$isValuableTerminationStatement).getExpression() != null || !(terminableStatement instanceof PyFunction)) || $this$isValuableTerminationStatement instanceof PyRaiseStatement || $this$isValuableTerminationStatement instanceof PyBreakStatement;
    }

    private final PsiElement createTerminationStatement(PsiFile file, Project project, PyStatementListContainer targetStatement) {
        PsiElement psiElement;
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"forElement(...)");
        LanguageLevel level = languageLevel;
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        PyStatementListContainer pyStatementListContainer = targetStatement;
        if (pyStatementListContainer instanceof PyFunction) {
            PyReturnStatement pyReturnStatement = generator.createFromText(level, PyReturnStatement.class, "return");
            Intrinsics.checkNotNullExpressionValue((Object)pyReturnStatement, (String)"createFromText(...)");
            psiElement = (PsiElement)pyReturnStatement;
        } else if (pyStatementListContainer instanceof PyForPart) {
            PyContinueStatement pyContinueStatement = generator.createFromText(level, PyContinueStatement.class, "continue");
            Intrinsics.checkNotNullExpressionValue((Object)pyContinueStatement, (String)"createFromText(...)");
            psiElement = (PsiElement)pyContinueStatement;
        } else if (pyStatementListContainer instanceof PyWhilePart) {
            PyContinueStatement pyContinueStatement = generator.createFromText(level, PyContinueStatement.class, "continue");
            Intrinsics.checkNotNullExpressionValue((Object)pyContinueStatement, (String)"createFromText(...)");
            psiElement = (PsiElement)pyContinueStatement;
        } else {
            throw new IncorrectOperationException(((Object)((Object)this)).getClass().getName() + " is not a terminable statement");
        }
        return psiElement;
    }

    private final PyStatementListContainer getParentStatementListContainer(PsiElement $this$parentStatementListContainer) {
        PsiElement $this$parentsOfType_u24default$iv = $this$parentStatementListContainer;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        return (PyStatementListContainer)SequencesKt.first((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, PyStatementListContainer.class, (boolean)withSelf$iv));
    }

    private final List<PsiComment> getAttachedComments(PsiElement $this$attachedComments) {
        List<PsiComment> list = PyPsiUtils.getPrecedingComments($this$attachedComments);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPrecedingComments(...)");
        Iterable $this$takeWhile$iv = list;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            PsiComment it = (PsiComment)item$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!this.isAttachedServiceComment(it))) break;
            list$iv.add(item$iv);
        }
        return list$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiComment getChildComment(PsiElement $this$childComment) {
        void $this$filterIsInstanceTo$iv$iv;
        ASTNode[] aSTNodeArray = $this$childComment.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        Object[] $this$filterIsInstance$iv = aSTNodeArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiComment)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (PsiComment)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private final void appendInlineComment(PyStatementPart $this$appendInlineComment, PsiComment comment) {
        ASTNode aSTNode = $this$appendInlineComment.getStatementList().getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        ASTNode aSTNode2 = this.getPrevSignificantNode(aSTNode);
        Intrinsics.checkNotNull((Object)aSTNode2);
        ASTNode trailingColonNode = aSTNode2;
        CodeEditUtil.addChild((ASTNode)$this$appendInlineComment.getNode(), (ASTNode)comment.getNode().copyElement(), (ASTNode)trailingColonNode.getTreeNext());
    }

    private final ASTNode getPrevSignificantNode(ASTNode $this$prevSignificantNode) {
        return PyPsiUtils.skipSiblingsBackward($this$prevSignificantNode, insignificantTokenSet);
    }

    private final PsiElement getLastSignificantChild(PsiElement $this$lastSignificantChild) {
        return PyPsiUtils.getPrevNonCommentSibling($this$lastSignificantChild.getLastChild(), false);
    }

    private final PsiElement getNextMovableSibling(PsiElement $this$nextMovableSibling) {
        Object v1;
        block1: {
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.siblings$default((PsiElement)$this$nextMovableSibling, (boolean)false, (boolean)false, (int)1, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                boolean bl2 = !(it instanceof PsiWhiteSpace || it instanceof PsiComment && !this.isAttachedServiceComment((PsiComment)it));
                if (!bl2) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final boolean isAttachedServiceComment(PsiComment $this$isAttachedServiceComment) {
        return SuppressionUtil.isSuppressionComment((PsiElement)((PsiElement)$this$isAttachedServiceComment)) || this.isPylintComment($this$isAttachedServiceComment);
    }

    private final boolean isInlineServiceComment(PsiComment $this$isInlineServiceComment) {
        return PyTypeHintGenerationUtil.isTypeHintComment((PsiElement)$this$isInlineServiceComment) || this.isPylintComment($this$isInlineServiceComment);
    }

    private final boolean isPylintComment(PsiComment $this$isPylintComment) {
        String string = $this$isPylintComment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.startsWith$default((String)string, (String)PYLINT_COMMENT_PREFIX, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void trimTrailingWhiteSpace(PsiElement $this$trimTrailingWhiteSpace) {
        void $this$mapTo$iv$iv;
        List list;
        block3: {
            ASTNode[] aSTNodeArray = $this$trimTrailingWhiteSpace.getNode().getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
            Object[] $this$takeLastWhile$iv = aSTNodeArray;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = ArraysKt.getLastIndex((Object[])$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                ASTNode it = (ASTNode)$this$takeLastWhile$iv[index$iv];
                boolean bl = false;
                if (it instanceof PsiWhiteSpace) continue;
                list = ArraysKt.drop((Object[])$this$takeLastWhile$iv, (int)(index$iv + 1));
                break block3;
            }
            list = ArraysKt.toList((Object[])$this$takeLastWhile$iv);
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable index$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.psi.PsiWhiteSpace");
            collection.add((PsiWhiteSpace)it);
        }
        List trailingWhiteSpace = (List)destination$iv$iv;
        if (CollectionsKt.any((Iterable)trailingWhiteSpace)) {
            $this$trimTrailingWhiteSpace.deleteChildRange((PsiElement)CollectionsKt.first((List)trailingWhiteSpace), (PsiElement)CollectionsKt.last((List)trailingWhiteSpace));
        }
    }

    private static final ControlFlowUtil.Operation _get_isTerminated_$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ControlFlowUtil.Operation)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isTerminationStatement(PyInvertIfConditionIntention $this, PsiElement $receiver) {
        return $this.isTerminationStatement($receiver);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{TokenType.WHITE_SPACE, PyTokenTypes.END_OF_LINE_COMMENT};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        insignificantTokenSet = tokenSet;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/codeInsight/intentions/PyInvertIfConditionIntention$Companion;", "", "()V", "PYLINT_COMMENT_PREFIX", "", "insignificantTokenSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getInsignificantTokenSet", "()Lcom/intellij/psi/tree/TokenSet;", "intellij.python.psi.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenSet getInsignificantTokenSet() {
            return insignificantTokenSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

