/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/Border;", "", "offset", "", "line", "text", "", "lineBorder", "Lkotlin/ranges/IntRange;", "(IILjava/lang/String;Lkotlin/ranges/IntRange;)V", "chars", "", "currentLine", "currentOffset", "getCurrentOffset", "()I", "setCurrentOffset", "(I)V", "getText", "()Ljava/lang/String;", "moveLeft", "", "moveRight", "intellij.qodana"})
public final class Border {
    @NotNull
    private final String text;
    @NotNull
    private final IntRange lineBorder;
    private int currentOffset;
    private int currentLine;
    @NotNull
    private final char[] chars;

    public Border(int offset, int line, @NotNull String text2, @NotNull IntRange lineBorder) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lineBorder, (String)"lineBorder");
        this.text = text2;
        this.lineBorder = lineBorder;
        this.currentOffset = offset;
        this.currentLine = line;
        char[] cArray = this.text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this.chars = cArray;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int getCurrentOffset() {
        return this.currentOffset;
    }

    public final void setCurrentOffset(int n) {
        this.currentOffset = n;
    }

    public final boolean moveLeft() {
        int nextOffset = this.currentOffset - 1;
        if (nextOffset < 0) {
            return false;
        }
        if (this.chars[nextOffset] == '\n') {
            if (!this.lineBorder.contains(this.currentLine - 1)) {
                return false;
            }
            int n = this.currentLine;
            this.currentLine = n + -1;
        }
        this.currentOffset = nextOffset;
        return true;
    }

    public final boolean moveRight() {
        int nextOffset = this.currentOffset + 1;
        if (nextOffset < 0 || nextOffset > this.text.length()) {
            return false;
        }
        if (this.chars[this.currentOffset] == '\n') {
            if (!this.lineBorder.contains(this.currentLine + 1)) {
                return false;
            }
            int n = this.currentLine;
            this.currentLine = n + 1;
        }
        this.currentOffset = nextOffset;
        return true;
    }
}

