/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.run.QodanaConverterInput;
import org.jetbrains.qodana.run.QodanaConverterResults;
import org.jetbrains.qodana.sarif.SarifConverter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "runQodanaConverter", "Lorg/jetbrains/qodana/run/QodanaConverterResults;", "input", "Lorg/jetbrains/qodana/run/QodanaConverterInput;", "(Lorg/jetbrains/qodana/run/QodanaConverterInput;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getChildByRelativePath", "Ljava/nio/file/Path;", "childRelativePath", "", "intellij.qodana"})
public final class Qodana_converterKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Object runQodanaConverter(@NotNull QodanaConverterInput input, @NotNull Continuation<? super QodanaConverterResults> $completion) {
        return InterruptibleKt.runInterruptible((CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getIO(), (Function0)((Function0)new Function0<QodanaConverterResults>(input){
            final /* synthetic */ QodanaConverterInput $input;
            {
                this.$input = $input;
                super(0);
            }

            @NotNull
            public final QodanaConverterResults invoke() {
                Path converterTempDir = FileUtilRt.createTempDirectory((String)"qodana-converter", (String)"", (boolean)true).toPath();
                QodanaConverterInput qodanaConverterInput = this.$input;
                if (qodanaConverterInput instanceof QodanaConverterInput.FullQodanaOutput) {
                    File file = ((QodanaConverterInput.FullQodanaOutput)this.$input).getQodanaOutput().toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    File file2 = converterTempDir.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                    FilesKt.copyRecursively$default((File)file, (File)file2, (boolean)false, null, (int)6, null);
                } else if (qodanaConverterInput instanceof QodanaConverterInput.SarifFileOnly) {
                    File file = ((QodanaConverterInput.SarifFileOnly)this.$input).getSarifFile().toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    File file3 = converterTempDir.resolve("qodana.sarif.json").toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                    FilesKt.copyRecursively$default((File)file, (File)file3, (boolean)false, null, (int)6, null);
                }
                Path yamlFile = converterTempDir.resolve("log").resolve("qodana.yaml");
                try {
                    Intrinsics.checkNotNull((Object)yamlFile);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(yamlFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        Path path = converterTempDir.resolve("qodana.yaml");
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                        PathKt.copy((Path)yamlFile, (Path)path);
                    }
                }
                catch (IOException e) {
                    Qodana_converterKt.access$getLOG$p().info("Failed copying yaml", (Throwable)e);
                }
                SarifConverter sarifConverter = new SarifConverter();
                File file = converterTempDir.resolve("qodana.sarif.json").toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                Intrinsics.checkNotNull((Object)converterTempDir);
                sarifConverter.convert(file, converterTempDir);
                Qodana_converterKt.access$getLOG$p().info("Ran Qodana converter, results directory: " + converterTempDir);
                return new QodanaConverterResults(converterTempDir);
            }
        }), $completion);
    }

    private static final Path getChildByRelativePath(Path $this$getChildByRelativePath, String childRelativePath) {
        Path childFullPath = $this$getChildByRelativePath.resolve(childRelativePath);
        return childFullPath.startsWith($this$getChildByRelativePath) ? childFullPath : null;
    }

    public static final /* synthetic */ Path access$getChildByRelativePath(Path $receiver, String childRelativePath) {
        return Qodana_converterKt.getChildByRelativePath($receiver, childRelativePath);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger2 = Logger.getInstance((String)"#org.jetbrains.qodana.run");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

