/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.intellij.diff.tools.combined.CombinedDiffModelBuilder;
import com.intellij.diff.tools.combined.CombinedDiffModelImpl;
import com.intellij.diff.tools.combined.CombinedDiffVirtualFile;
import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestDiffFileKt;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestDiffService;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFile;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016J\b\u0010$\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestCombinedDiffFile;", "Lcom/intellij/diff/tools/combined/CombinedDiffVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFile;", "Lcom/intellij/diff/tools/combined/CombinedDiffModelBuilder;", "connectionId", "", "project", "Lcom/intellij/openapi/project/Project;", "glProject", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "mergeRequestIid", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Ljava/lang/String;)V", "getConnectionId", "()Ljava/lang/String;", "contentsToByteArray", "", "createModel", "Lcom/intellij/diff/tools/combined/CombinedDiffModelImpl;", "id", "enforcePresentableName", "", "equals", "other", "", "getInputStream", "getLength", "", "getOutputStream", "requestor", "newModificationStamp", "newTimeStamp", "getPresentablePath", "hashCode", "", "isValid", "toString", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestCombinedDiffFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestCombinedDiffFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestCombinedDiffFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,62:1\n30#2,3:63\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestCombinedDiffFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestCombinedDiffFile\n*L\n25#1:63,3\n*E\n"})
public final class GitLabMergeRequestCombinedDiffFile
extends CombinedDiffVirtualFile
implements VirtualFilePathWrapper,
GitLabVirtualFile,
CombinedDiffModelBuilder {
    @NotNull
    private final String connectionId;
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabProjectCoordinates glProject;
    @NotNull
    private final String mergeRequestIid;

    public GitLabMergeRequestCombinedDiffFile(@NotNull String connectionId, @NotNull Project project, @NotNull GitLabProjectCoordinates glProject, @NotNull String mergeRequestIid) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)glProject, (String)"glProject");
        Intrinsics.checkNotNullParameter((Object)mergeRequestIid, (String)"mergeRequestIid");
        Object[] objectArray = new Object[]{mergeRequestIid};
        super(mergeRequestIid, GitLabBundle.message("merge.request.diff.file.name", objectArray), null, 4, null);
        this.connectionId = connectionId;
        this.project = project;
        this.glProject = glProject;
        this.mergeRequestIid = mergeRequestIid;
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
    }

    @Override
    @NotNull
    public String getConnectionId() {
        return this.connectionId;
    }

    @NotNull
    public CombinedDiffModelImpl createModel(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitLabMergeRequestDiffService> serviceClass$iv = GitLabMergeRequestDiffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return ((GitLabMergeRequestDiffService)object).createGitLabCombinedDiffModel(this.getConnectionId(), this.mergeRequestIid);
    }

    @NotNull
    public String getPresentablePath() {
        return GitLabMergeRequestDiffFileKt.presentablePath(this.glProject, this.mergeRequestIid);
    }

    public boolean enforcePresentableName() {
        return true;
    }

    public long getLength() {
        return 0L;
    }

    @NotNull
    public Void contentsToByteArray() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void getInputStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new UnsupportedOperationException();
    }

    public boolean isValid() {
        return GitLabMergeRequestDiffFileKt.findProjectVm(this.project, this.getConnectionId()) != null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabMergeRequestCombinedDiffFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getConnectionId(), (Object)((GitLabMergeRequestCombinedDiffFile)other).getConnectionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)((GitLabMergeRequestCombinedDiffFile)other).project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.glProject, (Object)((GitLabMergeRequestCombinedDiffFile)other).glProject)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mergeRequestIid, (Object)((GitLabMergeRequestCombinedDiffFile)other).mergeRequestIid);
    }

    public int hashCode() {
        int result2 = this.getConnectionId().hashCode();
        result2 = 31 * result2 + this.project.hashCode();
        result2 = 31 * result2 + this.glProject.hashCode();
        result2 = 31 * result2 + this.mergeRequestIid.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "GitLabMergeRequestCombinedDiffFile(connectionId='" + this.getConnectionId() + "', project=" + this.project + ", glProject=" + this.glProject + ", mergeRequestId=" + this.mergeRequestIid + ")";
    }
}

