/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.completion;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.completion.CommandSpecManager;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.completion.CommandSpecBean;
import org.jetbrains.plugins.terminal.exp.completion.IJCommandSpecManager;
import org.jetbrains.terminal.completion.ShellCommand;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001b\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager;", "Lcom/intellij/terminal/completion/CommandSpecManager;", "()V", "completionSpecs", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lorg/jetbrains/terminal/completion/ShellCommand;", "json", "Lkotlinx/serialization/json/Json;", "findSpec", "Lorg/jetbrains/plugins/terminal/exp/completion/CommandSpecBean;", "commandName", "getCommandSpec", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nIJCommandSpecManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n1#2:91\n96#3:92\n10#4:93\n*S KotlinDebug\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager\n*L\n62#1:92\n88#1:93\n*E\n"})
public final class IJCommandSpecManager
implements CommandSpecManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<String, ShellCommand> completionSpecs;
    @NotNull
    private final Json json;
    @NotNull
    private static final Logger LOG;

    public IJCommandSpecManager() {
        Cache cache = Caffeine.newBuilder().maximumSize(10L).expireAfterAccess(Duration.ofMinutes(5L)).scheduler(Scheduler.systemScheduler()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.completionSpecs = cache;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }

    @Override
    @Nullable
    public Object getCommandSpec(@NotNull String commandName, @NotNull Continuation<? super ShellCommand> $completion) {
        ShellCommand shellCommand;
        CommandSpecBean spec;
        Pair pair;
        ShellCommand shellCommand2 = (ShellCommand)this.completionSpecs.getIfPresent((Object)commandName);
        if (shellCommand2 != null) {
            ShellCommand it = shellCommand2;
            boolean bl = false;
            return it;
        }
        if (StringsKt.contains$default((CharSequence)commandName, (char)'/', (boolean)false, (int)2, null)) {
            String mainCommand = StringsKt.substringBefore$default((String)commandName, (char)'/', null, (int)2, null);
            CommandSpecBean commandSpecBean = this.findSpec(mainCommand);
            if (commandSpecBean == null) {
                return null;
            }
            CommandSpecBean mainSpec = commandSpecBean;
            String basePath = StringsKt.contains$default((CharSequence)mainSpec.getPath(), (char)'/', (boolean)false, (int)2, null) ? StringsKt.substringBeforeLast$default((String)mainSpec.getPath(), (char)'/', null, (int)2, null) : "";
            String specPath = basePath + "/" + commandName + ".json";
            pair = TuplesKt.to((Object)mainSpec, (Object)specPath);
        } else {
            CommandSpecBean commandSpecBean = this.findSpec(commandName);
            if (commandSpecBean == null) {
                return null;
            }
            spec = commandSpecBean;
            pair = TuplesKt.to((Object)spec, (Object)spec.getPath());
        }
        Pair pair2 = pair;
        spec = (CommandSpecBean)pair2.component1();
        String path = (String)pair2.component2();
        URL specUrl = spec.getPluginDesc().getClassLoader().getResource(path);
        if (specUrl == null) {
            LOG.warn("Failed to find spec resource for command: " + commandName);
            return null;
        }
        try {
            URL uRL = specUrl;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            String specJson = new String(byArray, charset);
            Json this_$iv = this.json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            shellCommand = (ShellCommand)this_$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable(ShellCommand.Companion.serializer()), specJson);
        }
        catch (IOException ex) {
            LOG.warn("Failed to load spec by url: " + specUrl, (Throwable)ex);
            shellCommand = null;
        }
        catch (Throwable t) {
            LOG.warn("Failed to parse spec by url: " + specUrl, t);
            shellCommand = null;
        }
        ShellCommand subcommand = shellCommand;
        if (subcommand != null) {
            this.completionSpecs.put((Object)commandName, subcommand);
        }
        return subcommand;
    }

    private final CommandSpecBean findSpec(String commandName) {
        Object v0;
        block1: {
            Iterable iterable = CommandSpecBean.Companion.getEP_NAME().getExtensionList();
            for (Object t : iterable) {
                CommandSpecBean it = (CommandSpecBean)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCommand(), (Object)commandName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    @NotNull
    public static final CommandSpecManager getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IJCommandSpecManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/terminal/completion/CommandSpecManager;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nIJCommandSpecManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,90:1\n43#2,3:91\n*S KotlinDebug\n*F\n+ 1 IJCommandSpecManager.kt\norg/jetbrains/plugins/terminal/exp/completion/IJCommandSpecManager$Companion\n*L\n86#1:91,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CommandSpecManager getInstance() {
            boolean $i$f$service = false;
            Class<CommandSpecManager> serviceClass$iv = CommandSpecManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (CommandSpecManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

