/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.CharSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.Util;

class ConvTable {
    private final FST<CharsRef> fst;
    private final FixedBitSet firstCharHashes;
    private final int mod;

    ConvTable(TreeMap<String, String> mappings) {
        this.mod = Math.max(256, Integer.highestOneBit(mappings.size()) << 1);
        this.firstCharHashes = new FixedBitSet(this.mod);
        try {
            CharSequenceOutputs outputs = CharSequenceOutputs.getSingleton();
            FSTCompiler<CharsRef> fstCompiler = new FSTCompiler<CharsRef>(FST.INPUT_TYPE.BYTE2, outputs);
            IntsRefBuilder scratchInts = new IntsRefBuilder();
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                String key = entry.getKey();
                assert (key.length() > 0);
                this.firstCharHashes.set(key.charAt(0) % this.mod);
                Util.toUTF16(key, scratchInts);
                fstCompiler.add(scratchInts.get(), new CharsRef(entry.getValue()));
            }
            this.fst = fstCompiler.compile();
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    void applyMappings(StringBuilder sb) {
        FST.BytesReader bytesReader = null;
        FST.Arc<CharsRef> firstArc = null;
        FST.Arc<CharsRef> arc = null;
        for (int i = 0; i < sb.length(); ++i) {
            if (!this.mightReplaceChar(sb.charAt(i))) continue;
            if (firstArc == null) {
                firstArc = this.fst.getFirstArc(new FST.Arc());
                bytesReader = this.fst.getBytesReader();
                arc = new FST.Arc<CharsRef>();
            }
            arc.copyFrom(firstArc);
            CharsRef output = (CharsRef)this.fst.outputs.getNoOutput();
            int longestMatch = -1;
            CharsRef longestOutput = null;
            for (int j = i; j < sb.length(); ++j) {
                char ch = sb.charAt(j);
                try {
                    if (this.fst.findTargetArc(ch, arc, arc, bytesReader) == null) break;
                    output = this.fst.outputs.add(output, (CharsRef)arc.output());
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                if (!arc.isFinal()) continue;
                longestOutput = this.fst.outputs.add(output, (CharsRef)arc.nextFinalOutput());
                longestMatch = j;
            }
            if (longestMatch < 0) continue;
            sb.delete(i, longestMatch + 1);
            sb.insert(i, longestOutput);
            i += longestOutput.length - 1;
        }
    }

    boolean mightReplaceChar(char c) {
        return this.firstCharHashes.get(c % this.mod);
    }
}

