/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tools.StringTools;

public final class ManualSynthesizer {
    private final Set<String> possibleTags;
    private static final int OFFSET_SHIFT = 8;
    private static final int MAX_LENGTH = 255;
    private static final int MAX_OFFSET = 0xFFFFFF;
    private static final int ENTRY_SIZE = 3;
    private final String[] data;
    private final TIntIntHashMap map;
    private static final String DEFAULT_SEPARATOR = "\t";

    public ManualSynthesizer(InputStream inputStream) throws IOException {
        Map<TaggedWord, List<String>> mapping = ManualSynthesizer.loadMapping(inputStream);
        TIntObjectHashMap<List<Triple<String, String, String>>> byHash = ManualSynthesizer.groupByHash(mapping);
        this.map = new TIntIntHashMap(byHash.size());
        int valueCount = mapping.values().stream().mapToInt(v -> v.size()).sum();
        final int firstIndex = 3;
        this.data = new String[valueCount * 3 + firstIndex];
        if (valueCount > 0xFFFFFF) {
            throw new UnsupportedOperationException("Too many values (" + valueCount + "), the storage needs adjusting");
        }
        byHash.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<List<Triple<String, String, String>>>(){
            int index;
            {
                this.index = firstIndex;
            }

            public boolean execute(int hash2, List<Triple<String, String, String>> value) {
                if (value.size() > 255) {
                    throw new UnsupportedOperationException("Too many lemmas (" + value.size() + " for the same hash " + value + ", the storage needs adjusting");
                }
                ManualSynthesizer.this.map.put(hash2, this.index / 3 << 8 | value.size());
                for (Triple<String, String, String> triple : value) {
                    ((ManualSynthesizer)ManualSynthesizer.this).data[this.index++] = (String)triple.getLeft();
                    ((ManualSynthesizer)ManualSynthesizer.this).data[this.index++] = (String)triple.getMiddle();
                    ((ManualSynthesizer)ManualSynthesizer.this).data[this.index++] = (String)triple.getRight();
                }
                return true;
            }
        });
        this.possibleTags = Collections.unmodifiableSet(ManualSynthesizer.collectTags(mapping));
    }

    private static TIntObjectHashMap<List<Triple<String, String, String>>> groupByHash(Map<TaggedWord, List<String>> mapping) {
        TIntObjectHashMap byHash = new TIntObjectHashMap(mapping.size());
        for (Map.Entry<TaggedWord, List<String>> entry2 : mapping.entrySet()) {
            TaggedWord tw = entry2.getKey();
            int hash2 = ManualSynthesizer.hashCode(tw.getLemma(), tw.getPosTag());
            ArrayList<ImmutableTriple> list = (ArrayList<ImmutableTriple>)byHash.get(hash2);
            if (list == null) {
                list = new ArrayList<ImmutableTriple>();
                byHash.put(hash2, list);
            }
            for (String word : entry2.getValue()) {
                list.add(new ImmutableTriple((Object)tw.getLemma(), (Object)tw.getPosTag(), (Object)word));
            }
        }
        return byHash;
    }

    private static THashSet<String> collectTags(Map<TaggedWord, List<String>> mapping) {
        THashSet tags = new THashSet();
        for (TaggedWord tw : mapping.keySet()) {
            tags.add((Object)tw.getPosTag());
        }
        tags.trimToSize();
        return tags;
    }

    private static int hashCode(String lemma, String posTag) {
        return lemma.hashCode() * 31 + posTag.hashCode();
    }

    public Set<String> getPossibleTags() {
        return this.possibleTags;
    }

    @Nullable
    public List<String> lookup(String lemma, String posTag) {
        if (lemma == null || posTag == null) {
            return null;
        }
        int value = this.map.get(ManualSynthesizer.hashCode(lemma, posTag));
        if (value == 0) {
            return null;
        }
        int offset = (value >>> 8) * 3;
        int length = value & 0xFF;
        ArrayList<String> result2 = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            if (!lemma.equals(this.data[offset + i * 3]) || !posTag.equals(this.data[offset + i * 3 + 1])) continue;
            result2.add(this.data[offset + i * 3 + 2]);
        }
        return result2;
    }

    private static Map<TaggedWord, List<String>> loadMapping(InputStream inputStream) throws IOException {
        HashMap internedStrings = new HashMap();
        HashMap<TaggedWord, List<String>> mapping = new HashMap<TaggedWord, List<String>>();
        HashMap interned = new HashMap();
        try (Scanner scanner = new Scanner(inputStream, "utf8");){
            String separator = DEFAULT_SEPARATOR;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if ((line = line.trim()).startsWith("#separatorRegExp=")) {
                    separator = line.replace("#separatorRegExp=", "");
                }
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                String[] parts = (line = StringUtils.substringBefore((String)line, (String)"#").trim()).split(separator);
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual synthesizer dictionary, expected 3 parts separated by '" + separator + "', found " + parts.length + ": '" + line + "'");
                }
                String form = parts[0];
                String lemma = parts[1];
                if (form.equals(lemma)) {
                    form = lemma;
                }
                lemma = (String)interned.computeIfAbsent(lemma, Function.identity());
                String posTag = (String)internedStrings.computeIfAbsent(parts[2], Function.identity());
                mapping.computeIfAbsent(new TaggedWord(lemma, posTag), __ -> new ArrayList()).add(form);
            }
        }
        return mapping;
    }
}

