/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.markdown;

import com.intellij.grazie.ide.language.markdown.MarkdownPsiUtils;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/ide/language/markdown/MarkdownTextExtractor;", "Lcom/intellij/grazie/text/TextExtractor;", "()V", "markup", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "buildTextContent", "Lcom/intellij/grazie/text/TextContent;", "root", "Lcom/intellij/psi/PsiElement;", "allowedDomains", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "isLinkText", "", "e", "intellij.grazie.markdown"})
public final class MarkdownTextExtractor
extends TextExtractor {
    @NotNull
    private final Set<IElementType> markup;

    public MarkdownTextExtractor() {
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.EMPH, MarkdownTokenTypes.TILDE};
        this.markup = SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public TextContent buildTextContent(@NotNull PsiElement root, @NotNull Set<? extends TextContent.TextDomain> allowedDomains) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(allowedDomains, (String)"allowedDomains");
        if (allowedDomains.contains((Object)TextContent.TextDomain.PLAIN_TEXT) && (MarkdownPsiUtils.INSTANCE.isHeaderContent(root) || MarkdownPsiUtils.INSTANCE.isParagraph(root))) {
            return HtmlUtilsKt.nbspToSpace(TextContentBuilder.FromPsi.withUnknown(MarkdownTextExtractor::buildTextContent$lambda$0).withMarkup(arg_0 -> MarkdownTextExtractor.buildTextContent$lambda$1(this, arg_0)).excluding(MarkdownTextExtractor::buildTextContent$lambda$2).removingIndents(" \t").removingLineSuffixes(" \t").build(root, TextContent.TextDomain.PLAIN_TEXT));
        }
        return null;
    }

    private final boolean isLinkText(PsiElement e) {
        return (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)e), (Object)MarkdownTokenTypes.TEXT) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)e), (Object)MarkdownTokenTypes.GFM_AUTOLINK) || e instanceof PsiWhiteSpace) && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)e.getParent()), (Object)MarkdownElementTypes.LINK_TEXT);
    }

    private static final boolean buildTextContent$lambda$0(PsiElement it) {
        ASTNode aSTNode = it.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        return MarkdownPsiUtils.INSTANCE.isMarkdownCodeType$intellij_grazie_markdown(aSTNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean buildTextContent$lambda$1(MarkdownTextExtractor this$0, PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.markup.contains(PsiTreeUtilKt.getElementType((PsiElement)e))) return true;
        if (e.getFirstChild() != null) return false;
        ASTNode aSTNode = e.getParent().getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        if (!MarkdownPsiUtils.INSTANCE.isMarkdownLinkType$intellij_grazie_markdown(aSTNode)) return false;
        Intrinsics.checkNotNull((Object)e);
        if (this$0.isLinkText(e)) return false;
        return true;
    }

    private static final boolean buildTextContent$lambda$2(PsiElement it) {
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)MarkdownElementTypes.IMAGE);
    }
}

