/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.platform.testFramework.diagnostic.MetricsPublisher;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.StorageLockContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PerformanceTestInfo {
    private final ThrowableComputable<Integer, ?> test;
    private final int expectedMs;
    private final int expectedInputSize;
    private ThrowableRunnable<?> setup;
    private int usedReferenceCpuCores;
    private int maxRetries;
    private final String what;
    private boolean adjustForIO;
    private boolean adjustForCPU;
    private boolean useLegacyScaling;
    private int warmupIterations;
    @NotNull
    private final IJTracer tracer;
    private long lastJitUsage;
    private long lastJitStamp;

    PerformanceTestInfo(@NotNull ThrowableComputable<Integer, ?> test, int expectedMs, int expectedInputSize, @NotNull String what) {
        if (test == null) {
            PerformanceTestInfo.$$$reportNull$$$0(0);
        }
        if (what == null) {
            PerformanceTestInfo.$$$reportNull$$$0(1);
        }
        this.usedReferenceCpuCores = 1;
        this.maxRetries = 4;
        this.adjustForCPU = true;
        this.warmupIterations = Integer.MIN_VALUE;
        this.lastJitStamp = -1L;
        this.test = test;
        this.expectedMs = expectedMs;
        this.expectedInputSize = expectedInputSize;
        assert (expectedMs > 0) : "Expected must be > 0. Was: " + expectedMs;
        assert (expectedInputSize > 0) : "Expected input size must be > 0. Was: " + expectedInputSize;
        this.what = what;
        this.tracer = TelemetryManager.getInstance().getTracer(new Scope("performanceUnitTests", null));
    }

    @Contract(pure=true)
    public PerformanceTestInfo setup(@NotNull ThrowableRunnable<?> setup) {
        if (setup == null) {
            PerformanceTestInfo.$$$reportNull$$$0(2);
        }
        assert (this.setup == null);
        this.setup = setup;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesAllCPUCores() {
        return this.usesMultipleCPUCores(8);
    }

    @Contract(pure=true)
    public PerformanceTestInfo usesMultipleCPUCores(int maxCores) {
        assert (this.adjustForCPU) : "This test configured to be io-bound, it cannot use all cores";
        this.usedReferenceCpuCores = maxCores;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo ioBound() {
        this.adjustForIO = true;
        this.adjustForCPU = false;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo attempts(int attempts) {
        this.maxRetries = attempts;
        return this;
    }

    @Contract(pure=true)
    public PerformanceTestInfo warmupIterations(int iterations) {
        assert (this.warmupIterations == Integer.MIN_VALUE) : "Already called warmupIterations()";
        assert (iterations >= 1) : "invalid argument: " + iterations + "; must be >= 1";
        this.warmupIterations = iterations;
        return this;
    }

    @Deprecated
    @Contract(pure=true)
    public PerformanceTestInfo useLegacyScaling() {
        this.useLegacyScaling = true;
        return this;
    }

    public void assertTiming() {
        if (PlatformTestUtil.COVERAGE_ENABLED_BUILD) {
            return;
        }
        Timings.getStatistics();
        this.updateJitUsage();
        if (this.maxRetries == 1) {
            System.gc();
        }
        int initialMaxRetries = this.maxRetries;
        try {
            TraceKt.runWithSpanSimple((IJTracer)this.tracer, (String)this.what, () -> {
                try {
                    for (int attempt = 1; attempt <= this.maxRetries; ++attempt) {
                        if (this.setup != null) {
                            this.setup.run();
                        }
                        PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
                        AtomicInteger actualInputSize = new AtomicInteger(this.expectedInputSize);
                        if (this.warmupIterations != Integer.MIN_VALUE) {
                            for (int i = 0; i < this.warmupIterations; ++i) {
                                this.test.compute();
                            }
                        }
                        IterationStatus status = (IterationStatus)TraceKt.computeWithSpanAttribute((IJTracer)this.tracer, (String)("Attempt: " + attempt), (String)"Attempt status", st -> String.valueOf(st.passed()), () -> {
                            CpuUsageData currentData;
                            try {
                                currentData = CpuUsageData.measureCpuUsage(() -> actualInputSize.set((Integer)this.test.compute()));
                            }
                            catch (Throwable e) {
                                ExceptionUtil.rethrowUnchecked((Throwable)e);
                                throw new RuntimeException(e);
                            }
                            int actualUsedCpuCores = this.usedReferenceCpuCores < 8 ? Math.min(JobSchedulerImpl.getJobPoolParallelism(), this.usedReferenceCpuCores) : JobSchedulerImpl.getJobPoolParallelism();
                            int expectedOnMyMachine = this.getExpectedTimeOnThisMachine(actualInputSize.get(), actualUsedCpuCores);
                            IterationResult iterationResult = currentData.getIterationResult(expectedOnMyMachine);
                            boolean passed = iterationResult == IterationResult.ACCEPTABLE || iterationResult == IterationResult.BORDERLINE;
                            String message = this.formatMessage(currentData, expectedOnMyMachine, actualInputSize.get(), actualUsedCpuCores, iterationResult, initialMaxRetries);
                            return new IterationStatus(iterationResult, passed, message);
                        });
                        boolean testPassed = status.passed();
                        String logMessage = status.logMessage();
                        IterationResult iterationResult = status.iterationResult();
                        if (testPassed) {
                            TeamCityLogger.info(logMessage);
                            System.out.println("\nSUCCESS: " + logMessage);
                            return;
                        }
                        TeamCityLogger.warning(logMessage, null);
                        if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                            System.out.println("\nWARNING: " + logMessage);
                        }
                        JitUsageResult jitUsage = this.updateJitUsage();
                        if (attempt == this.maxRetries) {
                            throw new AssertionFailedError(logMessage);
                        }
                        if ((iterationResult == IterationResult.DISTRACTED || jitUsage == JitUsageResult.UNCLEAR) && attempt < initialMaxRetries + 30 && this.maxRetries != 1) {
                            ++this.maxRetries;
                        }
                        String s = "  " + (this.maxRetries - attempt) + " " + StringUtil.pluralize((String)"attempt", (int)(this.maxRetries - attempt)) + " remain" + (String)(jitUsage == JitUsageResult.UNCLEAR ? " (waiting for JITc; its usage was " + jitUsage + " in this iteration)" : "");
                        TeamCityLogger.warning(s, null);
                        if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                            System.out.println(s);
                        }
                        System.gc();
                        StorageLockContext.forceDirectMemoryCache();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                    throw new RuntimeException(throwable);
                }
            });
        }
        catch (Throwable throwable) {
            try {
                MetricsPublisher.getInstance().publish(this.what);
            }
            catch (Throwable t) {
                System.err.println("Something unexpected happened during publishing performance metrics");
                t.printStackTrace();
            }
            throw throwable;
        }
        try {
            MetricsPublisher.getInstance().publish(this.what);
        }
        catch (Throwable t) {
            System.err.println("Something unexpected happened during publishing performance metrics");
            t.printStackTrace();
        }
    }

    @NotNull
    private String formatMessage(@NotNull CpuUsageData data, int expectedOnMyMachine, int actualInputSize, int actualUsedCpuCores, @NotNull IterationResult iterationResult, int initialMaxRetries) {
        if (data == null) {
            PerformanceTestInfo.$$$reportNull$$$0(3);
        }
        if (iterationResult == null) {
            PerformanceTestInfo.$$$reportNull$$$0(4);
        }
        long duration = data.durationMs;
        int percentage = (int)(100.0 * (double)(duration - (long)expectedOnMyMachine) / (double)expectedOnMyMachine);
        String colorCode = iterationResult == IterationResult.ACCEPTABLE ? "32;1m" : (iterationResult == IterationResult.BORDERLINE ? "33;1m" : "31;1m");
        String string = this.what + " took \u001b[" + colorCode + Math.abs(percentage) + "% " + (percentage > 0 ? "more" : "less") + " time\u001b[0m than expected" + (iterationResult == IterationResult.DISTRACTED && initialMaxRetries != 1 ? " (but JIT compilation took too long, will retry anyway)" : "") + "\n  Expected: " + expectedOnMyMachine + "ms" + (String)(expectedOnMyMachine < 1000 ? "" : " (" + StringUtil.formatDuration((long)expectedOnMyMachine) + ")") + "\n  Actual:   " + duration + "ms" + (String)(duration < 1000L ? "" : " (" + StringUtil.formatDuration((long)duration) + ")") + (String)(this.expectedInputSize != actualInputSize ? "\n  (Expected time was adjusted accordingly to input size: expected " + this.expectedInputSize + ", actual " + actualInputSize + ".)" : "") + (String)(this.usedReferenceCpuCores != actualUsedCpuCores ? "\n  (Expected time was adjusted accordingly to number of available CPU cores: reference CPU has " + this.usedReferenceCpuCores + ", actual value is " + actualUsedCpuCores + ".)" : "") + "\n  Timings:  " + Timings.getStatistics() + "\n  Threads:  " + data.getThreadStats() + "\n  GC stats: " + data.getGcStats() + "\n  Process:  " + data.getProcessCpuStats();
        if (string == null) {
            PerformanceTestInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    private JitUsageResult updateJitUsage() {
        long timeNow = System.nanoTime();
        long jitNow = CpuUsageData.getTotalCompilationMillis();
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(timeNow - this.lastJitStamp);
        if (this.lastJitStamp >= 0L) {
            if (elapsedMillis >= 3000L) {
                if (jitNow - this.lastJitUsage <= elapsedMillis / 10L) {
                    return JitUsageResult.DEFINITELY_LOW;
                }
            } else {
                return JitUsageResult.UNCLEAR;
            }
        }
        this.lastJitStamp = timeNow;
        this.lastJitUsage = jitNow;
        return JitUsageResult.UNCLEAR;
    }

    private int getExpectedTimeOnThisMachine(int actualInputSize, int actualUsedCpuCores) {
        int expectedOnMyMachine = (int)((long)this.expectedMs * (long)actualInputSize / (long)this.expectedInputSize);
        if (this.adjustForCPU) {
            expectedOnMyMachine *= this.usedReferenceCpuCores;
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.CPU_TIMING, 200L, this.useLegacyScaling);
            expectedOnMyMachine /= actualUsedCpuCores;
        }
        if (this.adjustForIO) {
            expectedOnMyMachine = PerformanceTestInfo.adjust(expectedOnMyMachine, Timings.IO_TIMING, 100L, this.useLegacyScaling);
        }
        return expectedOnMyMachine;
    }

    private static int adjust(int expectedOnMyMachine, long thisTiming, long referenceTiming, boolean useLegacyScaling) {
        if (useLegacyScaling) {
            double speed = 1.0 * (double)thisTiming / (double)referenceTiming;
            double delta = speed < 1.0 ? 0.9 + Math.pow(speed - 0.7, 2.0) : 0.45 + Math.pow(speed - 0.25, 2.0);
            expectedOnMyMachine = (int)((double)expectedOnMyMachine * delta);
            return expectedOnMyMachine;
        }
        return (int)((long)expectedOnMyMachine * thisTiming / referenceTiming);
    }

    static {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterationResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PerformanceTestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PerformanceTestInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatMessage";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static enum JitUsageResult {
        DEFINITELY_LOW,
        UNCLEAR;

    }

    static enum IterationResult {
        ACCEPTABLE,
        BORDERLINE,
        SLOW,
        DISTRACTED;

    }

    private record IterationStatus(@NotNull IterationResult iterationResult, boolean passed, @NotNull String logMessage) {
        @NotNull
        private final IterationResult iterationResult;
        @NotNull
        private final String logMessage;

        private IterationStatus(@NotNull IterationResult iterationResult, boolean passed, @NotNull String logMessage) {
            if (iterationResult == null) {
                IterationStatus.$$$reportNull$$$0(0);
            }
            if (logMessage == null) {
                IterationStatus.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public IterationResult iterationResult() {
            IterationResult iterationResult = this.iterationResult;
            if (iterationResult == null) {
                IterationStatus.$$$reportNull$$$0(2);
            }
            return iterationResult;
        }

        @NotNull
        public String logMessage() {
            String string = this.logMessage;
            if (string == null) {
                IterationStatus.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterationResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logMessage";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/PerformanceTestInfo$IterationStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/PerformanceTestInfo$IterationStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterationResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

