/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.treeAssertion;

import com.intellij.platform.testFramework.treeAssertion.SimpleTree;
import com.intellij.platform.testFramework.treeAssertion.SimpleTreeAssertion;
import com.intellij.platform.testFramework.treeAssertion.SimpleTreeAssertionImpl;
import com.intellij.platform.testFramework.treeAssertion.SimpleTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.opentest4j.AssertionFailedError;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u0018\u0019\u001aB!\b\u0002\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J5\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u001d\u0010\r\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000eH\u0002JG\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u001d\u0010\r\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000eH\u0016JG\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u001d\u0010\r\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000eH\u0016J\u001c\u0010\u0017\u001a\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tH\u0016R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl;", "T", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertion$Node;", "expectedChildren", "", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTree$Node;", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeAssertionOptions;", "(Ljava/util/List;)V", "valueAssertion", "Lkotlin/Function1;", "", "assertNode", "options", "assert", "Lkotlin/ExtensionFunctionType;", "name", "", "flattenIf", "", "skipIf", "isUnordered", "regex", "Lkotlin/text/Regex;", "assertValue", "Companion", "NodeAssertionOptions", "NodeMatcher", "intellij.platform.testFramework"})
public final class SimpleTreeAssertionImpl<T>
implements SimpleTreeAssertion.Node<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SimpleTree.Node<NodeAssertionOptions<T>>> expectedChildren;
    @NotNull
    private Function1<? super T, Unit> valueAssertion;

    private SimpleTreeAssertionImpl(List<SimpleTree.Node<NodeAssertionOptions<T>>> expectedChildren) {
        this.expectedChildren = expectedChildren;
        this.valueAssertion = valueAssertion.1.INSTANCE;
    }

    @Override
    public void assertValue(@NotNull Function1<? super T, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.valueAssertion = function1;
    }

    @Override
    public void assertNode(@NotNull String name, boolean flattenIf, boolean skipIf, boolean isUnordered, @NotNull Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.assertNode(new NodeAssertionOptions(new NodeMatcher.Name(name), flattenIf, skipIf, isUnordered, null, 16, null), function1);
    }

    @Override
    public void assertNode(@NotNull Regex regex, boolean flattenIf, boolean skipIf, boolean isUnordered, @NotNull Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter(function1, (String)"assert");
        this.assertNode(new NodeAssertionOptions(new NodeMatcher.NameRegex(regex), flattenIf, skipIf, isUnordered, null, 16, null), function1);
    }

    private final void assertNode(NodeAssertionOptions<T> options2, Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
        if (options2.getSkipIf()) {
            return;
        }
        if (options2.getFlattenIf()) {
            SimpleTreeAssertionImpl.Companion.addAssertionNodes(this.expectedChildren, function1);
            return;
        }
        String displayName = options2.getMatcher().getDisplayName();
        SimpleTree.Node<NodeAssertionOptions<T>> expectedChild = new SimpleTree.Node<NodeAssertionOptions<T>>(displayName, options2);
        SimpleTreeAssertionImpl.Companion.addAssertionNodes(expectedChild.getChildren(), function1);
        this.expectedChildren.add(expectedChild);
    }

    public /* synthetic */ SimpleTreeAssertionImpl(List expectedChildren, DefaultConstructorMarker $constructor_marker) {
        this(expectedChildren);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\b0\u00072\u001d\u0010\n\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\f\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\b\rH\u0002JA\u0010\u000e\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u001d\u0010\n\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u0013\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\b\rJ0\u0010\u000e\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010H\u0002J8\u0010\u0015\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$Companion;", "", "()V", "addAssertionNodes", "", "T", "assertionNodes", "", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTree$Node;", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeAssertionOptions;", "assert", "Lkotlin/Function1;", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertion$Node;", "Lkotlin/ExtensionFunctionType;", "assertTree", "actualTree", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTree;", "isUnordered", "", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertion;", "expectedTree", "sortTree", "throwTreeAssertionError", "", "intellij.platform.testFramework"})
    @SourceDebugExtension(value={"SMAP\nSimpleTreeAssertionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTreeAssertionImpl.kt\ncom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n3190#2,10:160\n350#2,7:170\n*S KotlinDebug\n*F\n+ 1 SimpleTreeAssertionImpl.kt\ncom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$Companion\n*L\n132#1:160,10\n138#1:170,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final <T> void assertTree(@NotNull SimpleTree<T> actualTree, boolean isUnordered, @NotNull Function1<? super SimpleTreeAssertion<T>, Unit> function1) {
            Intrinsics.checkNotNullParameter(actualTree, (String)"actualTree");
            Intrinsics.checkNotNullParameter(function1, (String)"assert");
            SimpleTree<T> actualMutableTree = SimpleTreeUtilKt.deepCopyTree(actualTree);
            SimpleTree<NodeAssertionOptions<T>> expectedMutableTree = new SimpleTree<NodeAssertionOptions<T>>();
            this.addAssertionNodes(expectedMutableTree.getRoots(), function1);
            this.sortTree(expectedMutableTree, actualMutableTree, isUnordered);
            this.assertTree(expectedMutableTree, actualMutableTree);
        }

        private final <T> void addAssertionNodes(List<SimpleTree.Node<NodeAssertionOptions<T>>> assertionNodes, Function1<? super SimpleTreeAssertion.Node<T>, Unit> function1) {
            SimpleTreeAssertionImpl assertion = new SimpleTreeAssertionImpl(assertionNodes, null);
            function1.invoke(assertion);
        }

        private final <T> void assertTree(SimpleTree<NodeAssertionOptions<T>> expectedTree, SimpleTree<T> actualTree) {
            ArrayDeque queue = new ArrayDeque();
            queue.add((Object)TuplesKt.to(expectedTree.getRoots(), actualTree.getRoots()));
            while (!((Collection)queue).isEmpty()) {
                Pair pair = (Pair)queue.removeFirst();
                List expectedNodes = (List)pair.component1();
                List actualNodes = (List)pair.component2();
                if (expectedNodes.size() != actualNodes.size()) {
                    this.throwTreeAssertionError(expectedTree, actualTree);
                    throw new KotlinNothingValueException();
                }
                for (Pair pair2 : CollectionsKt.zip((Iterable)expectedNodes, (Iterable)actualNodes)) {
                    SimpleTree.Node expectedNode = (SimpleTree.Node)pair2.component1();
                    SimpleTree.Node actualNode = (SimpleTree.Node)pair2.component2();
                    if (!((NodeAssertionOptions)expectedNode.getValue()).getMatcher().matches(actualNode)) {
                        this.throwTreeAssertionError(expectedTree, actualTree);
                        throw new KotlinNothingValueException();
                    }
                    ((NodeAssertionOptions)expectedNode.getValue()).getValueAssertion().invoke(actualNode.getValue());
                    queue.add((Object)TuplesKt.to(expectedNode.getChildren(), actualNode.getChildren()));
                }
            }
        }

        private final <T> Void throwTreeAssertionError(SimpleTree<NodeAssertionOptions<T>> expectedTree, SimpleTree<T> actualTree) {
            AssertionFailedError assertionFailedError = AssertionFailureBuilder.assertionFailure().expected((Object)SimpleTreeUtilKt.getTreeString(expectedTree)).actual((Object)SimpleTreeUtilKt.getTreeString(actualTree)).build();
            Intrinsics.checkNotNullExpressionValue((Object)assertionFailedError, (String)"build(...)");
            throw (Throwable)assertionFailedError;
        }

        private final <T> void sortTree(SimpleTree<NodeAssertionOptions<T>> expectedTree, SimpleTree<T> actualTree, boolean isUnordered) {
            ArrayDeque queue = new ArrayDeque();
            queue.add((Object)TuplesKt.to(expectedTree.getRoots(), actualTree.getRoots()));
            while (!((Collection)queue).isEmpty()) {
                Pair pair = (Pair)queue.removeFirst();
                List expectedNodes = (List)pair.component1();
                List actualNodes = (List)pair.component2();
                Iterable $this$partition$iv = expectedNodes;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    SimpleTree.Node it = (SimpleTree.Node)element$iv;
                    boolean bl = false;
                    if (isUnordered || ((NodeAssertionOptions)it.getValue()).isUnordered()) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair pair2 = new Pair(first$iv, second$iv);
                List expectedUnorderedNodes = (List)pair2.component1();
                List expectedOrderedNodes = (List)pair2.component2();
                ArrayList<SimpleTree.Node> actualUnorderedNodes = new ArrayList<SimpleTree.Node>();
                ArrayList actualOrderedNodes = new ArrayList(actualNodes);
                for (SimpleTree.Node expectedUnorderedNode : expectedUnorderedNodes) {
                    int index;
                    int n;
                    block7: {
                        List $this$indexOfFirst$iv = actualOrderedNodes;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            SimpleTree.Node it = (SimpleTree.Node)item$iv;
                            boolean bl = false;
                            NodeMatcher nodeMatcher = ((NodeAssertionOptions)expectedUnorderedNode.getValue()).getMatcher();
                            Intrinsics.checkNotNull((Object)it);
                            if (nodeMatcher.matches(it)) {
                                n = index$iv;
                                break block7;
                            }
                            ++index$iv;
                        }
                        n = -1;
                    }
                    if ((index = n) < 0) continue;
                    SimpleTree.Node actualUnorderedNode = (SimpleTree.Node)actualOrderedNodes.remove(index);
                    actualUnorderedNodes.add(actualUnorderedNode);
                }
                expectedNodes.clear();
                expectedNodes.addAll(expectedOrderedNodes);
                expectedNodes.addAll(expectedUnorderedNodes);
                actualNodes.clear();
                actualNodes.addAll(actualOrderedNodes);
                actualNodes.addAll((Collection)actualUnorderedNodes);
                for (Pair pair3 : CollectionsKt.zip((Iterable)expectedNodes, (Iterable)actualNodes)) {
                    SimpleTree.Node expectedNode = (SimpleTree.Node)pair3.component1();
                    SimpleTree.Node actualNode = (SimpleTree.Node)pair3.component2();
                    queue.add((Object)TuplesKt.to(expectedNode.getChildren(), actualNode.getChildren()));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002BA\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeAssertionOptions;", "T", "", "matcher", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "flattenIf", "", "skipIf", "isUnordered", "valueAssertion", "Lkotlin/Function1;", "", "(Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;ZZZLkotlin/jvm/functions/Function1;)V", "getFlattenIf", "()Z", "getMatcher", "()Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "getSkipIf", "getValueAssertion", "()Lkotlin/jvm/functions/Function1;", "setValueAssertion", "(Lkotlin/jvm/functions/Function1;)V", "intellij.platform.testFramework"})
    private static final class NodeAssertionOptions<T> {
        @NotNull
        private final NodeMatcher<T> matcher;
        private final boolean flattenIf;
        private final boolean skipIf;
        private final boolean isUnordered;
        @NotNull
        private Function1<? super T, Unit> valueAssertion;

        public NodeAssertionOptions(@NotNull NodeMatcher<T> matcher, boolean flattenIf, boolean skipIf, boolean isUnordered, @NotNull Function1<? super T, Unit> valueAssertion2) {
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            Intrinsics.checkNotNullParameter(valueAssertion2, (String)"valueAssertion");
            this.matcher = matcher;
            this.flattenIf = flattenIf;
            this.skipIf = skipIf;
            this.isUnordered = isUnordered;
            this.valueAssertion = valueAssertion2;
        }

        public /* synthetic */ NodeAssertionOptions(NodeMatcher nodeMatcher, boolean bl, boolean bl2, boolean bl3, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                function1 = 1.INSTANCE;
            }
            this(nodeMatcher, bl, bl2, bl3, function1);
        }

        @NotNull
        public final NodeMatcher<T> getMatcher() {
            return this.matcher;
        }

        public final boolean getFlattenIf() {
            return this.flattenIf;
        }

        public final boolean getSkipIf() {
            return this.skipIf;
        }

        public final boolean isUnordered() {
            return this.isUnordered;
        }

        @NotNull
        public final Function1<T, Unit> getValueAssertion() {
            return this.valueAssertion;
        }

        public final void setValueAssertion(@NotNull Function1<? super T, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.valueAssertion = function1;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0002\u000b\fJ\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\nH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "T", "", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "matches", "", "node", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTree$Node;", "Name", "NameRegex", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$Name;", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$NameRegex;", "intellij.platform.testFramework"})
    private static interface NodeMatcher<T> {
        @NotNull
        public String getDisplayName();

        public boolean matches(@NotNull SimpleTree.Node<T> var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\fH\u0016R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$Name;", "T", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "name", "", "(Ljava/lang/String;)V", "displayName", "getDisplayName", "()Ljava/lang/String;", "matches", "", "node", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTree$Node;", "intellij.platform.testFramework"})
        public static final class Name<T>
        implements NodeMatcher<T> {
            @NotNull
            private final String name;
            @NotNull
            private final String displayName;

            public Name(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.displayName = this.name = name;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                return this.displayName;
            }

            @Override
            public boolean matches(@NotNull SimpleTree.Node<T> node2) {
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                return Intrinsics.areEqual((Object)node2.getName(), (Object)this.name);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher$NameRegex;", "T", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTreeAssertionImpl$NodeMatcher;", "regex", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;)V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "matches", "", "node", "Lcom/intellij/platform/testFramework/treeAssertion/SimpleTree$Node;", "intellij.platform.testFramework"})
        public static final class NameRegex<T>
        implements NodeMatcher<T> {
            @NotNull
            private final Regex regex;
            @NotNull
            private final String displayName;

            public NameRegex(@NotNull Regex regex) {
                Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
                this.regex = regex;
                this.displayName = this.regex.toString();
            }

            @Override
            @NotNull
            public String getDisplayName() {
                return this.displayName;
            }

            @Override
            public boolean matches(@NotNull SimpleTree.Node<T> node2) {
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                return this.regex.matches((CharSequence)node2.getName());
            }
        }
    }
}

