/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.impl;

import com.intellij.platform.runtime.repository.IncludedRuntimeModule;
import com.intellij.platform.runtime.repository.ModuleImportance;
import com.intellij.platform.runtime.repository.ProductMode;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleGroup;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.impl.ProductModeMatcher;
import com.intellij.platform.runtime.repository.serialization.RawIncludedRuntimeModule;
import com.intellij.platform.runtime.repository.serialization.impl.PluginXmlReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PluginModuleGroup
implements RuntimeModuleGroup {
    private final RuntimeModuleDescriptor myMainModule;
    private final ProductMode myCurrentMode;
    private final RuntimeModuleRepository myRepository;
    private volatile List<IncludedRuntimeModule> myIncludedModules;
    private volatile Set<RuntimeModuleId> myOptionalModuleIds;

    public PluginModuleGroup(@NotNull RuntimeModuleDescriptor mainModule, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository) {
        if (mainModule == null) {
            PluginModuleGroup.$$$reportNull$$$0(0);
        }
        if (currentMode == null) {
            PluginModuleGroup.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            PluginModuleGroup.$$$reportNull$$$0(2);
        }
        this.myMainModule = mainModule;
        this.myCurrentMode = currentMode;
        this.myRepository = repository;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull IncludedRuntimeModule> getIncludedModules() {
        if (this.myIncludedModules == null) {
            this.loadIncludedModules();
        }
        List<IncludedRuntimeModule> list = this.myIncludedModules;
        if (list == null) {
            PluginModuleGroup.$$$reportNull$$$0(3);
        }
        return list;
    }

    private void loadIncludedModules() {
        List<RawIncludedRuntimeModule> rawIncludedModules = PluginXmlReader.loadPluginModules(this.myMainModule, this.myRepository);
        ArrayList<IncludedRuntimeModule> includedModules = new ArrayList<IncludedRuntimeModule>();
        LinkedHashSet<RuntimeModuleId> optionalModuleIds = new LinkedHashSet<RuntimeModuleId>();
        ProductModeMatcher matcher = new ProductModeMatcher(this.myCurrentMode);
        for (RawIncludedRuntimeModule rawModule : rawIncludedModules) {
            IncludedRuntimeModule included = rawModule.resolve(this.myRepository);
            if (included != null && matcher.matches(included.getModuleDescriptor())) {
                includedModules.add(included);
            }
            if (rawModule.getImportance().equals((Object)ModuleImportance.FUNCTIONAL)) continue;
            optionalModuleIds.add(rawModule.getModuleId());
        }
        this.myOptionalModuleIds = optionalModuleIds;
        this.myIncludedModules = includedModules;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull RuntimeModuleId> getOptionalModuleIds() {
        if (this.myOptionalModuleIds == null) {
            this.loadIncludedModules();
        }
        Set<RuntimeModuleId> set = this.myOptionalModuleIds;
        if (set == null) {
            PluginModuleGroup.$$$reportNull$$$0(4);
        }
        return set;
    }

    public String toString() {
        return "PluginModuleGroup{mainModule=" + this.myMainModule.getModuleId().getStringId() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/impl/PluginModuleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/impl/PluginModuleGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedModules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalModuleIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

