/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.framework.RdContext;
import com.jetbrains.rd.platform.DelegatedStringMarshaller;
import com.jetbrains.rd.platform.RdConstants;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/platform/RdConstants;", "", "()V", "clientIdContext", "Lcom/jetbrains/rd/framework/RdContext;", "", "getClientIdContext", "()Lcom/jetbrains/rd/framework/RdContext;", "fakeFrameForActionExecutorId", "getFakeFrameForActionExecutorId", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "notAllowedNameCharactersRegex", "Lkotlin/text/Regex;", "getNotAllowedNameCharactersRegex", "()Lkotlin/text/Regex;", "projectedComponentTitlePrefix", "getProjectedComponentTitlePrefix", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nRdConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdConstants.kt\ncom/jetbrains/rd/platform/RdConstants\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n14#2:65\n10#3:66\n*S KotlinDebug\n*F\n+ 1 RdConstants.kt\ncom/jetbrains/rd/platform/RdConstants\n*L\n10#1:65\n10#1:66\n*E\n"})
public final class RdConstants {
    @NotNull
    public static final RdConstants INSTANCE = new RdConstants();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Regex notAllowedNameCharactersRegex;
    @NotNull
    private static final String projectedComponentTitlePrefix;
    @NotNull
    private static final String fakeFrameForActionExecutorId;
    @NotNull
    private static final RdContext<String> clientIdContext;

    private RdConstants() {
    }

    @NotNull
    public final Regex getNotAllowedNameCharactersRegex() {
        return notAllowedNameCharactersRegex;
    }

    @NotNull
    public final String getProjectedComponentTitlePrefix() {
        return projectedComponentTitlePrefix;
    }

    @NotNull
    public final String getFakeFrameForActionExecutorId() {
        return fakeFrameForActionExecutorId;
    }

    @NotNull
    public final RdContext<String> getClientIdContext() {
        return clientIdContext;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RdConstants.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RdConstants.logger = logger;
        notAllowedNameCharactersRegex = new Regex("[<>&\"'/\\\\]");
        projectedComponentTitlePrefix = "!!PC!!";
        fakeFrameForActionExecutorId = "!!FakeFrameForActionExecutor!!";
        DelegatedStringMarshaller delegatedStringMarshaller = new DelegatedStringMarshaller();
        clientIdContext = (RdContext)new RdContext<String>(delegatedStringMarshaller){

            @Nullable
            public String getValue() {
                return ClientIdKt.getCurrentClientIdString();
            }

            @NotNull
            public AutoCloseable updateValue(@Nullable String newValue) {
                Thread newValueSetThread = Thread.currentThread();
                String oldValue = ClientIdKt.getCurrentClientIdString();
                ClientIdKt.setCurrentClientIdString((String)(newValue != null && ClientId.Companion.isFakeLocalId(newValue) ? ClientId.Companion.getLocalId().getValue() : newValue));
                return () -> clientIdContext.1.updateValue$lambda$1(newValueSetThread, oldValue);
            }

            @NotNull
            public String getValueForPerContextEntity() {
                String v = this.getValue();
                if (v != null) {
                    return v;
                }
                if (!RdConstants.access$getLogger$p().isTraceEnabled()) {
                    RdConstants.access$getLogger$p().warn("An attempt to use null ClientId context value for per context entity. Returning 'localId.value'. Enable Trace category to investigate stack traces");
                } else {
                    RdConstants.access$getLogger$p().error("An attempt to use null ClientId context value for per context entity. Returning 'localId.value'");
                }
                return ClientId.Companion.getLocalId().getValue();
            }

            private static final void updateValue$lambda$1(Thread $newValueSetThread, String $oldValue) {
                Thread currentThread = Thread.currentThread();
                boolean bl = $newValueSetThread.equals(currentThread);
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Value update cookie must be closed on the same thread (newValue was set on " + $newValueSetThread + ", but current thread is " + currentThread + ")";
                    throw new AssertionError((Object)string);
                }
                ClientIdKt.setCurrentClientIdString((String)$oldValue);
            }
        };
    }
}

