/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerBase;
import com.jetbrains.rd.ide.editor.EditorVersionHolder;
import com.jetbrains.rd.ide.editor.EditorVersionsKt;
import com.jetbrains.rd.ide.editor.PatchEngineEditorSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdFeatureItem;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchEditorVersion;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0002IJB?\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u001bH\u0002J\u0010\u00101\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020$2\u0006\u00102\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0019H\u0002J\u0018\u0010<\u001a\u00020$2\u0006\u00100\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020BH\u0014J\u0012\u0010C\u001a\u00020$2\b\b\u0002\u0010?\u001a\u00020\u0019H\u0002J(\u0010D\u001a\u00020$2\u0006\u00102\u001a\u00020E2\u0006\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010H\u001a\u00020$R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;Lcom/jetbrains/rd/ide/requests/PatchEngine;)V", "documentVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "getDocumentVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "idNumberCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "isInsideAllCaretsAction", "", "oldState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "postponedState", "version", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "versionHolder", "Lcom/jetbrains/rd/ide/editor/EditorVersionHolder;", "afterAllCaretsAction", "", "beforeAllCaretsAction", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "caretAdded", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "createNextId", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "documentChanged", "receiveCaretState", "newState", "receiveCaretStateChange", "change", "Lcom/jetbrains/rd/ide/model/RdCaretStateChange;", "receiveCaretStateSnapshot", "snapshot", "Lcom/jetbrains/rd/ide/model/RdCaretStateSnapshotBase;", "receiveSelection", "Lcom/jetbrains/rd/ide/model/RdCaretModelChange;", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/RdAbstractEditorVersion;", "sendCaretState", "mode", "Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$SendingMode;", "force", "sendCaretStateChange", "reason", "", "sendCaretStateSnapshot", "sendChange", "Lcom/jetbrains/rd/ide/model/RdEditorChange;", "oldVersion", "newVersion", "sendInitialCaretState", "Companion", "SendingMode", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchEngineEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineEditorSynchronizer.kt\ncom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 4 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,222:1\n19#2,4:223\n19#2,4:227\n19#2,4:231\n19#2,4:259\n11#3,12:235\n11#3,12:247\n31#4,2:263\n*S KotlinDebug\n*F\n+ 1 PatchEngineEditorSynchronizer.kt\ncom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer\n*L\n57#1:223,4\n143#1:227,4\n158#1:231,4\n191#1:259,4\n173#1:235,12\n182#1:247,12\n205#1:263,2\n*E\n"})
public class PatchEngineEditorSynchronizer
extends EditorSynchronizerBase
implements DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PatchEngineDocumentSynchronizer documentSynchronizer;
    @NotNull
    private final PatchEngine engine;
    @NotNull
    private final EditorVersionHolder versionHolder;
    @NotNull
    private final AtomicLong idNumberCounter;
    @NotNull
    private RdCaretState oldState;
    @Nullable
    private RdCaretState postponedState;
    private boolean isInsideAllCaretsAction;

    protected PatchEngineEditorSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull ClientAppSession session, @NotNull Editor editor, @NotNull TextControlId editorId, @NotNull TextControlModel editorModel, @NotNull PatchEngineDocumentSynchronizer documentSynchronizer, @NotNull PatchEngine engine) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)((Object)editorModel), (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        super(session, textControlLifetime, editorId, editorModel, editor);
        this.documentSynchronizer = documentSynchronizer;
        this.engine = engine;
        this.versionHolder = new EditorVersionHolder(EditorVersionsKt.getInitialEditorVersion());
        this.idNumberCounter = new AtomicLong();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            Intrinsics.checkNotNull((Object)caret);
            UtilKt.setId(caret, this.createNextId());
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.oldState = UtilKt.createModelCaretState(caretModel);
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Initial oldState=" + UtilKt.toDebugString(this.oldState));
        }
    }

    private final RdDocumentVersion getDocumentVersion() {
        return this.documentSynchronizer.getVersion();
    }

    private final RdCaretId createNextId() {
        long number = this.idNumberCounter.incrementAndGet();
        return new RdCaretId(true, number);
    }

    @Override
    public void caretAdded(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Caret caret = e.getCaret();
        if (caret != null && UtilKt.getId(caret) == null) {
            UtilKt.setId(caret, this.createNextId());
        }
        super.caretAdded(e);
    }

    public void beforeAllCaretsAction() {
        CaretModel caretModel = this.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.postponedState = UtilKt.createModelCaretState(caretModel);
        this.isInsideAllCaretsAction = true;
    }

    public void afterAllCaretsAction() {
        this.isInsideAllCaretsAction = false;
        if (this.postponedState == null) {
            this.sendCaretStateSnapshot(true);
        }
        this.postponedState = null;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PatchEngineEditorSynchronizer.sendCaretStateSnapshot$default(this, false, 1, null);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PatchEngineEditorSynchronizer.sendCaretStateSnapshot$default(this, false, 1, null);
    }

    @Override
    protected void sendCaretStateChange(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.sendCaretState(SendingMode.CHANGE, false);
    }

    public final void sendInitialCaretState() {
        RdCaretStateSnapshot snapshot = new RdCaretStateSnapshot(this.oldState, this.getTextControlId());
        this.sendChange(snapshot, this.versionHolder.getVersion(), this.versionHolder.incrementVersion(), this.getDocumentVersion());
    }

    private final void sendCaretStateSnapshot(boolean force) {
        this.sendCaretState(SendingMode.SNAPSHOT, force);
    }

    static /* synthetic */ void sendCaretStateSnapshot$default(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendCaretStateSnapshot");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        patchEngineEditorSynchronizer.sendCaretStateSnapshot(bl);
    }

    private final void sendCaretState(SendingMode mode, boolean force) {
        if (this.getDontSendChange()) {
            return;
        }
        if (this.isInsideAllCaretsAction) {
            if (this.postponedState != null && !this.documentSynchronizer.isReceivingChange()) {
                RdCaretState rdCaretState = this.postponedState;
                Intrinsics.checkNotNull((Object)rdCaretState);
                this.sendCaretState(rdCaretState, mode);
                this.postponedState = null;
            }
            return;
        }
        CaretModel caretModel = this.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        RdCaretState newState = UtilKt.createModelCaretState(caretModel);
        if (this.documentSynchronizer.isReceivingChange()) {
            this.oldState = newState;
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("sendCaretState(isReceivingChange=true): oldState updated to " + UtilKt.toDebugString(this.oldState));
            }
            return;
        }
        if (Intrinsics.areEqual((Object)newState, (Object)this.oldState) && !force) {
            return;
        }
        this.sendCaretState(newState, mode);
    }

    private final void sendCaretState(RdCaretState newState, SendingMode mode) {
        RdSelectionChangeBase change = switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> new RdCaretStateChange(this.oldState, newState, this.getTextControlId());
            case 2 -> new RdCaretStateSnapshot(newState, this.getTextControlId());
            default -> throw new NoWhenBranchMatchedException();
        };
        this.oldState = newState;
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("sendCaretState: oldState updated to " + UtilKt.toDebugString(this.oldState));
        }
        RdEditorVersion oldVersion = this.versionHolder.getVersion();
        RdEditorVersion newVersion = this.versionHolder.incrementVersion();
        this.sendChange(change, oldVersion, newVersion, this.getDocumentVersion());
    }

    @Override
    public void receiveSelection(@NotNull RdCaretModelChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RdCaretModelChange rdCaretModelChange = change;
        if (rdCaretModelChange instanceof RdCaretStateChange) {
            this.receiveCaretStateChange((RdCaretStateChange)change);
        } else if (rdCaretModelChange instanceof RdCaretStateSnapshotBase) {
            this.receiveCaretStateSnapshot((RdCaretStateSnapshotBase)change);
        } else {
            throw new IllegalStateException(("Unexpected change type: " + Reflection.getOrCreateKotlinClass(change.getClass()).getSimpleName()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void receiveCaretStateChange(RdCaretStateChange change) {
        void $this$usingTrueFlag_u24default$iv;
        PatchEngineEditorSynchronizer patchEngineEditorSynchronizer = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)receiveCaretStateChange.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.oldState, (Object)change.getOldState())) {
                this.getLogger().warn("expected old state: " + UtilKt.toDebugString(change.getOldState()) + ", actual: " + UtilKt.toDebugString(this.oldState));
            }
            this.receiveCaretState(change.getNewState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void receiveCaretStateSnapshot(RdCaretStateSnapshotBase snapshot) {
        void $this$usingTrueFlag_u24default$iv;
        PatchEngineEditorSynchronizer patchEngineEditorSynchronizer = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)receiveCaretStateSnapshot.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            this.receiveCaretState(snapshot.getState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    private final void receiveCaretState(RdCaretState newState) {
        UtilKt.applyStateTo(newState, this.getEditor());
        this.versionHolder.incrementVersion();
        CaretModel caretModel = this.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.oldState = UtilKt.createModelCaretState(caretModel);
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("receiveCaretState: oldState updated to " + UtilKt.toDebugString(this.oldState));
        }
    }

    @Override
    @NotNull
    public RdEditorVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull RdAbstractEditorVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdEditorVersion cfr_ignored_0 = (RdEditorVersion)v;
        this.versionHolder.reset((RdEditorVersion)v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void sendChange(RdEditorChange change, RdEditorVersion oldVersion, RdEditorVersion newVersion, RdDocumentVersion documentVersion) {
        void $this$sendAccumulated$iv;
        PatchEngine patchEngine = this.engine;
        String description$iv = "PatchEngineEditorSynchronizer.sendChange";
        boolean $i$f$sendAccumulated = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated$iv, true, description$iv, null, 4, null));
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl = false;
            ChangeScope $this$sendChange_u24lambda_u246 = it$iv.getSession().getChangeScope();
            boolean bl2 = false;
            RdPatchEditorVersion oldRdVersion = new RdPatchEditorVersion(oldVersion, change.getEditorId());
            RdPatchEditorVersion newRdVersion = new RdPatchEditorVersion(newVersion, change.getEditorId());
            $this$sendChange_u24lambda_u246.pushExpected(oldRdVersion);
            if (RdPatchUtilsKt.updatingChange(change, oldVersion, newVersion)) {
                $this$sendChange_u24lambda_u246.pushUpdated(newRdVersion);
            }
            $this$sendChange_u24lambda_u246.pushExpected(new RdPatchDocumentVersion(documentVersion, change.getEditorId().getDocumentId()));
            if (change instanceof RdFeatureItem) {
                $this$sendChange_u24lambda_u246.pushFeature(change);
            } else {
                $this$sendChange_u24lambda_u246.pushChange(change);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$Companion;", "", "()V", "create", "Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PatchEngineEditorSynchronizer create(@NotNull ClientAppSession session, @NotNull Lifetime textControlLifetime, @NotNull TextControlId editorId, @NotNull TextControlModel editorModel, @NotNull Editor editor, @NotNull PatchEngineDocumentSynchronizer documentSynchronizer, @NotNull RdPatchEngine engine) {
            PatchEngineEditorSynchronizer patchEngineEditorSynchronizer;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
            Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
            Intrinsics.checkNotNullParameter((Object)((Object)editorModel), (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            PatchEngineEditorSynchronizer $this$create_u24lambda_u240 = patchEngineEditorSynchronizer = new PatchEngineEditorSynchronizer(textControlLifetime, session, editor, editorId, editorModel, documentSynchronizer, engine);
            boolean bl = false;
            $this$create_u24lambda_u240.init();
            return patchEngineEditorSynchronizer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$SendingMode;", "", "(Ljava/lang/String;I)V", "SNAPSHOT", "CHANGE", "intellij.rd.platform"})
    private static final class SendingMode
    extends Enum<SendingMode> {
        public static final /* enum */ SendingMode SNAPSHOT = new SendingMode();
        public static final /* enum */ SendingMode CHANGE = new SendingMode();
        private static final /* synthetic */ SendingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SendingMode[] values() {
            return (SendingMode[])$VALUES.clone();
        }

        public static SendingMode valueOf(String value2) {
            return Enum.valueOf(SendingMode.class, value2);
        }

        @NotNull
        public static EnumEntries<SendingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sendingModeArray = new SendingMode[]{SendingMode.SNAPSHOT, SendingMode.CHANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SendingMode.values().length];
            try {
                nArray[SendingMode.CHANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SendingMode.SNAPSHOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

