/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.export;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.StringAccessor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 72\u00020\u0001:\u000278B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u0002H\u00170\u0016j\b\u0012\u0004\u0012\u0002H\u0017`\u0018\"\u0004\b\u0000\u0010\u0017H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001cH\u0002J\u001f\u0010\u001d\u001a\u00020\u00002\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001f\"\u00020\u0011\u00a2\u0006\u0002\u0010 J\u0014\u0010\u001d\u001a\u00020\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110!J\u001f\u0010\"\u001a\u00020\u00002\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u001f\"\u00020\u0014\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0!2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u000eH\u0002J\u0018\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0002J\u0006\u0010.\u001a\u00020\u0000J\b\u0010/\u001a\u00020\u001aH\u0002J\u001a\u00100\u001a\u00020\t2\u0006\u0010'\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u000eH\u0002J\u001e\u00103\u001a\u00020\u001a2\f\u00104\u001a\b\u0012\u0004\u0012\u00020&0!2\u0006\u00105\u001a\u00020\tH\u0002J\u0006\u00106\u001a\u00020\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/editorconfig/configmanagement/export/EditorConfigSettingsWriter;", "Ljava/io/OutputStreamWriter;", "myProject", "Lcom/intellij/openapi/project/Project;", "out", "Ljava/io/OutputStream;", "mySettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "myAddRootFlag", "", "myCommentOutProperties", "(Lcom/intellij/openapi/project/Project;Ljava/io/OutputStream;Lcom/intellij/psi/codeStyle/CodeStyleSettings;ZZ)V", "myGeneralOptions", "", "", "myLanguages", "", "Lcom/intellij/lang/Language;", "myNoHeaders", "myPropertyKinds", "Lorg/editorconfig/configmanagement/extended/EditorConfigPropertyKind;", "createEmptyMutableSet", "Ljava/util/HashSet;", "T", "Lkotlin/collections/HashSet;", "fillGeneralOptions", "", "target", "", "forLanguages", "languages", "", "([Lcom/intellij/lang/Language;)Lorg/editorconfig/configmanagement/export/EditorConfigSettingsWriter;", "", "forPropertyKinds", "kinds", "([Lorg/editorconfig/configmanagement/extended/EditorConfigPropertyKind;)Lorg/editorconfig/configmanagement/export/EditorConfigSettingsWriter;", "getKeyValuePairs", "Lorg/editorconfig/configmanagement/export/EditorConfigSettingsWriter$KeyValuePair;", "mapper", "Lcom/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper;", "isNameAllowed", "ecName", "matchesGeneral", "name", "value", "withoutHeaders", "writeGeneralSection", "writeLangSection", "Lcom/intellij/application/options/codeStyle/properties/LanguageCodeStylePropertyMapper;", "pattern", "writeProperties", "pairs", "commentOut", "writeSettings", "Companion", "KeyValuePair", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigSettingsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigSettingsWriter.kt\norg/editorconfig/configmanagement/export/EditorConfigSettingsWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,210:1\n1#2:211\n1855#3,2:212\n1045#3:214\n1855#3,2:215\n526#4:217\n511#4,6:218\n125#5:224\n152#5,3:225\n*S KotlinDebug\n*F\n+ 1 EditorConfigSettingsWriter.kt\norg/editorconfig/configmanagement/export/EditorConfigSettingsWriter\n*L\n39#1:212,2\n101#1:214\n102#1:215,2\n116#1:217\n116#1:218,6\n117#1:224\n117#1:225,3\n*E\n"})
public final class EditorConfigSettingsWriter
extends OutputStreamWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project myProject;
    @NotNull
    private final CodeStyleSettings mySettings;
    private final boolean myAddRootFlag;
    private final boolean myCommentOutProperties;
    private boolean myNoHeaders;
    @Nullable
    private Set<? extends Language> myLanguages;
    @NotNull
    private Set<? extends EditorConfigPropertyKind> myPropertyKinds;
    @NotNull
    private final Map<String, String> myGeneralOptions;
    @NotNull
    private static final Comparator<KeyValuePair> PAIR_COMPARATOR = EditorConfigSettingsWriter::PAIR_COMPARATOR$lambda$11;

    /*
     * WARNING - void declaration
     */
    public EditorConfigSettingsWriter(@Nullable Project myProject, @NotNull OutputStream out, @NotNull CodeStyleSettings mySettings, boolean myAddRootFlag, boolean myCommentOutProperties) {
        void $this$myGeneralOptions_u24lambda_u240;
        HashMap hashMap;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)mySettings, (String)"mySettings");
        super(out, StandardCharsets.UTF_8);
        this.myProject = myProject;
        this.mySettings = mySettings;
        this.myAddRootFlag = myAddRootFlag;
        this.myCommentOutProperties = myCommentOutProperties;
        EnumSet<EditorConfigPropertyKind> enumSet = EnumSet.allOf(EditorConfigPropertyKind.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"allOf(...)");
        this.myPropertyKinds = enumSet;
        HashMap hashMap2 = hashMap = new HashMap();
        EditorConfigSettingsWriter editorConfigSettingsWriter = this;
        boolean bl = false;
        this.fillGeneralOptions((Map)$this$myGeneralOptions_u24lambda_u240);
        editorConfigSettingsWriter.myGeneralOptions = hashMap;
    }

    private final void fillGeneralOptions(Map<String, String> target) {
        String encoding;
        Iterable $this$forEach$iv = this.getKeyValuePairs((AbstractCodeStylePropertyMapper)new GeneralCodeStylePropertyMapper(this.mySettings));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyValuePair it = (KeyValuePair)element$iv;
            boolean bl = false;
            target.put(it.getKey(), it.getValue());
        }
        target.put("ij_continuation_indent_size", String.valueOf(this.mySettings.OTHER_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE));
        if (this.myProject != null && (encoding = Utils.INSTANCE.getEncoding(this.myProject)) != null) {
            target.put("charset", encoding);
        }
        String string = this.mySettings.getLineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineSeparator(...)");
        String lineSeparator = Utils.INSTANCE.getLineSeparatorString(string);
        if (lineSeparator != null) {
            target.put("end_of_line", lineSeparator);
        }
        target.put("insert_final_newline", String.valueOf(EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF()));
        Boolean trimSpaces = Utils.INSTANCE.getTrimTrailingSpaces();
        if (trimSpaces != null) {
            target.put("trim_trailing_whitespace", trimSpaces.toString());
        }
    }

    private final <T> HashSet<T> createEmptyMutableSet() {
        return new HashSet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EditorConfigSettingsWriter forLanguages(@NotNull List<? extends Language> languages) {
        void $this$forLanguages_u24lambda_u242;
        HashSet hashSet;
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        HashSet hashSet2 = hashSet = this.createEmptyMutableSet();
        EditorConfigSettingsWriter editorConfigSettingsWriter = this;
        boolean bl = false;
        $this$forLanguages_u24lambda_u242.addAll((Collection)languages);
        editorConfigSettingsWriter.myLanguages = hashSet;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EditorConfigSettingsWriter forLanguages(Language ... languages) {
        void $this$forLanguages_u24lambda_u243;
        HashSet hashSet;
        Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
        HashSet hashSet2 = hashSet = this.createEmptyMutableSet();
        EditorConfigSettingsWriter editorConfigSettingsWriter = this;
        boolean bl = false;
        CollectionsKt.addAll((Collection)((Collection)$this$forLanguages_u24lambda_u243), (Object[])languages);
        editorConfigSettingsWriter.myLanguages = hashSet;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EditorConfigSettingsWriter forPropertyKinds(EditorConfigPropertyKind ... kinds) {
        void $this$forPropertyKinds_u24lambda_u244;
        EnumSet<EditorConfigPropertyKind> enumSet;
        Intrinsics.checkNotNullParameter((Object)kinds, (String)"kinds");
        EnumSet<EditorConfigPropertyKind> enumSet2 = enumSet = EnumSet.noneOf(EditorConfigPropertyKind.class);
        EditorConfigSettingsWriter editorConfigSettingsWriter = this;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$forPropertyKinds_u24lambda_u244);
        CollectionsKt.addAll((Collection)((Collection)$this$forPropertyKinds_u24lambda_u244), (Object[])kinds);
        EnumSet<EditorConfigPropertyKind> enumSet3 = enumSet;
        Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"apply(...)");
        editorConfigSettingsWriter.myPropertyKinds = enumSet3;
        return this;
    }

    @NotNull
    public final EditorConfigSettingsWriter withoutHeaders() {
        this.myNoHeaders = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSettings() throws IOException {
        if (this.myAddRootFlag) {
            this.writeProperties(CollectionsKt.listOf((Object)new KeyValuePair("root", "true")), false);
            this.write("\n");
        }
        this.writeGeneralSection();
        MultiMap mappers2 = new MultiMap();
        CodeStylePropertiesUtil.collectMappers((CodeStyleSettings)this.mySettings, arg_0 -> EditorConfigSettingsWriter.writeSettings$lambda$5((Function1)new Function1<AbstractCodeStylePropertyMapper, Unit>((MultiMap<String, LanguageCodeStylePropertyMapper>)mappers2){
            final /* synthetic */ MultiMap<String, LanguageCodeStylePropertyMapper> $mappers;
            {
                this.$mappers = $mappers;
                super(1);
            }

            public final void invoke(@Nullable AbstractCodeStylePropertyMapper mapper) {
                LanguageFileType fileType;
                if (mapper instanceof LanguageCodeStylePropertyMapper && (fileType = ((LanguageCodeStylePropertyMapper)mapper).getLanguage().getAssociatedFileType()) != null) {
                    String pattern = Utils.INSTANCE.buildPattern((FileType)fileType);
                    this.$mappers.putValue((Object)pattern, (Object)mapper);
                }
            }
        }, arg_0));
        Set set = mappers2.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        for (String pattern : CollectionsKt.sorted((Iterable)set)) {
            void $this$forEach$iv;
            Iterable $this$sortedBy$iv;
            Intrinsics.checkNotNull((Object)pattern);
            if (((CharSequence)pattern).length() == 0) continue;
            String currPattern = null;
            currPattern = pattern;
            Collection collection = mappers2.get((Object)pattern);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Iterable iterable = collection;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LanguageCodeStylePropertyMapper it = (LanguageCodeStylePropertyMapper)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getLanguageDomainId());
                    it = (LanguageCodeStylePropertyMapper)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLanguageDomainId())));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LanguageCodeStylePropertyMapper mapper = (LanguageCodeStylePropertyMapper)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)mapper);
                if (!this.writeLangSection(mapper, currPattern)) continue;
                currPattern = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeGeneralSection() throws IOException {
        void $this$mapTo$iv$iv;
        String k;
        Map.Entry entry;
        Map $this$filterTo$iv$iv;
        if (!this.myNoHeaders) {
            this.write("[*]\n");
        }
        Map<String, String> $this$filter$iv = this.myGeneralOptions;
        boolean $i$f$filter = false;
        Map<String, String> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator.next();
            boolean bl = false;
            k = (String)entry.getKey();
            if (!this.isNameAllowed(k)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            k = (String)entry.getKey();
            String v = (String)entry.getValue();
            object.add(new KeyValuePair(k, v));
        }
        List pairs = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), PAIR_COMPARATOR);
        this.writeProperties(pairs, this.myCommentOutProperties);
    }

    private final boolean writeLangSection(LanguageCodeStylePropertyMapper mapper, String pattern) throws IOException {
        List<KeyValuePair> optionValueList;
        Language language = mapper.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        Set<? extends Language> languages = this.myLanguages;
        if ((languages == null || languages.contains(language2)) && !(optionValueList = this.getKeyValuePairs((AbstractCodeStylePropertyMapper)mapper)).isEmpty()) {
            if (pattern != null && !this.myNoHeaders) {
                this.write("\n[" + pattern + "]\n");
            }
            this.writeProperties(CollectionsKt.sortedWith((Iterable)optionValueList, PAIR_COMPARATOR), this.myCommentOutProperties);
            return true;
        }
        return false;
    }

    private final List<KeyValuePair> getKeyValuePairs(AbstractCodeStylePropertyMapper mapper) {
        List list;
        List $this$getKeyValuePairs_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String property : mapper.enumProperties()) {
            CodeStylePropertyAccessor accessor = mapper.getAccessor(property);
            Intrinsics.checkNotNull((Object)property);
            String name = EditorConfigSettingsWriter.Companion.getEditorConfigName(mapper, property);
            if (name == null || !this.isNameAllowed(name)) continue;
            Intrinsics.checkNotNull((Object)accessor);
            String value = EditorConfigSettingsWriter.Companion.getEditorConfigValue(accessor);
            if (value == null || mapper instanceof LanguageCodeStylePropertyMapper && this.matchesGeneral(name, value)) continue;
            $this$getKeyValuePairs_u24lambda_u2410.add(new KeyValuePair(name, value));
        }
        return CollectionsKt.build((List)list);
    }

    private final boolean matchesGeneral(String name, String value) {
        return Intrinsics.areEqual((Object)this.myGeneralOptions.get(name), (Object)value);
    }

    private final boolean isNameAllowed(String ecName) {
        return this.myPropertyKinds.contains((Object)EditorConfigSettingsWriter.Companion.getPropertyKind(ecName));
    }

    private final void writeProperties(List<KeyValuePair> pairs, boolean commentOut) throws IOException {
        for (KeyValuePair pair : pairs) {
            if (commentOut) {
                this.write("# ");
            }
            this.write(pair.getKey() + " = " + pair.getValue() + "\n");
        }
    }

    private static final void writeSettings$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final int PAIR_COMPARATOR$lambda$11(KeyValuePair a, KeyValuePair b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        EditorConfigPropertyKind aPropertyKind = EditorConfigSettingsWriter.Companion.getPropertyKind(a.getKey());
        EditorConfigPropertyKind bPropertyKind = EditorConfigSettingsWriter.Companion.getPropertyKind(b.getKey());
        return aPropertyKind != bPropertyKind ? Comparing.compare((Comparable)((Comparable)((Object)bPropertyKind)), (Comparable)((Comparable)((Object)aPropertyKind))) : Comparing.compare((Comparable)((Comparable)((Object)a.getKey())), (Comparable)((Comparable)((Object)b.getKey())));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\u0004\u0018\u00010\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/configmanagement/export/EditorConfigSettingsWriter$Companion;", "", "()V", "PAIR_COMPARATOR", "Ljava/util/Comparator;", "Lorg/editorconfig/configmanagement/export/EditorConfigSettingsWriter$KeyValuePair;", "kotlin.jvm.PlatformType", "getEditorConfigName", "", "mapper", "Lcom/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper;", "propertyName", "getEditorConfigValue", "accessor", "Lcom/intellij/application/options/codeStyle/properties/CodeStylePropertyAccessor;", "getPropertyKind", "Lorg/editorconfig/configmanagement/extended/EditorConfigPropertyKind;", "ecName", "intellij.editorconfig"})
    public static final class Companion {
        private Companion() {
        }

        private final String getEditorConfigValue(CodeStylePropertyAccessor<?> accessor) {
            String value = accessor.getAsString();
            CharSequence charSequence = value;
            return (charSequence == null || charSequence.length() == 0) && (CodeStylePropertiesUtil.isAccessorAllowingEmptyList(accessor) || accessor instanceof StringAccessor) ? "" : value;
        }

        private final EditorConfigPropertyKind getPropertyKind(String ecName) {
            String string = EditorConfigIntellijNameUtil.toIntellijName(ecName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toIntellijName(...)");
            String ijName = string;
            EditorConfigPropertyKind editorConfigPropertyKind = IntellijPropertyKindMap.getPropertyKind(ijName);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)editorConfigPropertyKind), (String)"getPropertyKind(...)");
            return editorConfigPropertyKind;
        }

        private final String getEditorConfigName(AbstractCodeStylePropertyMapper mapper, String propertyName) {
            List<String> list = EditorConfigIntellijNameUtil.toEditorConfigNames(mapper, propertyName);
            Intrinsics.checkNotNullExpressionValue(list, (String)"toEditorConfigNames(...)");
            List<String> editorConfigNames = list;
            return editorConfigNames.isEmpty() ? null : (editorConfigNames.size() == 1 ? editorConfigNames.get(0) : EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/configmanagement/export/EditorConfigSettingsWriter$KeyValuePair;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.editorconfig"})
    private static final class KeyValuePair {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public KeyValuePair(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final KeyValuePair copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new KeyValuePair(key, value);
        }

        public static /* synthetic */ KeyValuePair copy$default(KeyValuePair keyValuePair, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = keyValuePair.key;
            }
            if ((n & 2) != 0) {
                string2 = keyValuePair.value;
            }
            return keyValuePair.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "KeyValuePair(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result2 = this.key.hashCode();
            result2 = result2 * 31 + this.value.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KeyValuePair)) {
                return false;
            }
            KeyValuePair keyValuePair = (KeyValuePair)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)keyValuePair.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)keyValuePair.value);
        }
    }
}

