/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDirectoryIndexExcludePolicy
implements DirectoryIndexExcludePolicy {
    private static final String[] SITE_PACKAGES = new String[]{"site-packages", "dist-packages"};
    private final Project myProject;

    public PyDirectoryIndexExcludePolicy(@NotNull Project project) {
        if (project == null) {
            PyDirectoryIndexExcludePolicy.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public String @NotNull [] getExcludeUrlsForProject() {
        ArrayList<String> result = new ArrayList<String>();
        for (VirtualFile root : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
            VirtualFile file = root.findChild(".tox");
            if (file == null) continue;
            result.add(file.getUrl());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            PyDirectoryIndexExcludePolicy.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public Function<Sdk, List<VirtualFile>> getExcludeSdkRootsStrategy() {
        return sdk2 -> {
            LinkedList<VirtualFile> result = new LinkedList<VirtualFile>();
            if (sdk2 != null) {
                HashSet roots = ContainerUtil.newHashSet((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES));
                for (VirtualFile dir : sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                    for (String name : SITE_PACKAGES) {
                        VirtualFile sitePackages = dir.findChild(name);
                        if (sitePackages == null || roots.contains(sitePackages)) continue;
                        result.add(sitePackages);
                    }
                }
            }
            return result;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyDirectoryIndexExcludePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyDirectoryIndexExcludePolicy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeUrlsForProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

