/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMultiRootBranchConfig
extends DvcsMultiRootBranchConfig<GitRepository> {
    public GitMultiRootBranchConfig(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(0);
        }
        super(repositories2);
    }

    @NotNull
    public Collection<String> getLocalBranchNames() {
        Collection<String> collection = GitBranchUtil.getCommonBranches(this.myRepositories, true);
        if (collection == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    Collection<String> getRemoteBranches() {
        Collection<String> collection = GitBranchUtil.getCommonBranches(this.myRepositories, false);
        if (collection == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NlsSafe
    @Nullable
    public String getTrackedBranch(@NotNull String branch) {
        if (branch == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(3);
        }
        String trackedName = null;
        for (GitRepository repository : this.myRepositories) {
            GitRemoteBranch tracked = GitMultiRootBranchConfig.getTrackedBranch(repository, branch);
            if (tracked == null) {
                return null;
            }
            if (trackedName == null) {
                trackedName = tracked.getNameForLocalOperations();
                continue;
            }
            if (trackedName.equals(tracked.getNameForLocalOperations())) continue;
            return null;
        }
        return trackedName;
    }

    @NotNull
    public Collection<String> getCommonTrackingBranches(@NotNull String remoteBranch) {
        if (remoteBranch == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(4);
        }
        Collection trackingBranches = null;
        for (GitRepository repository : this.myRepositories) {
            Collection tb = GitMultiRootBranchConfig.getTrackingBranches(repository, remoteBranch);
            if (trackingBranches == null) {
                trackingBranches = tb;
                continue;
            }
            trackingBranches = ContainerUtil.intersection(trackingBranches, tb);
        }
        Collection<String> collection = trackingBranches == null ? Collections.emptyList() : trackingBranches;
        if (collection == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getTrackingBranches(@NotNull GitRepository repository, @NotNull String remoteBranch) {
        if (repository == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(6);
        }
        if (remoteBranch == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(7);
        }
        ArrayList<String> trackingBranches = new ArrayList<String>(1);
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!remoteBranch.equals(trackInfo.getRemoteBranch().getNameForLocalOperations())) continue;
            trackingBranches.add(trackInfo.getLocalBranch().getName());
        }
        ArrayList<String> arrayList = trackingBranches;
        if (arrayList == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static GitRemoteBranch getTrackedBranch(@NotNull GitRepository repository, @NotNull String branchName) {
        GitLocalBranch branch;
        if (repository == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(9);
        }
        if (branchName == null) {
            GitMultiRootBranchConfig.$$$reportNull$$$0(10);
        }
        return (branch = repository.getBranches().findLocalBranch(branchName)) == null ? null : branch.findTrackedBranch(repository);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GitRepository repository : this.myRepositories) {
            sb.append(repository.getPresentableUrl()).append(":").append(repository.getCurrentBranch()).append(":").append(repository.getState());
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitMultiRootBranchConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranch";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitMultiRootBranchConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalBranchNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranches";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTrackingBranches";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackingBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTrackedBranch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTrackingBranches";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTrackingBranches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 8 -> new IllegalStateException(string);
        };
    }
}

