/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShowCommitInLogAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GitShowCommitInLogAction.class);

    public GitShowCommitInLogAction() {
        super(GitBundle.messagePointer("vcs.history.action.gitlog", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        VcsRevisionNumber revision = this.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        GitShowCommitInLogAction.jumpToRevision(project, HashImpl.build((String)revision.asString()));
    }

    @Nullable
    protected VcsRevisionNumber getRevisionNumber(@NotNull AnActionEvent event) {
        VcsFileRevision fileRevision;
        VcsRevisionNumber revision;
        if (event == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(1);
        }
        if ((revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER)) == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    @Nullable
    protected VcsKey getVcsKey(@NotNull AnActionEvent event) {
        if (event == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(2);
        }
        return (VcsKey)event.getData(VcsDataKeys.VCS);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && this.getRevisionNumber(e) != null && Comparing.equal((Object)this.getVcsKey(e), (Object)GitVcs.getKey()));
    }

    static void jumpToRevision(@NotNull Project project, @NotNull Hash hash) {
        if (project == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(5);
        }
        if (hash == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(6);
        }
        VcsLogContentUtil.runInMainLog((Project)project, logUi2 -> GitShowCommitInLogAction.jumpToRevisionUnderProgress(project, (VcsLogUiEx)logUi2, hash));
    }

    private static void jumpToRevisionUnderProgress(@NotNull Project project, @NotNull VcsLogUiEx logUi2, @NotNull Hash hash) {
        ListenableFuture future2;
        if (project == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(7);
        }
        if (logUi2 == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(8);
        }
        if (hash == null) {
            GitShowCommitInLogAction.$$$reportNull$$$0(9);
        }
        if (!(future2 = VcsLogNavigationUtil.jumpToHash((VcsLogUiEx)logUi2, (String)hash.asString(), (boolean)false, (boolean)true)).isDone()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, GitBundle.message("git.log.show.commit.in.log.process", hash.asString()), false, PerformInBackgroundOption.ALWAYS_BACKGROUND, (Future)future2){
                final /* synthetic */ Future val$future;
                {
                    this.val$future = future2;
                    super(arg0, arg1, arg2, arg3);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        this.val$future.get();
                    }
                    catch (InterruptedException | CancellationException exception) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/log/GitShowCommitInLogAction$1", "run"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitShowCommitInLogAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitShowCommitInLogAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionNumber";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVcsKey";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "jumpToRevision";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "jumpToRevisionUnderProgress";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

