/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitSetupProjectConfig;
import git4idea.config.GitVcsOptions;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lgit4idea/config/GitSetupProjectConfig;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupConfigIfNeeded", "configVar", "Lgit4idea/config/GitSetupProjectConfig$ConfigVariables;", "settings", "Lgit4idea/config/GitVcsOptions;", "ConfigVariables", "intellij.vcs.git"})
public final class GitSetupProjectConfig
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitSetupProjectConfig this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ProjectLevelVcsManager.getInstance((Project)this.$project).runAfterInitialization(() -> execute.2.invoke$lambda$0(this.this$0, this.$project));
            }

            private static final void invoke$lambda$0(GitSetupProjectConfig this$0, Project $project) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                GitSetupProjectConfig.access$setupConfigIfNeeded(this$0, $project);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void setupConfigIfNeeded(Project project) {
        GitVcsOptions settings = (GitVcsOptions)GitVcsSettings.getInstance(project).getState();
        for (ConfigVariables configVar : ConfigVariables.values()) {
            Intrinsics.checkNotNull((Object)((Object)settings));
            this.setupConfigIfNeeded(project, configVar, settings);
        }
    }

    private final void setupConfigIfNeeded(Project project, ConfigVariables configVar, GitVcsOptions settings) {
        String string = (String)configVar.getSettingsGetter().invoke((Object)settings);
        if (string == null) {
            return;
        }
        String settingsValue = string;
        if (!((Boolean)configVar.getCondition().invoke((Object)project, (Object)settingsValue)).booleanValue()) {
            return;
        }
        List rootsToUpdate = new ArrayList();
        for (GitRepository repo : GitRepositoryManager.getInstance(project).getRepositories()) {
            String value = GitConfigUtil.getValue(project, repo.getRoot(), configVar.getGitName());
            if (value != null) continue;
            Intrinsics.checkNotNull((Object)repo);
            rootsToUpdate.add(repo);
        }
        for (GitRepository repo : rootsToUpdate) {
            String[] stringArray = new String[]{"--local"};
            GitConfigUtil.setValue(project, repo.getRoot(), configVar.getGitName(), settingsValue, stringArray);
        }
    }

    public static final /* synthetic */ void access$setupConfigIfNeeded(GitSetupProjectConfig $this, Project project) {
        $this.setupConfigIfNeeded(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B_\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00128\b\u0002\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0002\u0010\u000fRA\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lgit4idea/config/GitSetupProjectConfig$ConfigVariables;", "", "gitName", "", "settingsGetter", "Lkotlin/reflect/KProperty1;", "Lgit4idea/config/GitVcsOptions;", "condition", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ParameterName;", "name", "project", "value", "", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/reflect/KProperty1;Lkotlin/jvm/functions/Function2;)V", "getCondition", "()Lkotlin/jvm/functions/Function2;", "getGitName", "()Ljava/lang/String;", "getSettingsGetter", "()Lkotlin/reflect/KProperty1;", "GC_AUTO", "CORE_FS_MONITOR", "CORE_UNTRACKED_CACHE", "CORE_LONGPATHS", "FEATURE_MANY_FILES", "intellij.vcs.git"})
    private static final class ConfigVariables
    extends Enum<ConfigVariables> {
        @NotNull
        private final String gitName;
        @NotNull
        private final KProperty1<GitVcsOptions, String> settingsGetter;
        @NotNull
        private final Function2<Project, String, Boolean> condition;
        public static final /* enum */ ConfigVariables GC_AUTO = new ConfigVariables("GC_AUTO", 0, "gc.auto", (KProperty1)2.INSTANCE, null, 4, null);
        public static final /* enum */ ConfigVariables CORE_FS_MONITOR = new ConfigVariables("core.fsmonitor", (KProperty1<GitVcsOptions, String>)((KProperty1)3.INSTANCE), (Function2<? super Project, ? super String, Boolean>)((Function2)4.INSTANCE));
        public static final /* enum */ ConfigVariables CORE_UNTRACKED_CACHE = new ConfigVariables("CORE_UNTRACKED_CACHE", 2, "core.untrackedcache", (KProperty1)5.INSTANCE, null, 4, null);
        public static final /* enum */ ConfigVariables CORE_LONGPATHS = new ConfigVariables("core.longpaths", (KProperty1<GitVcsOptions, String>)((KProperty1)6.INSTANCE), (Function2<? super Project, ? super String, Boolean>)((Function2)7.INSTANCE));
        public static final /* enum */ ConfigVariables FEATURE_MANY_FILES = new ConfigVariables("FEATURE_MANY_FILES", 4, "feature.manyFiles", (KProperty1)8.INSTANCE, null, 4, null);
        private static final /* synthetic */ ConfigVariables[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConfigVariables(String gitName, KProperty1<GitVcsOptions, String> settingsGetter, Function2<? super Project, ? super String, Boolean> condition) {
            this.gitName = gitName;
            this.settingsGetter = settingsGetter;
            this.condition = condition;
        }

        /* synthetic */ ConfigVariables(String string, int n, String string2, KProperty1 kProperty1, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                function2 = 1.INSTANCE;
            }
            this(string2, (KProperty1<GitVcsOptions, String>)kProperty1, (Function2<? super Project, ? super String, Boolean>)function2);
        }

        @NotNull
        public final String getGitName() {
            return this.gitName;
        }

        @NotNull
        public final KProperty1<GitVcsOptions, String> getSettingsGetter() {
            return this.settingsGetter;
        }

        @NotNull
        public final Function2<Project, String, Boolean> getCondition() {
            return this.condition;
        }

        public static ConfigVariables[] values() {
            return (ConfigVariables[])$VALUES.clone();
        }

        public static ConfigVariables valueOf(String value) {
            return Enum.valueOf(ConfigVariables.class, value);
        }

        @NotNull
        public static EnumEntries<ConfigVariables> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = configVariablesArray = new ConfigVariables[]{ConfigVariables.GC_AUTO, ConfigVariables.CORE_FS_MONITOR, ConfigVariables.CORE_UNTRACKED_CACHE, ConfigVariables.CORE_LONGPATHS, ConfigVariables.FEATURE_MANY_FILES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

