/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.VcsLocaleHelper;
import git4idea.config.GitExecutableKt;
import git4idea.config.WslSupportedLocaleKey;
import git4idea.repo.GitConfigurationCache;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"computeWslSupportedLocaleKey", "", "", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitExecutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutableKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,230:1\n10#2:231\n10#2:232\n10#2:233\n*S KotlinDebug\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutableKt\n*L\n207#1:231\n218#1:232\n224#1:233\n*E\n"})
public final class GitExecutableKt {
    private static final Map<String, String> computeWslSupportedLocaleKey(WSLDistribution distribution) {
        Map envLocale;
        Object[] objectArray = new VcsLocaleHelper.Locale[]{VcsLocaleHelper.INSTANCE.getEN_UTF_LOCALE(), VcsLocaleHelper.INSTANCE.getC_UTF_LOCALE()};
        List knownLocales = CollectionsKt.listOf((Object[])objectArray);
        String env = distribution.getEnvironmentVariable("LANG");
        if (env != null && (envLocale = VcsLocaleHelper.INSTANCE.findMatchingLocale(env, knownLocales)) != null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WslSupportedLocaleKey.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Detected locale by ENV: " + env);
            return envLocale;
        }
        try {
            String[] stringArray = new String[]{"locale", "-a"};
            String string = distribution.executeOnWsl(10000, stringArray).getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String locales = string;
            Sequence systemLocales2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)locales), (Function1)computeWslSupportedLocaleKey.systemLocales.1.INSTANCE), (Function1)computeWslSupportedLocaleKey.systemLocales.2.INSTANCE);
            for (String locale : systemLocales2) {
                Map someLocale = VcsLocaleHelper.INSTANCE.findMatchingLocale(locale, knownLocales);
                if (someLocale == null) continue;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(WslSupportedLocaleKey.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Detected locale from available: " + env);
                return someLocale;
            }
        }
        catch (ExecutionException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GitConfigurationCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            return null;
        }
        return null;
    }

    public static final /* synthetic */ Map access$computeWslSupportedLocaleKey(WSLDistribution distribution) {
        return GitExecutableKt.computeWslSupportedLocaleKey(distribution);
    }
}

