/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.RequestorsKt;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionProviderBase;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import git4idea.branch.GitBranchOperationType;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.validators.GitBranchValidatorKt;
import git4idea.validators.GitRefNameValidator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 62\u00020\u0001:\u000256Bc\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u0012\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\b\"0 H\u0002J\u0018\u0010#\u001a\u0012\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\b\"0 H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u0004\u0018\u00010)J1\u0010*\u001a\u001b\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-\u0012\u0006\u0012\u0004\u0018\u00010.0+\u00a2\u0006\u0002\b/2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u000202H\u0002J\f\u00103\u001a\u000204*\u00020-H\u0002R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lgit4idea/branch/GitNewBranchDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "dialogTitle", "", "initialName", "showCheckOutOption", "", "showResetOption", "showSetTrackingOption", "localConflictsAllowed", "operation", "Lgit4idea/branch/GitBranchOperationType;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;ZZZZLgit4idea/branch/GitBranchOperationType;)V", "branchName", "checkout", "localBranchDirectories", "", "reset", "tracking", "validator", "Lgit4idea/validators/GitRefNameValidator;", "kotlin.jvm.PlatformType", "collectDirectories", "branchNames", "", "withTrailingSlash", "collectLocalBranchNames", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "collectRemoteBranchNames", "createBranchNameCompletion", "Lgit4idea/branch/GitNewBranchDialog$BranchNamesCompletion;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "showAndGetOptions", "Lgit4idea/branch/GitNewBranchOptions;", "validateBranchName", "Lkotlin/Function2;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lkotlin/ExtensionFunctionType;", "onApply", "overwriteCheckbox", "Ljavax/swing/JCheckBox;", "cleanBranchNameAndAdjustCursorIfNeeded", "", "BranchNamesCompletion", "Companion", "intellij.vcs.git"})
public final class GitNewBranchDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<GitRepository> repositories;
    private final boolean showCheckOutOption;
    private final boolean showResetOption;
    private final boolean showSetTrackingOption;
    private final boolean localConflictsAllowed;
    @NotNull
    private final GitBranchOperationType operation;
    private boolean checkout;
    private boolean reset;
    private boolean tracking;
    @NotNull
    private String branchName;
    private final GitRefNameValidator validator;
    @NotNull
    private final Set<String> localBranchDirectories;
    private static final char NAME_SEPARATOR = '/';

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption, boolean showSetTrackingOption, boolean localConflictsAllowed, @NotNull GitBranchOperationType operation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        super(project, true);
        this.project = project;
        this.repositories = repositories2;
        this.showCheckOutOption = showCheckOutOption;
        this.showResetOption = showResetOption;
        this.showSetTrackingOption = showSetTrackingOption;
        this.localConflictsAllowed = localConflictsAllowed;
        this.operation = operation;
        this.checkout = true;
        this.tracking = this.showSetTrackingOption;
        String string = initialName;
        if (string == null) {
            string = "";
        }
        this.branchName = string;
        this.validator = GitRefNameValidator.getInstance();
        this.localBranchDirectories = CollectionsKt.toSet((Iterable)this.collectDirectories(SequencesKt.asIterable(this.collectLocalBranchNames()), false));
        this.setTitle(dialogTitle);
        this.setOKButtonText(this.operation.getText());
        this.init();
    }

    public /* synthetic */ GitNewBranchDialog(Project project, Collection collection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, GitBranchOperationType gitBranchOperationType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            bl4 = false;
        }
        if ((n & 0x100) != 0) {
            gitBranchOperationType = bl ? GitBranchOperationType.CREATE : GitBranchOperationType.CHECKOUT;
        }
        this(project, collection, string, string2, bl, bl2, bl3, bl4, gitBranchOperationType);
    }

    @Nullable
    public final GitNewBranchOptions showAndGetOptions() {
        if (!this.showAndGet()) {
            return null;
        }
        String string = this.validator.cleanUpBranchName(this.branchName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanUpBranchName(...)");
        return new GitNewBranchOptions(((Object)StringsKt.trim((CharSequence)string)).toString(), this.checkout, this.reset, this.tracking);
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GitNewBranchDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                JCheckBox overwriteCheckbox = new JCheckBox(GitBundle.message("new.branch.dialog.overwrite.existing.branch.checkbox", new Object[0]));
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, overwriteCheckbox){
                    final /* synthetic */ GitNewBranchDialog this$0;
                    final /* synthetic */ JCheckBox $overwriteCheckbox;
                    {
                        this.this$0 = $receiver;
                        this.$overwriteCheckbox = $overwriteCheckbox;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell cell = $this$row.cell((JComponent)new TextFieldWithCompletion(GitNewBranchDialog.access$getProject$p(this.this$0), (TextCompletionProvider)GitNewBranchDialog.access$createBranchNameCompletion(this.this$0), GitNewBranchDialog.access$getBranchName$p(this.this$0), true, true, false, false)).bind((Function1)createCenterPanel.1.INSTANCE, (Function2)createCenterPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                            @Nullable
                            public Object get() {
                                return GitNewBranchDialog.access$getBranchName$p((GitNewBranchDialog)((Object)this.receiver));
                            }

                            public void set(@Nullable Object value) {
                                GitNewBranchDialog.access$setBranchName$p((GitNewBranchDialog)((Object)this.receiver), (String)value);
                            }
                        }))).align((Align)AlignX.FILL.INSTANCE);
                        String string = GitBundle.message("new.branch.dialog.branch.name", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        cell.label(string, LabelPosition.TOP).focused().applyToComponent((Function1)createCenterPanel.4.INSTANCE).validationRequestor(RequestorsKt.getWHEN_STATE_CHANGED().invoke((Object)this.$overwriteCheckbox)).validationRequestor(RequestorsKt.getWHEN_DOCUMENT_CHANGED()).validationOnApply(GitNewBranchDialog.access$validateBranchName(this.this$0, true, this.$overwriteCheckbox)).validationOnInput(GitNewBranchDialog.access$validateBranchName(this.this$0, false, this.$overwriteCheckbox));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, overwriteCheckbox){
                    final /* synthetic */ GitNewBranchDialog this$0;
                    final /* synthetic */ JCheckBox $overwriteCheckbox;
                    {
                        this.this$0 = $receiver;
                        this.$overwriteCheckbox = $overwriteCheckbox;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        if (GitNewBranchDialog.access$getShowCheckOutOption$p(this.this$0)) {
                            String string = GitBundle.message("new.branch.dialog.checkout.branch.checkbox", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                                @Nullable
                                public Object get() {
                                    return GitNewBranchDialog.access$getCheckout$p((GitNewBranchDialog)((Object)this.receiver));
                                }

                                public void set(@Nullable Object value) {
                                    GitNewBranchDialog.access$setCheckout$p((GitNewBranchDialog)((Object)this.receiver), (Boolean)value);
                                }
                            }));
                        }
                        if (GitNewBranchDialog.access$getShowResetOption$p(this.this$0)) {
                            ButtonKt.bindSelected((Cell)$this$row.cell((JComponent)this.$overwriteCheckbox), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                                @Nullable
                                public Object get() {
                                    return GitNewBranchDialog.access$getReset$p((GitNewBranchDialog)((Object)this.receiver));
                                }

                                public void set(@Nullable Object value) {
                                    GitNewBranchDialog.access$setReset$p((GitNewBranchDialog)((Object)this.receiver), (Boolean)value);
                                }
                            })).applyToComponent((Function1)createCenterPanel.3.INSTANCE).getComponent();
                        }
                        if (GitNewBranchDialog.access$getShowSetTrackingOption$p(this.this$0)) {
                            String string = GitBundle.message("new.branch.dialog.set.tracking.branch.checkbox", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                                @Nullable
                                public Object get() {
                                    return GitNewBranchDialog.access$getTracking$p((GitNewBranchDialog)((Object)this.receiver));
                                }

                                public void set(@Nullable Object value) {
                                    GitNewBranchDialog.access$setTracking$p((GitNewBranchDialog)((Object)this.receiver), (Boolean)value);
                                }
                            })).getComponent();
                        }
                    }
                }), (int)1, null);
            }
        }));
    }

    private final BranchNamesCompletion createBranchNameCompletion() {
        Sequence<String> localBranches2 = this.collectLocalBranchNames();
        Sequence<String> remoteBranches2 = this.collectRemoteBranchNames();
        Collection<String> localDirectories = this.collectDirectories(SequencesKt.asIterable(localBranches2), true);
        Collection<String> remoteDirectories = this.collectDirectories(SequencesKt.asIterable(remoteBranches2), true);
        Set allSuggestions = new LinkedHashSet();
        CollectionsKt.addAll((Collection)allSuggestions, localBranches2);
        CollectionsKt.addAll((Collection)allSuggestions, remoteBranches2);
        CollectionsKt.addAll((Collection)allSuggestions, (Iterable)localDirectories);
        CollectionsKt.addAll((Collection)allSuggestions, (Iterable)remoteDirectories);
        return new BranchNamesCompletion(CollectionsKt.toList((Iterable)localDirectories), CollectionsKt.toList((Iterable)allSuggestions));
    }

    private final Sequence<String> collectLocalBranchNames() {
        return SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.repositories), (Function1)collectLocalBranchNames.1.INSTANCE), (Function1)collectLocalBranchNames.2.INSTANCE);
    }

    private final Sequence<String> collectRemoteBranchNames() {
        return SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.repositories), (Function1)collectRemoteBranchNames.1.INSTANCE), (Function1)collectRemoteBranchNames.2.INSTANCE);
    }

    private final Collection<String> collectDirectories(Iterable<String> branchNames, boolean withTrailingSlash) {
        Set directories = new LinkedHashSet();
        for (String branchName : branchNames) {
            int end;
            if (!StringsKt.contains$default((CharSequence)branchName, (char)'/', (boolean)false, (int)2, null)) continue;
            int index = 0;
            while (index < branchName.length() && (end = StringsKt.indexOf$default((CharSequence)branchName, (char)'/', (int)index, (boolean)false, (int)4, null)) != -1) {
                String string;
                Collection collection = directories;
                if (withTrailingSlash) {
                    String string2 = branchName.substring(0, end + 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    String string3 = branchName.substring(0, end);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                }
                collection.add(string);
                index = end + 1;
            }
        }
        return directories;
    }

    private final Function2<ValidationInfoBuilder, TextFieldWithCompletion, ValidationInfo> validateBranchName(boolean onApply, JCheckBox overwriteCheckbox) {
        return (Function2)new Function2<ValidationInfoBuilder, TextFieldWithCompletion, ValidationInfo>(this, onApply, overwriteCheckbox){
            final /* synthetic */ GitNewBranchDialog this$0;
            final /* synthetic */ boolean $onApply;
            final /* synthetic */ JCheckBox $overwriteCheckbox;
            {
                this.this$0 = $receiver;
                this.$onApply = $onApply;
                this.$overwriteCheckbox = $overwriteCheckbox;
                super(2);
            }

            @Nullable
            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$null, @NotNull TextFieldWithCompletion it) {
                ValidationInfo validationInfo;
                ValidationInfo errorInfo;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0, it){
                    final /* synthetic */ GitNewBranchDialog this$0;
                    final /* synthetic */ TextFieldWithCompletion $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        GitNewBranchDialog.access$cleanBranchNameAndAdjustCursorIfNeeded(this.this$0, this.$it);
                    }
                }), (int)1, null);
                String string = GitNewBranchDialog.access$getValidator$p(this.this$0).cleanUpBranchName(it.getText());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanUpBranchName(...)");
                String branchName = ((Object)StringsKt.trim((CharSequence)string)).toString();
                ValidationInfo validationInfo2 = this.$onApply ? GitBranchValidatorKt.checkRefNameEmptyOrHead(branchName) : null;
                if (validationInfo2 == null && (validationInfo2 = GitBranchValidatorKt.conflictsWithRemoteBranch(GitNewBranchDialog.access$getRepositories$p(this.this$0), branchName)) == null) {
                    validationInfo2 = GitBranchValidatorKt.conflictsWithLocalBranchDirectory(GitNewBranchDialog.access$getLocalBranchDirectories$p(this.this$0), branchName);
                }
                ValidationInfo validationInfo3 = errorInfo = validationInfo2;
                if (validationInfo3 != null) {
                    String string2 = validationInfo3.message;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message");
                    validationInfo = $this$null.error(string2);
                } else {
                    ValidationInfo localBranchConflict = GitBranchValidatorKt.conflictsWithLocalBranch(GitNewBranchDialog.access$getRepositories$p(this.this$0), branchName);
                    this.$overwriteCheckbox.setEnabled(localBranchConflict != null);
                    if (localBranchConflict == null || this.$overwriteCheckbox.isSelected()) {
                        validationInfo = null;
                    } else if (localBranchConflict.warning && GitNewBranchDialog.access$getLocalConflictsAllowed$p(this.this$0)) {
                        String string3 = new HtmlBuilder().append(localBranchConflict.message + ".").br().append(GitNewBranchDialog.access$getOperation$p(this.this$0).getDescription()).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                        validationInfo = $this$null.warning(string3);
                    } else if (GitNewBranchDialog.access$getShowResetOption$p(this.this$0)) {
                        String string4 = new HtmlBuilder().append(localBranchConflict.message + ".").br().append(GitBundle.message("new.branch.dialog.overwrite.existing.branch.warning", new Object[0])).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                        validationInfo = $this$null.error(string4);
                    } else {
                        String string5 = localBranchConflict.message;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message");
                        validationInfo = $this$null.error(string5);
                    }
                }
                return validationInfo;
            }
        };
    }

    private final void cleanBranchNameAndAdjustCursorIfNeeded(TextFieldWithCompletion $this$cleanBranchNameAndAdjustCursorIfNeeded) {
        if (this.isDisposed()) {
            return;
        }
        String string = $this$cleanBranchNameAndAdjustCursorIfNeeded.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String initialText = string;
        int initialCaret = $this$cleanBranchNameAndAdjustCursorIfNeeded.getCaretModel().getOffset();
        String string2 = this.validator.cleanUpBranchNameOnTyping(initialText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cleanUpBranchNameOnTyping(...)");
        String fixedText = string2;
        if (Intrinsics.areEqual((Object)fixedText, (Object)initialText)) {
            return;
        }
        String initialTextBeforeCaret = StringsKt.take((String)initialText, (int)initialCaret);
        String string3 = this.validator.cleanUpBranchNameOnTyping(initialTextBeforeCaret);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cleanUpBranchNameOnTyping(...)");
        String fixedTextBeforeCaret = string3;
        int fixedCaret = fixedTextBeforeCaret.length();
        $this$cleanBranchNameAndAdjustCursorIfNeeded.setText(fixedText);
        $this$cleanBranchNameAndAdjustCursorIfNeeded.getCaretModel().moveToOffset(fixedCaret);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption, boolean showSetTrackingOption, boolean localConflictsAllowed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories2, dialogTitle, initialName, showCheckOutOption, showResetOption, showSetTrackingOption, localConflictsAllowed, null, 256, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption, boolean showSetTrackingOption) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories2, dialogTitle, initialName, showCheckOutOption, showResetOption, showSetTrackingOption, false, null, 384, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption, boolean showResetOption) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories2, dialogTitle, initialName, showCheckOutOption, showResetOption, false, false, null, 448, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName, boolean showCheckOutOption) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories2, dialogTitle, initialName, showCheckOutOption, false, false, false, null, 480, null);
    }

    @JvmOverloads
    public GitNewBranchDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable String initialName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        this(project, repositories2, dialogTitle, initialName, false, false, false, false, null, 496, null);
    }

    public static final /* synthetic */ Project access$getProject$p(GitNewBranchDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ BranchNamesCompletion access$createBranchNameCompletion(GitNewBranchDialog $this) {
        return $this.createBranchNameCompletion();
    }

    public static final /* synthetic */ String access$getBranchName$p(GitNewBranchDialog $this) {
        return $this.branchName;
    }

    public static final /* synthetic */ void access$setBranchName$p(GitNewBranchDialog $this, String string) {
        $this.branchName = string;
    }

    public static final /* synthetic */ Function2 access$validateBranchName(GitNewBranchDialog $this, boolean onApply, JCheckBox overwriteCheckbox) {
        return $this.validateBranchName(onApply, overwriteCheckbox);
    }

    public static final /* synthetic */ boolean access$getShowCheckOutOption$p(GitNewBranchDialog $this) {
        return $this.showCheckOutOption;
    }

    public static final /* synthetic */ boolean access$getCheckout$p(GitNewBranchDialog $this) {
        return $this.checkout;
    }

    public static final /* synthetic */ void access$setCheckout$p(GitNewBranchDialog $this, boolean bl) {
        $this.checkout = bl;
    }

    public static final /* synthetic */ boolean access$getShowResetOption$p(GitNewBranchDialog $this) {
        return $this.showResetOption;
    }

    public static final /* synthetic */ boolean access$getReset$p(GitNewBranchDialog $this) {
        return $this.reset;
    }

    public static final /* synthetic */ void access$setReset$p(GitNewBranchDialog $this, boolean bl) {
        $this.reset = bl;
    }

    public static final /* synthetic */ boolean access$getShowSetTrackingOption$p(GitNewBranchDialog $this) {
        return $this.showSetTrackingOption;
    }

    public static final /* synthetic */ boolean access$getTracking$p(GitNewBranchDialog $this) {
        return $this.tracking;
    }

    public static final /* synthetic */ void access$setTracking$p(GitNewBranchDialog $this, boolean bl) {
        $this.tracking = bl;
    }

    public static final /* synthetic */ void access$cleanBranchNameAndAdjustCursorIfNeeded(GitNewBranchDialog $this, TextFieldWithCompletion $receiver) {
        $this.cleanBranchNameAndAdjustCursorIfNeeded($receiver);
    }

    public static final /* synthetic */ GitRefNameValidator access$getValidator$p(GitNewBranchDialog $this) {
        return $this.validator;
    }

    public static final /* synthetic */ Collection access$getRepositories$p(GitNewBranchDialog $this) {
        return $this.repositories;
    }

    public static final /* synthetic */ Set access$getLocalBranchDirectories$p(GitNewBranchDialog $this) {
        return $this.localBranchDirectories;
    }

    public static final /* synthetic */ boolean access$getLocalConflictsAllowed$p(GitNewBranchDialog $this) {
        return $this.localConflictsAllowed;
    }

    public static final /* synthetic */ GitBranchOperationType access$getOperation$p(GitNewBranchDialog $this) {
        return $this.operation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0012"}, d2={"Lgit4idea/branch/GitNewBranchDialog$BranchNamesCompletion;", "Lcom/intellij/util/textCompletion/TextCompletionProviderBase;", "", "Lcom/intellij/openapi/project/DumbAware;", "localDirectories", "", "allSuggestions", "(Ljava/util/List;Ljava/util/List;)V", "getAllSuggestions", "()Ljava/util/List;", "getLocalDirectories", "getValues", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "prefix", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.vcs.git"})
    private static final class BranchNamesCompletion
    extends TextCompletionProviderBase<String>
    implements DumbAware {
        @NotNull
        private final List<String> localDirectories;
        @NotNull
        private final List<String> allSuggestions;

        public BranchNamesCompletion(@NotNull List<String> localDirectories, @NotNull List<String> allSuggestions) {
            Intrinsics.checkNotNullParameter(localDirectories, (String)"localDirectories");
            Intrinsics.checkNotNullParameter(allSuggestions, (String)"allSuggestions");
            super((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), CollectionsKt.emptyList(), false);
            this.localDirectories = localDirectories;
            this.allSuggestions = allSuggestions;
        }

        @NotNull
        public final List<String> getLocalDirectories() {
            return this.localDirectories;
        }

        @NotNull
        public final List<String> getAllSuggestions() {
            return this.allSuggestions;
        }

        @NotNull
        protected Collection<String> getValues(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if (parameters.isAutoPopup()) {
                return this.localDirectories;
            }
            return this.allSuggestions;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/branch/GitNewBranchDialog$Companion;", "", "()V", "NAME_SEPARATOR", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

