/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.config.unified.SshConfigManagerBase;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfigManagerImpl
implements SshConfigManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(SshConfigManagerImpl.class);
    @NotNull
    private final SshConfigManagerBase.App myAppBase = (SshConfigManagerBase.App)ApplicationManager.getApplication().getService(SshConfigManagerBase.App.class);
    @Nullable
    private final SshConfigManagerBase.Project myProjectBase;
    private SshConfigManagerBase.Listener myProjectListener;
    private SshConfigManagerBase.Listener myAppListener = new SshConfigManagerBase.Listener(){

        @Override
        public void changed(@NotNull SshConfigManager.ConfigsData data) {
            if (data == null) {
                1.$$$reportNull$$$0(0);
            }
            if (SshConfigManagerImpl.this.myCollectingChangesLevel > 0) {
                SshConfigManagerImpl.this.myHasAppChanges = true;
            } else {
                SshConfigManagerImpl.this.notifyListeners(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ssh/config/unified/SshConfigManagerImpl$1", "changed"));
        }
    };
    private int myCollectingChangesLevel = 0;
    private boolean myHasAppChanges = false;
    private boolean myHasProjectChanges = false;

    private SshConfigManagerImpl(@Nullable Project project2) {
        this.myAppBase.addChangeListener(this.myAppListener);
        if (project2 != null) {
            this.myProjectBase = (SshConfigManagerBase.Project)project2.getService(SshConfigManagerBase.Project.class);
            this.myProjectListener = new SshConfigManagerBase.Listener(){

                @Override
                public void changed(@NotNull SshConfigManager.ConfigsData data) {
                    if (data == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (SshConfigManagerImpl.this.myCollectingChangesLevel > 0) {
                        SshConfigManagerImpl.this.myHasProjectChanges = true;
                    } else {
                        SshConfigManagerImpl.this.notifyListeners(false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ssh/config/unified/SshConfigManagerImpl$2", "changed"));
                }
            };
            this.myProjectBase.addChangeListener(this.myProjectListener);
        } else {
            this.myProjectBase = null;
        }
    }

    public void removeDataConfig(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(0);
        }
        this.startCollectingNotifications();
        if (data.getConfig().isProjectLevel()) {
            LOG.assertTrue(this.myProjectBase != null);
            this.myProjectBase.removeFromSavedAndCurrent(data);
        } else {
            this.myAppBase.removeFromSavedAndCurrent(data);
        }
        data.getConfig().eraseAuthDataFromPasswordSafe();
        this.handleNotifications(false);
    }

    @Override
    @NotNull
    public List<SshConfig> getConfigs() {
        List list2 = ContainerUtil.map(this.getLastSavedAndCurrentData().getLastSavedData(), SshUiData::getConfig);
        if (list2 == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @NotNull
    public SshConfigManager.ConfigsData getLastSavedAndCurrentData() {
        SshConfigManager.ConfigsData data = this.myAppBase.getLastSavedAndCurrentData();
        if (this.myProjectBase != null) {
            data = data.createMerged(this.myProjectBase.getLastSavedAndCurrentData());
        }
        SshConfigManager.ConfigsData configsData = data;
        if (configsData == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(2);
        }
        return configsData;
    }

    @NotNull
    private MessageBus getMessageBus() {
        MessageBus messageBus = this.myProjectBase != null && this.myProjectBase.getProject() != null ? this.myProjectBase.getProject().getMessageBus() : ApplicationManager.getApplication().getMessageBus();
        MessageBus messageBus2 = messageBus;
        if (messageBus2 == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(3);
        }
        return messageBus2;
    }

    @Override
    public void setCurrentData(@NotNull List<SshUiData> newData, @NotNull SshConfigManager.Listener source) {
        if (newData == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(4);
        }
        if (source == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(5);
        }
        this.startCollectingNotifications();
        Split split = new Split(newData);
        if (this.myProjectBase != null) {
            this.myProjectBase.setCurrentData(split.myProjectData);
        } else {
            LOG.assertTrue(split.myProjectData.isEmpty());
        }
        this.myAppBase.setCurrentData(split.myAppData);
        this.handleNotifications(false);
    }

    @Override
    public void startCollectingNotifications() {
        if (this.myCollectingChangesLevel == 0) {
            this.myHasAppChanges = false;
            this.myHasProjectChanges = false;
        }
        ++this.myCollectingChangesLevel;
    }

    @Override
    public void handleNotifications(boolean async) {
        --this.myCollectingChangesLevel;
        if (this.myCollectingChangesLevel == 0) {
            if (async) {
                ApplicationManager.getApplication().invokeLater(() -> this.notifyListenersIfNeeded());
            } else {
                this.notifyListenersIfNeeded();
            }
        }
    }

    private void notifyListenersIfNeeded() {
        if (this.myCollectingChangesLevel == 0) {
            if (this.myHasAppChanges) {
                this.notifyListeners(true);
            } else if (this.myHasProjectChanges) {
                this.notifyListeners(false);
            }
            this.myHasAppChanges = false;
            this.myHasProjectChanges = false;
        }
    }

    private void notifyListeners(boolean applicationOnly) {
        MessageBus bus = applicationOnly ? ApplicationManager.getApplication().getMessageBus() : this.getMessageBus();
        ((SshConfigManager.Listener)bus.syncPublisher(SSH_CONFIGS)).sshConfigsChanged();
    }

    @Override
    public void applyData(@NotNull List<SshUiData> data, @Nullable SshConfigManager.Listener source) {
        if (data == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(6);
        }
        this.startCollectingNotifications();
        Split split = new Split(data);
        if (this.myProjectBase != null) {
            this.myProjectBase.applyData(split.myProjectData);
        } else {
            LOG.assertTrue(split.myProjectData.isEmpty());
        }
        this.myAppBase.applyData(split.myAppData);
        this.handleNotifications(false);
    }

    @Override
    public void disposeCurrentData() {
        this.startCollectingNotifications();
        if (this.myProjectBase != null) {
            this.myProjectBase.applyLastSavedData();
        }
        this.myAppBase.applyLastSavedData();
        this.handleNotifications(false);
    }

    private void addDataConfig(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(7);
        }
        this.startCollectingNotifications();
        if (data.getConfig().isProjectLevel()) {
            LOG.assertTrue(this.myProjectBase != null);
            this.myProjectBase.addToSavedAndCurrent(data);
        } else {
            this.myAppBase.addToSavedAndCurrent(data);
        }
        data.saveAuthDataToPasswordSafe();
        this.handleNotifications(false);
    }

    @Override
    @NotNull
    public SshUiData moveDataConfig(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(this.myProjectBase != null);
        this.startCollectingNotifications();
        if (data.getConfig().isProjectLevel()) {
            this.myProjectBase.removeFromSavedAndCurrent(data);
            this.myAppBase.addToSavedAndCurrent(data);
        } else {
            this.myProjectBase.addToSavedAndCurrent(data);
            this.myAppBase.removeFromSavedAndCurrent(data);
        }
        data.getConfig().setProjectLevel(!data.getConfig().isProjectLevel());
        this.handleNotifications(false);
        SshUiData sshUiData = data;
        if (sshUiData == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(9);
        }
        return sshUiData;
    }

    @Override
    @Nullable
    public SshUiData findCurrentDataByName(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        SshUiData data = null;
        if (this.myProjectBase != null) {
            data = this.myProjectBase.findCurrentByDataName(name);
        }
        if (data == null) {
            data = this.myAppBase.findCurrentByDataName(name);
        }
        return data;
    }

    @Override
    @Nullable
    public SshUiData findCurrentData(PresentableId id) {
        if (id == null) {
            return null;
        }
        SshUiData data = null;
        if (this.myProjectBase != null) {
            data = this.myProjectBase.findCurrentByData(id);
        }
        if (data == null) {
            data = this.myAppBase.findCurrentByData(id);
        }
        return data;
    }

    @Override
    @Nullable
    public SshUiData findCurrentDataById(@Nullable String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        SshUiData data = null;
        if (this.myProjectBase != null) {
            data = this.myProjectBase.findCurrentByDataId(id);
        }
        if (data == null) {
            data = this.myAppBase.findCurrentByDataId(id);
        }
        return data;
    }

    @Override
    @NotNull
    public SshConfig register(boolean isProjectLevel, @Nullable String host2, @Nullable String literalPort, @Nullable String username, AuthType authType, @Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase, @Nullable String keyPath, @Nullable String customName) {
        SshConfig sshConfig = this.registerData(isProjectLevel, host2, literalPort, username, authType, password, passphrase, savePassword, savePassphrase, true, keyPath, customName).getConfig();
        if (sshConfig == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(10);
        }
        return sshConfig;
    }

    @Override
    @NotNull
    public SshConfig register(boolean isProjectLevel, @Nullable String host2, @Nullable String literalPort, @Nullable String username, AuthType authType, @Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase, boolean useOpenSSHConfig, @Nullable String keyPath, @Nullable String customName) {
        SshConfig sshConfig = this.registerData(isProjectLevel, host2, literalPort, username, authType, password, passphrase, savePassword, savePassphrase, useOpenSSHConfig, keyPath, customName).getConfig();
        if (sshConfig == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(11);
        }
        return sshConfig;
    }

    @Override
    @NotNull
    public SshUiData register(@NotNull SshUiData data) {
        if (data == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(12);
        }
        return this.registerData(data.getConfig().isProjectLevel(), data.getHost(), data.getLiteralPort(), data.getUserName(), data.getAuthType(), data.getPassword(), data.getPassphrase(), data.isStorePassword(), data.isStorePassphrase(), data.isOpenSshConfigUsageForced(), data.getPrivateKeyFile(), data.getConfig().getCustomName());
    }

    @NotNull
    private SshUiData registerData(boolean isProjectLevel, @Nullable String host2, @Nullable String literalPort, @Nullable String username, AuthType authType, @Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase, boolean useOpenSSHConfigForced, @Nullable String keyPath, @Nullable String customName) {
        if (isProjectLevel && this.myProjectBase == null) {
            throw new IllegalStateException("Use project service for project-level configs");
        }
        SshConfig.AuthData authData = SshConfig.AuthData.create(password, passphrase, savePassword, savePassphrase);
        if (SshConfigManagerImpl.isConfigured(host2, literalPort)) {
            SshUiData existingData = null;
            if (isProjectLevel) {
                existingData = this.myProjectBase.findExistingData(host2, literalPort, username, authType);
            }
            if (existingData == null) {
                existingData = this.myAppBase.findExistingData(host2, literalPort, username, authType);
            }
            if (existingData != null) {
                String existingKeyPath = existingData.getPrivateKeyFile();
                existingData.getConfig().mergeKeyPath(keyPath);
                boolean retainedExistingKeyPath = Objects.equals(existingKeyPath, existingData.getPrivateKeyFile());
                boolean retainedRegisteredKeyPath = Objects.equals(keyPath, existingData.getPrivateKeyFile());
                existingData.mergeAndSaveAuthData(authData, retainedExistingKeyPath, retainedRegisteredKeyPath);
                existingData.getConfig().mergeCustomName(customName);
                SshUiData sshUiData = existingData;
                if (sshUiData == null) {
                    SshConfigManagerImpl.$$$reportNull$$$0(13);
                }
                return sshUiData;
            }
        }
        SshConfig config = SshConfig.create(isProjectLevel, host2, 0, username, authType, keyPath);
        config.setLiteralPort(literalPort);
        config.setOpenSshConfigUsageForced(useOpenSSHConfigForced);
        SshUiData data = new SshUiData(config, authData);
        this.addDataConfig(data);
        config.setCustomName(customName);
        SshUiData sshUiData = data;
        if (sshUiData == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(14);
        }
        return sshUiData;
    }

    @Override
    @Nullable
    public SshConfig getConfigFromInitialMappingNameToId(@NotNull String initialName) {
        if (initialName == null) {
            SshConfigManagerImpl.$$$reportNull$$$0(15);
        }
        String id = null;
        if (this.myProjectBase != null) {
            id = this.myProjectBase.getIdFromInitialName(initialName);
        }
        if (id == null) {
            id = this.myAppBase.getIdFromInitialName(initialName);
        }
        if (id == null) {
            return null;
        }
        return this.findConfigById(id);
    }

    @Override
    public boolean isPassphraseMayBeRequired(String privateKeyPath) {
        return Ssh.isPassphraseMayBeRequired(privateKeyPath, SshBackendLibrary.get());
    }

    public void dispose() {
        this.myAppBase.removeChangeListener(this.myAppListener);
        this.myAppListener = null;
        if (this.myProjectBase != null) {
            this.myProjectBase.removeChangeListener(this.myProjectListener);
            this.myProjectListener = null;
        }
    }

    private static boolean isConfigured(@Nullable String host2, @Nullable String literalPort) {
        if (StringUtil.isEmpty((String)host2)) {
            return false;
        }
        if (StringUtil.isEmpty((String)literalPort)) {
            return false;
        }
        return SshConfig.parseSshPort(literalPort) > -1;
    }

    @Override
    @Nullable
    public SshConfig findConfigByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        @Nullable SshUiData data = this.findCurrentDataByName(name);
        return data == null ? null : data.getConfig();
    }

    @Override
    @Nullable
    public SshConfig findConfigById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        @Nullable SshUiData data = this.findCurrentDataById(id);
        return data == null ? null : data.getConfig();
    }

    @Override
    @Nullable
    public SshConfig findConfig(@Nullable PresentableId id) {
        SshUiData data = this.findCurrentData(id);
        return data == null ? null : data.getConfig();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 9, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/config/unified/SshConfigManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSavedAndCurrentData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDataConfig";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "register";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "registerData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeDataConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDataConfig";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveDataConfig";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFromInitialMappingNameToId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 9, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }

    private static final class Split {
        private final List<SshUiData> myProjectData;
        private final List<SshUiData> myAppData;

        private Split(@NotNull List<SshUiData> data) {
            if (data == null) {
                Split.$$$reportNull$$$0(0);
            }
            this.myProjectData = new ArrayList<SshUiData>();
            this.myAppData = new ArrayList<SshUiData>();
            for (SshUiData datum : data) {
                if (datum.getConfig().isProjectLevel()) {
                    this.myProjectData.add(datum);
                    continue;
                }
                this.myAppData.add(datum);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ssh/config/unified/SshConfigManagerImpl$Split", "<init>"));
        }
    }

    public static class AppLevel
    extends SshConfigManagerImpl {
        public AppLevel() {
            super(null);
        }
    }

    public static class ProjectLevel
    extends SshConfigManagerImpl {
        public ProjectLevel(@NotNull Project project2) {
            if (project2 == null) {
                ProjectLevel.$$$reportNull$$$0(0);
            }
            super(project2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ssh/config/unified/SshConfigManagerImpl$ProjectLevel", "<init>"));
        }
    }
}

