/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.AlreadyClosedException;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SQLiteConfig;
import org.jetbrains.sqlite.SQLiteOpenMode;
import org.jetbrains.sqlite.SqlStatementPool;
import org.jetbrains.sqlite.SqliteConnectionKt;
import org.jetbrains.sqlite.SqliteDbKt;
import org.jetbrains.sqlite.SqliteLibLoaderKt;
import org.jetbrains.sqlite.SqlitePreparedStatement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u0017\u001a\u00020\u00122\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJu\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u0018\u001a\u00020\u001e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2K\u0010\u001f\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(%\u0012\u0004\u0012\u0002H\u001d0 H\u0082\b\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\tH\u0002J\u0006\u0010(\u001a\u00020\u0012J+\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u001d0*\"\b\b\u0000\u0010\u001d*\u00020+2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u0002H\u001d\u00a2\u0006\u0002\u0010.J-\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u001d0*\"\b\b\u0000\u0010\u001d*\u00020+2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010-\u001a\u0002H\u001d\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020\u0012J\u001c\u00101\u001a\u00020\u00052\b\b\u0001\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ#\u00102\u001a\u0004\u0018\u0001032\b\b\u0001\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u00104J\u001e\u00105\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ.\u00106\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0010\"\b\b\u0000\u0010\u001d*\u00020+2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\f\u00107\u001a\b\u0012\u0004\u0012\u0002H\u001d08J<\u00109\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2!\u0010:\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u0002H\u001d0;H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010>\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H\u001d08\u00a2\u0006\u0002\u0010?R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006@"}, d2={"Lorg/jetbrains/sqlite/SqliteConnection;", "Ljava/lang/AutoCloseable;", "file", "Ljava/nio/file/Path;", "readOnly", "", "(Ljava/nio/file/Path;Z)V", "dbRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/sqlite/NativeDB;", "isClosed", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "statementPoolList", "", "Lorg/jetbrains/sqlite/SqlStatementPool;", "beginTransaction", "", "close", "commit", "doClose", "db", "execute", "sql", "", "values", "", "executeLifecycle", "T", "", "executor", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "", "statementPointer", "empty", "([BLjava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "getDb", "interruptAndClose", "prepareStatement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "Lorg/jetbrains/sqlite/Binder;", "sqlUtf8", "binder", "([BLorg/jetbrains/sqlite/Binder;)Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "(Ljava/lang/String;Lorg/jetbrains/sqlite/Binder;)Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "rollback", "selectBoolean", "selectInt", "", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Integer;", "selectString", "statementPool", "binderProducer", "Lkotlin/Function0;", "useDb", "task", "Lkotlin/Function1;", "useDb$intellij_platform_sqlite", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withSavePoint", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n67#1,6:298\n67#1,6:304\n67#1,6:310\n67#1,6:316\n67#1,6:322\n67#1,6:328\n67#1,6:334\n139#1:340\n67#1,6:341\n140#1,8:347\n139#1:355\n67#1,6:356\n140#1,8:362\n139#1:370\n67#1,6:371\n140#1,8:377\n67#1,6:385\n67#1,6:391\n139#1:397\n67#1,6:398\n140#1,8:404\n67#1,6:412\n67#1,6:418\n67#1,6:424\n1#2:297\n*S KotlinDebug\n*F\n+ 1 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n*L\n87#1:298,6\n96#1:304,6\n99#1:310,6\n96#1:316,6\n99#1:322,6\n96#1:328,6\n99#1:334,6\n113#1:340\n113#1:341,6\n113#1:347,8\n125#1:355\n125#1:356,6\n125#1:362,8\n131#1:370\n131#1:371,6\n131#1:377,8\n139#1:385,6\n153#1:391,6\n157#1:397\n157#1:398,6\n157#1:404,8\n211#1:412,6\n215#1:418,6\n219#1:424,6\n*E\n"})
public final class SqliteConnection
implements AutoCloseable {
    @NotNull
    private final AtomicReference<NativeDB> dbRef;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final List<SqlStatementPool<?>> statementPoolList;

    public SqliteConnection(@Nullable Path file, boolean readOnly) {
        int status;
        this.dbRef = new AtomicReference();
        this.lock = new ReentrantLock();
        this.statementPoolList = new ArrayList();
        Path path2 = file;
        if (path2 != null && (path2 = path2.getParent()) != null) {
            Path it = path2;
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        SqliteLibLoaderKt.loadNativeDb();
        NativeDB db = new NativeDB();
        Path path3 = file;
        String filePath = path3 != null && (path3 = path3.toAbsolutePath()) != null && (path3 = path3.normalize()) != null ? ((Object)path3).toString() : null;
        String string2 = filePath;
        if (string2 == null) {
            string2 = ":memory:";
        }
        if ((status = db.open(string2, readOnly ? SQLiteOpenMode.READONLY.flag : SQLiteOpenMode.READWRITE.flag | SQLiteOpenMode.CREATE.flag) & 0xFF) != 0) {
            String string3 = filePath;
            if (string3 == null) {
                string3 = "";
            }
            throw SqliteDbKt.newException(status, string3, null);
        }
        try {
            new SQLiteConfig().apply$intellij_platform_sqlite(db);
        }
        catch (Throwable e) {
            try {
                db.close();
            }
            catch (Throwable closeException) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)closeException);
            }
            throw e;
        }
        this.dbRef.set(db);
    }

    public /* synthetic */ SqliteConnection(Path path2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(path2, bl);
    }

    public final boolean isClosed() {
        return this.dbRef.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T extends Binder> SqlStatementPool<T> statementPool(@Language(value="SQLite") @NotNull String sql2, @NotNull Function0<? extends T> binderProducer) {
        SqlStatementPool<? extends T> sqlStatementPool;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter(binderProducer, (String)"binderProducer");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            SqlStatementPool<? extends T> pool = new SqlStatementPool<T>(sql2, this, binderProducer);
            this.statementPoolList.add(pool);
            sqlStatementPool = pool;
        }
        finally {
            lock.unlock();
        }
        return sqlStatementPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T useDb$intellij_platform_sqlite(@NotNull Function1<? super NativeDB, ? extends T> task2) {
        Object object;
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            object = task2.invoke((Object)this.getDb());
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)2);
        lock.unlock();
        InlineMarker.finallyEnd((int)2);
        return (T)object;
    }

    private final NativeDB getDb() {
        NativeDB nativeDB = this.dbRef.get();
        if (nativeDB == null) {
            throw new AlreadyClosedException();
        }
        return nativeDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withSavePoint(@NotNull Function0<? extends T> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        String name = "p" + SqliteConnectionKt.access$getSavepointNameGenerator$p().getAndIncrement() + "_" + Long.toUnsignedString(System.currentTimeMillis(), 36);
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Object object = this_$iv.lock;
        object.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            byte[] byArray = ("savepoint " + name).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it.exec(byArray);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            object.unlock();
        }
        boolean ok = false;
        try {
            Object result2 = task2.invoke();
            ok = true;
            object = result2;
        }
        catch (Throwable throwable) {
            boolean bl;
            Lock lock;
            boolean $i$f$useDb$intellij_platform_sqlite2;
            SqliteConnection this_$iv2;
            if (ok) {
                this_$iv2 = this;
                $i$f$useDb$intellij_platform_sqlite2 = false;
                if (this_$iv2.dbRef.get() == null) {
                    throw new AlreadyClosedException();
                }
                lock = this_$iv2.lock;
                lock.lock();
                try {
                    bl = false;
                    NativeDB it = this_$iv2.getDb();
                    boolean bl3 = false;
                    byte[] byArray = ("release savepoint " + name).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    it.exec(byArray);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
            this_$iv2 = this;
            $i$f$useDb$intellij_platform_sqlite2 = false;
            if (this_$iv2.dbRef.get() == null) {
                throw new AlreadyClosedException();
            }
            lock = this_$iv2.lock;
            lock.lock();
            try {
                bl = false;
                NativeDB it = this_$iv2.getDb();
                boolean bl4 = false;
                byte[] byArray = ("rollback transaction to savepoint " + name).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                it.exec(byArray);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            throw throwable;
        }
        SqliteConnection this_$iv3 = this;
        boolean $i$f$useDb$intellij_platform_sqlite3 = false;
        if (this_$iv3.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock bl2 = this_$iv3.lock;
        bl2.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv3.getDb();
            boolean bl5 = false;
            byte[] byArray = ("release savepoint " + name).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it.exec(byArray);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            bl2.unlock();
        }
        return (T)object;
    }

    @NotNull
    public final <T extends Binder> SqlitePreparedStatement<T> prepareStatement(@Language(value="SQLite") @NotNull String sql2, @NotNull T binder) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter(binder, (String)"binder");
        return this.prepareStatement(StringsKt.encodeToByteArray((String)sql2), binder);
    }

    @NotNull
    public final <T extends Binder> SqlitePreparedStatement<T> prepareStatement(@NotNull byte[] sqlUtf8, @NotNull T binder) {
        Intrinsics.checkNotNullParameter((Object)sqlUtf8, (String)"sqlUtf8");
        Intrinsics.checkNotNullParameter(binder, (String)"binder");
        return new SqlitePreparedStatement<T>(this, sqlUtf8, binder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean selectBoolean(@Language(value="SQLite") @NotNull String sql2, @Nullable Object values2) {
        boolean bl;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            boolean bl2;
            boolean bl3 = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl4 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                void statementPointer;
                int value2;
                void isEmpty;
                boolean isEmpty$iv;
                SqliteConnectionKt.access$bind(statementPointer$iv, values2, db$iv);
                boolean bl5 = isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                long l = statementPointer$iv;
                NativeDB db = db$iv;
                boolean bl6 = false;
                boolean bl7 = isEmpty != false ? false : (value2 = db.column_int((long)statementPointer, 0)) != 0;
                bl2 = bl7;
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            bl = bl2;
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    public static /* synthetic */ boolean selectBoolean$default(SqliteConnection sqliteConnection, String string2, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return sqliteConnection.selectBoolean(string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final String selectString(@Language(value="SQLite") @NotNull String sql2, @Nullable Object values2) {
        String string2;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            String string3;
            boolean bl = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl2 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                void statementPointer;
                void empty2;
                boolean isEmpty$iv;
                SqliteConnectionKt.access$bind(statementPointer$iv, values2, db$iv);
                boolean bl3 = isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                long l = statementPointer$iv;
                NativeDB db = db$iv;
                boolean bl4 = false;
                string3 = empty2 != false ? null : db.column_text((long)statementPointer, 0);
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            string2 = string3;
        }
        finally {
            lock.unlock();
        }
        return string2;
    }

    public static /* synthetic */ String selectString$default(SqliteConnection sqliteConnection, String string2, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return sqliteConnection.selectString(string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final Integer selectInt(@Language(value="SQLite") @NotNull String sql2, @Nullable Object values2) {
        Integer n;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            Integer n2;
            boolean bl = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl2 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                void statementPointer;
                void empty2;
                boolean isEmpty$iv;
                SqliteConnectionKt.access$bind(statementPointer$iv, values2, db$iv);
                boolean bl3 = isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                long l = statementPointer$iv;
                NativeDB db = db$iv;
                boolean bl4 = false;
                n2 = empty2 != false ? null : Integer.valueOf(db.column_int((long)statementPointer, 0));
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            n = n2;
        }
        finally {
            lock.unlock();
        }
        return n;
    }

    public static /* synthetic */ Integer selectInt$default(SqliteConnection sqliteConnection, String string2, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return sqliteConnection.selectInt(string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final <T> T executeLifecycle(byte[] sql2, Object values2, Function3<? super NativeDB, ? super Long, ? super Boolean, ? extends T> executor) {
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        boolean bl = false;
        NativeDB db = this_$iv.getDb();
        boolean bl2 = false;
        long statementPointer = db.prepare_utf8(sql2);
        SqliteConnectionKt.access$bind(statementPointer, values2, db);
        boolean isEmpty = SqliteConnectionKt.step(statementPointer, sql2, db);
        Object object = executor.invoke((Object)db, (Object)statementPointer, (Object)isEmpty);
        InlineMarker.finallyStart((int)1);
        db.finalize(statementPointer);
        InlineMarker.finallyEnd((int)1);
        Object object2 = object;
        InlineMarker.finallyStart((int)3);
        lock.unlock();
        InlineMarker.finallyEnd((int)3);
        return (T)object2;
        {
            catch (Throwable throwable) {
                try {
                    InlineMarker.finallyStart((int)1);
                    db.finalize(statementPointer);
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    InlineMarker.finallyStart((int)1);
                    lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static /* synthetic */ Object executeLifecycle$default(SqliteConnection $this, byte[] sql2, Object values2, Function3 executor, int n, Object object) {
        if ((n & 2) != 0) {
            values2 = null;
        }
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv = $this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        boolean bl = false;
        NativeDB db = this_$iv.getDb();
        boolean bl2 = false;
        long statementPointer = db.prepare_utf8(sql2);
        SqliteConnectionKt.access$bind(statementPointer, values2, db);
        boolean isEmpty = SqliteConnectionKt.step(statementPointer, sql2, db);
        Object object2 = executor.invoke((Object)db, (Object)statementPointer, (Object)isEmpty);
        InlineMarker.finallyStart((int)1);
        db.finalize(statementPointer);
        InlineMarker.finallyEnd((int)1);
        Object object3 = object2;
        InlineMarker.finallyStart((int)3);
        lock.unlock();
        InlineMarker.finallyEnd((int)3);
        return object3;
        {
            catch (Throwable throwable) {
                try {
                    InlineMarker.finallyStart((int)1);
                    db.finalize(statementPointer);
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    InlineMarker.finallyStart((int)1);
                    lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@Language(value="SQLite") @NotNull String sql2) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(StringsKt.encodeToByteArray((String)sql2));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void execute(@Language(value="SQLite") @NotNull String sql2, @NotNull Object values2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        SqliteConnection sqliteConnection = this;
        byte[] sql$iv = StringsKt.encodeToByteArray((String)sql2);
        boolean $i$f$executeLifecycle = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (((SqliteConnection)this_$iv$iv).dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = ((SqliteConnection)this_$iv$iv).lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            NativeDB db$iv = ((SqliteConnection)this_$iv$iv).getDb();
            boolean bl2 = false;
            long statementPointer$iv = db$iv.prepare_utf8(sql$iv);
            try {
                SqliteConnectionKt.access$bind(statementPointer$iv, values2, db$iv);
                boolean isEmpty$iv = SqliteConnectionKt.step(statementPointer$iv, sql$iv, db$iv);
                boolean bl3 = false;
                unit = Unit.INSTANCE;
                db$iv.finalize(statementPointer$iv);
            }
            catch (Throwable throwable) {
                db$iv.finalize(statementPointer$iv);
                throw throwable;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interruptAndClose() {
        NativeDB nativeDB = this.dbRef.getAndSet(null);
        if (nativeDB == null) {
            return;
        }
        NativeDB db = nativeDB;
        db.interrupt();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.doClose(db);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NativeDB nativeDB = this.dbRef.getAndSet(null);
        if (nativeDB == null) {
            return;
        }
        NativeDB db = nativeDB;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.doClose(db);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void doClose(NativeDB db) {
        List pool = CollectionsKt.toList((Iterable)this.statementPoolList);
        this.statementPoolList.clear();
        Throwable error = null;
        for (SqlStatementPool item2 : pool) {
            try {
                item2.close$intellij_platform_sqlite(db);
            }
            catch (Throwable e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                ExceptionsKt.addSuppressed((Throwable)error, (Throwable)e);
            }
        }
        try {
            db.close();
        }
        catch (Throwable e) {
            if (error == null) {
                error = e;
            }
            ExceptionsKt.addSuppressed((Throwable)error, (Throwable)e);
        }
        Iterator iterator = error;
        if (iterator != null) {
            Iterator it = iterator;
            boolean bl = false;
            throw it;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beginTransaction() {
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(SqliteConnectionKt.access$getBEGIN_TRANSACTION$p());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() {
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(SqliteConnectionKt.access$getCOMMIT$p());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback() {
        SqliteConnection this_$iv = this;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (this_$iv.dbRef.get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = this_$iv.lock;
        lock.lock();
        try {
            boolean bl = false;
            NativeDB it = this_$iv.getDb();
            boolean bl2 = false;
            it.exec(SqliteConnectionKt.access$getROLLBACK$p());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

