/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddMissingPropertyFix
implements LocalQuickFix,
BatchQuickFix {
    private final JsonValidationError.MissingMultiplePropsIssueData myData;
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public AddMissingPropertyFix(JsonValidationError.MissingMultiplePropsIssueData data2, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myData = data2;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string2 = JsonBundle.message("add.missing.properties", new Object[0]);
        if (string2 == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string2 = JsonBundle.message("add.missing.0", this.myData.getMessage(true));
        if (string2 == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        TextRange range;
        Editor editor;
        if (project2 == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        Ref hadComma = Ref.create((Object)false);
        VirtualFile file = element.getContainingFile().getVirtualFile();
        PsiElement newElement = this.performFix(element, (Ref<Boolean>)hadComma);
        if (newElement == null) {
            return;
        }
        PsiElement value2 = this.myQuickFixAdapter.getPropertyValue(newElement);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file);
        Editor editor2 = editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        assert (editor != null);
        if (value2 == null) {
            WriteAction.run(() -> editor.getCaretModel().moveToOffset(newElement.getTextRange().getEndOffset()));
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project2);
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(newElement);
        String text2 = value2.getText();
        boolean isEmptyArray = StringUtil.equalsIgnoreWhitespaces((CharSequence)text2, (CharSequence)"[]");
        boolean isEmptyObject = StringUtil.equalsIgnoreWhitespaces((CharSequence)text2, (CharSequence)"{}");
        boolean goInside = isEmptyArray || isEmptyObject || StringUtil.isQuotedString((String)text2);
        TextRange textRange = range = goInside ? TextRange.create((int)1, (int)(text2.length() - 1)) : TextRange.create((int)0, (int)text2.length());
        builder2.replaceElement(value2, range, (Expression)(this.myData.myMissingPropertyIssues.iterator().next().enumItemsCount > 1 || isEmptyObject ? new MacroCallNode((Macro)new CompleteMacro()) : (isEmptyArray ? new EmptyNode() : new ConstantNode(goInside ? StringUtil.unquoteString((String)text2) : text2))));
        editor.getCaretModel().moveToOffset(newElement.getTextRange().getStartOffset());
        if (PsiTreeUtil.nextLeaf((PsiElement)newElement) != null) {
            builder2.setEndVariableAfter(newElement);
        } else {
            builder2.setEndVariableBefore(newElement.getLastChild());
        }
        WriteAction.run(() -> {
            Template template = builder2.buildInlineTemplate();
            template.setToReformat(true);
            templateManager.startTemplate(editor, template);
        });
    }

    @Nullable
    public PsiElement performFix(@Nullable PsiElement node, @NotNull Ref<Boolean> hadComma) {
        if (hadComma == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(4);
        }
        if (node == null) {
            return null;
        }
        PsiElement element = node instanceof PsiFile ? node.getFirstChild() : node;
        Ref newElementRef = Ref.create(null);
        WriteAction.run(() -> this.performFixInner(hadComma, element, (Ref<PsiElement>)newElementRef));
        return (PsiElement)newElementRef.get();
    }

    public void performFixInner(@NotNull Ref<Boolean> hadComma, PsiElement element, Ref<PsiElement> newElementRef) {
        if (hadComma == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(5);
        }
        boolean isSingle = this.myData.myMissingPropertyIssues.size() == 1;
        PsiElement processedElement = element;
        List reverseOrder = ContainerUtil.reverse(new ArrayList<JsonValidationError.MissingPropertyIssueData>(this.myData.myMissingPropertyIssues));
        for (JsonValidationError.MissingPropertyIssueData issue : reverseOrder) {
            Object defaultValueObject = issue.defaultValue;
            String defaultValue = this.formatDefaultValue(defaultValueObject, element.getLanguage());
            PsiElement property2 = this.myQuickFixAdapter.createProperty(issue.propertyName, defaultValue == null ? this.myQuickFixAdapter.getDefaultValueFromType(issue.propertyType) : defaultValue, element);
            PsiElement newElement = processedElement instanceof LeafPsiElement ? this.myQuickFixAdapter.adjustPropertyAnchor((LeafPsiElement)processedElement).addBefore(property2, null) : (processedElement == element ? processedElement.addBefore(property2, processedElement.getLastChild()) : processedElement.getParent().addBefore(property2, processedElement));
            PsiElement adjusted = this.myQuickFixAdapter.adjustNewProperty(newElement);
            hadComma.set((Object)this.myQuickFixAdapter.ensureComma(adjusted, PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)newElement)));
            if (!((Boolean)hadComma.get()).booleanValue()) {
                hadComma.set((Object)(processedElement == element && this.myQuickFixAdapter.ensureComma(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)newElement), adjusted) ? 1 : 0));
            }
            processedElement = adjusted;
            if (!isSingle) continue;
            newElementRef.set((Object)adjusted);
        }
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public String formatDefaultValue(@Nullable Object defaultValueObject, @NotNull Language targetLanguage) {
        if (targetLanguage == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(6);
        }
        if (defaultValueObject instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)defaultValueObject;
            return AddMissingPropertyFix.convertToYamlIfNeeded(targetLanguage, jsonNode);
        }
        if (defaultValueObject instanceof String) {
            return StringUtil.wrapWithDoubleQuote((String)defaultValueObject.toString());
        }
        if (defaultValueObject instanceof Boolean) {
            return Boolean.toString((Boolean)defaultValueObject);
        }
        if (defaultValueObject instanceof Number) {
            return defaultValueObject.toString();
        }
        if (defaultValueObject instanceof PsiElement) {
            return ((PsiElement)defaultValueObject).getText();
        }
        return null;
    }

    @Nullable
    private static String convertToYamlIfNeeded(@NotNull Language language, JsonNode jsonNode) {
        if (language == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(7);
        }
        Object jacksonFactory = language.is((Language)JsonLanguage.INSTANCE) ? new JsonFactory() : new YAMLFactory();
        try {
            String exampleInTargetLanguage = new ObjectMapper(jacksonFactory).writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            if (exampleInTargetLanguage.startsWith("---")) {
                return exampleInTargetLanguage.substring("---".length()).trim();
            }
            return exampleInTargetLanguage;
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project2 == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(8);
        }
        if (psiElementsToIgnore == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(9);
        }
        if (descriptors == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(10);
        }
        ArrayList<Pair> propFixes = new ArrayList<Pair>();
        for (CommonProblemDescriptor descriptor : descriptors) {
            AddMissingPropertyFix fix;
            QuickFix[] fixes;
            if (!(descriptor instanceof ProblemDescriptor) || (fixes = descriptor.getFixes()) == null || (fix = AddMissingPropertyFix.getWorkingQuickFix(fixes)) == null) continue;
            propFixes.add(Pair.create((Object)fix, (Object)((ProblemDescriptor)descriptor).getPsiElement()));
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> propFixes.forEach(fix -> ((AddMissingPropertyFix)fix.first).performFix((PsiElement)fix.second, (Ref<Boolean>)Ref.create((Object)false))));
    }

    @Nullable
    private static AddMissingPropertyFix getWorkingQuickFix(QuickFix @NotNull [] fixes) {
        if (fixes == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(11);
        }
        for (QuickFix fix : fixes) {
            if (!(fix instanceof AddMissingPropertyFix)) continue;
            return (AddMissingPropertyFix)fix;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hadComma";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLanguage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performFixInner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatDefaultValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToYamlIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingQuickFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string2);
        };
    }
}

