/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.history.CommitMetadataWithPath;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020 J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H$J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110/H\u0002J\b\u00100\u001a\u00020)H\u0002J\u0018\u00101\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110/\u0012\u0004\u0012\u00020 02R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00063"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryTask;", "", "project", "Lcom/intellij/openapi/project/Project;", "handler", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "_revisions", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/vcs/log/history/CommitMetadataWithPath;", "exception", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/vcs/VcsException;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "future", "Ljava/util/concurrent/Future;", "getHandler", "()Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "isCancelled", "", "()Z", "lastSize", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cancel", "", "wait", "createCommitMetadataWithPath", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "getRevisionsSnapshot", "", "throwOnError", "waitForRevisions", "Lkotlin/Pair;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryTask\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,457:1\n19#2,4:458\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryTask\n*L\n403#1:458,4\n*E\n"})
abstract class FileHistoryTask {
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogFileHistoryHandler handler;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final FilePath filePath;
    @Nullable
    private final Hash hash;
    @NotNull
    private final ProgressIndicator indicator;
    @NotNull
    private final Future<?> future;
    @NotNull
    private final ConcurrentLinkedQueue<CommitMetadataWithPath> _revisions;
    @NotNull
    private final AtomicReference<VcsException> exception;
    private volatile int lastSize;

    public FileHistoryTask(@NotNull Project project2, @NotNull VcsLogFileHistoryHandler handler2, @NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable Hash hash2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.project = project2;
        this.handler = handler2;
        this.root = root;
        this.filePath = filePath;
        this.hash = hash2;
        this.indicator = indicator;
        this._revisions = new ConcurrentLinkedQueue();
        this.exception = new AtomicReference();
        Future<?> future2 = AppExecutorUtil.getAppExecutorService().submit(() -> FileHistoryTask._init_$lambda$3(this));
        Intrinsics.checkNotNullExpressionValue(future2, (String)"submit(...)");
        this.future = future2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VcsLogFileHistoryHandler getHandler() {
        return this.handler;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @Nullable
    public final Hash getHash() {
        return this.hash;
    }

    @NotNull
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public final boolean isCancelled() {
        return this.indicator.isCanceled();
    }

    @NotNull
    protected abstract CommitMetadataWithPath createCommitMetadataWithPath(@NotNull VcsFileRevision var1);

    @NotNull
    public final Pair<List<CommitMetadataWithPath>, Boolean> waitForRevisions() throws VcsException {
        this.throwOnError();
        while (this._revisions.size() == this.lastSize) {
            try {
                this.future.get(100L, TimeUnit.MILLISECONDS);
                ProgressManager.checkCanceled();
                this.throwOnError();
                return new Pair(this.getRevisionsSnapshot(), (Object)true);
            }
            catch (TimeoutException timeoutException) {
            }
        }
        return new Pair(this.getRevisionsSnapshot(), (Object)false);
    }

    private final List<CommitMetadataWithPath> getRevisionsSnapshot() {
        List list2 = CollectionsKt.toList((Iterable)this._revisions);
        this.lastSize = list2.size();
        return list2;
    }

    private final void throwOnError() throws VcsException {
        if (this.exception.get() != null) {
            throw new VcsException(this.exception.get());
        }
    }

    public final void cancel(boolean wait) {
        this.indicator.cancel();
        if (wait) {
            try {
                this.future.get(20L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final void lambda$3$lambda$2$lambda$1(Function1 $tmp0, VcsFileRevision p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0);
    }

    private static final void lambda$3$lambda$2(FileHistoryTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Function1 consumer2 = (Function1)new Function1<VcsFileRevision, Unit>(this$0){
                final /* synthetic */ FileHistoryTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VcsFileRevision revision) {
                    Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
                    FileHistoryTask.access$get_revisions$p(this.this$0).add(this.this$0.createCommitMetadataWithPath(revision));
                }
            };
            try {
                this$0.handler.collectHistory(this$0.root, this$0.filePath, this$0.hash, (Function1<? super VcsFileRevision, Unit>)consumer2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                AbstractVcs vcs;
                AbstractVcs abstractVcs;
                TextRevisionNumber revisionNumber = this$0.hash != null ? VcsLogUtil.convertToRevisionNumber(this$0.hash) : null;
                AbstractVcs abstractVcs2 = ProjectLevelVcsManager.getInstance(this$0.project).getVcsFor(this$0.root);
                if (abstractVcs2 != null) {
                    AbstractVcs $this$alsoIfNull$iv = abstractVcs2;
                    boolean $i$f$alsoIfNull = false;
                    abstractVcs = $this$alsoIfNull$iv;
                } else {
                    abstractVcs = null;
                }
                AbstractVcs abstractVcs3 = vcs = abstractVcs;
                Intrinsics.checkNotNull((Object)abstractVcs3);
                VcsCachingHistory.collect(abstractVcs3, this$0.filePath, revisionNumber, arg_0 -> FileHistoryTask.lambda$3$lambda$2$lambda$1(consumer2, arg_0));
            }
        }
        catch (VcsException e) {
            this$0.exception.set(e);
        }
    }

    private static final void _init_$lambda$3(FileHistoryTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ProgressManager.getInstance().runProcess(() -> FileHistoryTask.lambda$3$lambda$2(this$0), this$0.indicator);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$get_revisions$p(FileHistoryTask $this) {
        return $this._revisions;
    }
}

