/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.LocalChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/openapi/vcs/changes/ui/LocalChangesBrowser;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/LocalChangesBrowser;)V", "changeInfoCalculator", "Lcom/intellij/openapi/vcs/changes/ui/ChangeInfoCalculator;", "commitLegend", "Lcom/intellij/openapi/vcs/changes/ui/CommitLegendPanel;", "deleteLocallyAddedFilesCheckBox", "Ljavax/swing/JCheckBox;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "getDimensionServiceKey", "getPreferredFocusedComponent", "inclusionListener", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nRollbackChangesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollbackChangesDialog.kt\ncom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1747#2,3:157\n*S KotlinDebug\n*F\n+ 1 RollbackChangesDialog.kt\ncom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog\n*L\n80#1:157,3\n*E\n"})
public final class RollbackChangesDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LocalChangesBrowser browser;
    @NotNull
    private final ChangeInfoCalculator changeInfoCalculator;
    @NotNull
    private final CommitLegendPanel commitLegend;
    private JCheckBox deleteLocallyAddedFilesCheckBox;
    @NotNull
    private final String operationName;
    @NotNull
    private static final String DELETE_LOCALLY_ADDED_FILES_KEY = "delete.locally.added.files";

    private RollbackChangesDialog(Project project2, LocalChangesBrowser browser) {
        super(project2, true);
        this.project = project2;
        this.browser = browser;
        this.changeInfoCalculator = new ChangeInfoCalculator();
        this.commitLegend = new CommitLegendPanel(this.changeInfoCalculator);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.browser);
        this.browser.setInclusionChangedListener(() -> RollbackChangesDialog._init_$lambda$0(this));
        this.browser.getViewer().addPropertyChangeListener("model", arg_0 -> RollbackChangesDialog._init_$lambda$1(this, arg_0));
        String string2 = RollbackUtil.getRollbackOperationName(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRollbackOperationName(...)");
        String operationNameWithMnemonic = string2;
        this.setOKButtonText(operationNameWithMnemonic);
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        String string3 = UIUtil.removeMnemonic((String)operationNameWithMnemonic);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"removeMnemonic(...)");
        this.operationName = string3;
        Object[] objectArray = new Object[]{StringUtil.toLowerCase((String)this.operationName)};
        this.browser.setToggleActionTitle(VcsBundle.message("changes.action.include.in.operation.name", objectArray));
        objectArray = new Object[]{this.operationName};
        this.setTitle(VcsBundle.message("changes.action.rollback.custom.title", objectArray));
        this.init();
        this.inclusionListener();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel it = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ RollbackChangesDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RollbackChangesDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)RollbackChangesDialog.access$getBrowser$p(this.this$0)).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RollbackChangesDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)RollbackChangesDialog.access$getCommitLegend$p(this.this$0).getComponent());
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RollbackChangesDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string2 = VcsBundle.message("changes.checkbox.delete.locally.added.files", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        RollbackChangesDialog.access$setDeleteLocallyAddedFilesCheckBox$p(this.this$0, (JCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(string2), (Function0)createCenterPanel.1.INSTANCE, (Function1)createCenterPanel.2.INSTANCE).getComponent());
                    }
                }), (int)1, null);
            }
        }));
        boolean bl = false;
        it.setMinimumSize((Dimension)JBUI.size((int)200, (int)150));
        return (JComponent)dialogPanel;
    }

    private final void inclusionListener() {
        JCheckBox jCheckBox;
        boolean hasNewFiles;
        List<Change> includedChanges;
        block4: {
            List<Change> allChanges = this.browser.getAllChanges();
            includedChanges = this.browser.getIncludedChanges();
            Intrinsics.checkNotNull(allChanges);
            Intrinsics.checkNotNull(includedChanges);
            ChangeInfoCalculator.update$default(this.changeInfoCalculator, allChanges, CollectionsKt.toList((Iterable)includedChanges), 0, 0, 12, null);
            this.commitLegend.update();
            Iterable $this$any$iv = includedChanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Change change = (Change)element$iv;
                    boolean bl = false;
                    if (!(change.getType() == Change.Type.NEW)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = hasNewFiles = false;
            }
        }
        if ((jCheckBox = this.deleteLocallyAddedFilesCheckBox) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deleteLocallyAddedFilesCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setEnabled(hasNewFiles);
        this.getOKAction().setEnabled(!((Collection)includedChanges).isEmpty());
    }

    protected void doOKAction() {
        super.doOKAction();
        RollbackWorker rollbackWorker = new RollbackWorker(this.project, this.operationName, LaterInvocator.isInModalContext());
        Collection collection = this.browser.getIncludedChanges();
        JCheckBox jCheckBox = this.deleteLocallyAddedFilesCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deleteLocallyAddedFilesCheckBox");
            jCheckBox = null;
        }
        rollbackWorker.doRollback(collection, jCheckBox.isSelected());
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.browser.getPreferredFocusedComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getPreferredFocusedComponent(...)");
        return jComponent;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "RollbackChangesDialog";
    }

    private static final void _init_$lambda$0(RollbackChangesDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.inclusionListener();
    }

    private static final void _init_$lambda$1(RollbackChangesDialog this$0, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.inclusionListener();
    }

    @JvmStatic
    public static final void rollbackChanges(@NotNull Project project2, @NotNull Collection<? extends Change> changes) {
        Companion.rollbackChanges(project2, changes);
    }

    @JvmStatic
    public static final void rollbackChanges(@NotNull Project project2) {
        Companion.rollbackChanges(project2);
    }

    @JvmStatic
    public static final void rollbackChanges(@NotNull Project project2, @NotNull LocalChangeList changeList) {
        Companion.rollbackChanges(project2, changeList);
    }

    @JvmStatic
    @NotNull
    public static final String operationNameByChanges(@NotNull Project project2, @NotNull Collection<? extends Change> changes) {
        return Companion.operationNameByChanges(project2, changes);
    }

    public static final /* synthetic */ LocalChangesBrowser access$getBrowser$p(RollbackChangesDialog $this) {
        return $this.browser;
    }

    public static final /* synthetic */ CommitLegendPanel access$getCommitLegend$p(RollbackChangesDialog $this) {
        return $this.commitLegend;
    }

    public static final /* synthetic */ void access$setDeleteLocallyAddedFilesCheckBox$p(RollbackChangesDialog $this, JCheckBox jCheckBox) {
        $this.deleteLocallyAddedFilesCheckBox = jCheckBox;
    }

    public /* synthetic */ RollbackChangesDialog(Project project2, LocalChangesBrowser browser, DefaultConstructorMarker $constructor_marker) {
        this(project2, browser);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0005\u001a\u00130\u0004\u00a2\u0006\u000e\b\u0006\u0012\n\b\u0007\u0012\u0006\b\n0\b8\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/RollbackChangesDialog$Companion;", "", "()V", "DELETE_LOCALLY_ADDED_FILES_KEY", "", "operationNameByChanges", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "rollbackChanges", "", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "showRollbackDialog", "browser", "Lcom/intellij/openapi/vcs/changes/ui/LocalChangesBrowser;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void rollbackChanges(@NotNull Project project2, @NotNull Collection<? extends Change> changes) {
            LocalChangesBrowser localChangesBrowser;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManagerEx, (String)"getInstanceEx(...)");
            ChangeListManagerEx changeListManager = changeListManagerEx;
            if (changeListManager.areChangeListsEnabled()) {
                Collection<LocalChangeList> collection = changeListManager.getAffectedLists(changes);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getAffectedLists(...)");
                Collection<LocalChangeList> lists = collection;
                localChangesBrowser = !lists.isEmpty() ? (LocalChangesBrowser)new LocalChangesBrowser.SelectedChangeLists(project2, lists) : (LocalChangesBrowser)new LocalChangesBrowser.NonEmptyChangeLists(project2);
            } else {
                localChangesBrowser = new LocalChangesBrowser.AllChanges(project2);
            }
            LocalChangesBrowser browser = localChangesBrowser;
            browser.getViewer().invokeAfterRefresh(() -> Companion.rollbackChanges$lambda$0(browser, changes));
            this.showRollbackDialog(project2, browser);
        }

        @JvmStatic
        public final void rollbackChanges(@NotNull Project project2) {
            LocalChangesBrowser localChangesBrowser;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            if (changeListManager2.areChangeListsEnabled()) {
                LocalChangeList localChangeList = changeListManager2.getDefaultChangeList();
                Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
                LocalChangeList defaultChangeList = localChangeList;
                Collection<Change> collection = defaultChangeList.getChanges();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getChanges(...)");
                localChangesBrowser = !collection.isEmpty() ? (LocalChangesBrowser)new LocalChangesBrowser.SelectedChangeLists(project2, CollectionsKt.listOf((Object)defaultChangeList)) : (LocalChangesBrowser)new LocalChangesBrowser.NonEmptyChangeLists(project2);
            } else {
                localChangesBrowser = new LocalChangesBrowser.AllChanges(project2);
            }
            LocalChangesBrowser browser = localChangesBrowser;
            this.showRollbackDialog(project2, browser);
        }

        @JvmStatic
        public final void rollbackChanges(@NotNull Project project2, @NotNull LocalChangeList changeList) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
            List lists = CollectionsKt.listOf((Object)changeList);
            LocalChangesBrowser.SelectedChangeLists browser = new LocalChangesBrowser.SelectedChangeLists(project2, lists);
            this.showRollbackDialog(project2, browser);
        }

        private final void showRollbackDialog(Project project2, LocalChangesBrowser browser) {
            new RollbackChangesDialog(project2, browser, null).show();
        }

        @JvmStatic
        @NotNull
        public final String operationNameByChanges(@NotNull Project project2, @NotNull Collection<? extends Change> changes) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            String string2 = RollbackUtil.getRollbackOperationName((Collection<? extends AbstractVcs>)ChangesUtil.getAffectedVcses(changes, project2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRollbackOperationName(...)");
            return string2;
        }

        private static final void rollbackChanges$lambda$0(LocalChangesBrowser $browser, Collection $changes) {
            Intrinsics.checkNotNullParameter((Object)$browser, (String)"$browser");
            Intrinsics.checkNotNullParameter((Object)$changes, (String)"$changes");
            $browser.setIncludedChangesBy($changes);
            $browser.getViewer().resetTreeState();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

