/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.patch.PatchNameChecker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.dsl.builder.TopGap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u000bJ\u0006\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0019J\n\u0010%\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010&\u001a\u00020#2\b\u0010'\u001a\u0004\u0018\u00010\bJ\u000e\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u001fJ\u000e\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u001fJ\u000e\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u001fJ\n\u00101\u001a\u0004\u0018\u000102H\u0002J\b\u00103\u001a\u0004\u0018\u000102J\n\u00104\u001a\u0004\u0018\u000102H\u0002J\b\u00105\u001a\u00020#H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "basePathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "commonParentDir", "Ljava/io/File;", "encodingComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Ljava/nio/charset/Charset;", "fileNameField", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "reverseCheckBox", "Ljavax/swing/JCheckBox;", "toClipboardRadioButton", "Ljavax/swing/JRadioButton;", "warningLabel", "Ljavax/swing/JLabel;", "createPanel", "getBaseDirName", "", "getEncoding", "getFileName", "getPanel", "Ljavax/swing/JComponent;", "isOkToExecute", "", "isReversePatch", "isToClipboard", "selectBasePath", "", "baseDir", "selectFileName", "setCommonParentPath", "commonParentPath", "setFileName", "file", "Ljava/nio/file/Path;", "setReverseEnabledAndVisible", "isAvailable", "setReversePatch", "reverse", "setToClipboard", "toClipboard", "validateBaseDirPath", "Lcom/intellij/openapi/ui/ValidationInfo;", "validateFields", "validateFileName", "warnIfFileExists", "intellij.platform.vcs.impl"})
public final class CreatePatchConfigurationPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final DialogPanel panel;
    @NotNull
    private final TextFieldWithBrowseButton fileNameField;
    @NotNull
    private final TextFieldWithBrowseButton basePathField;
    private JRadioButton toClipboardRadioButton;
    private JCheckBox reverseCheckBox;
    private ComboBox<Charset> encodingComboBox;
    private JLabel warningLabel;
    @Nullable
    private File commonParentDir;

    public CreatePatchConfigurationPanel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.fileNameField = new TextFieldWithBrowseButton();
        this.basePathField = new TextFieldWithBrowseButton();
        this.fileNameField.addActionListener(arg_0 -> CreatePatchConfigurationPanel._init_$lambda$0(this, arg_0));
        this.basePathField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
        this.basePathField.setText(((Object)ProjectKt.getStateStore((Project)this.project).getProjectBasePath()).toString());
        this.panel = this.createPanel();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final String selectFileName() {
        String string2;
        Path baseDir2;
        FileSaverDescriptor descriptor = new FileSaverDescriptor(VcsBundle.message("patch.creation.save.to.title", new Object[0]), "", new String[0]);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)this.fileNameField);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog dialog = fileSaverDialog;
        String string3 = FileUtil.toSystemIndependentName((String)this.getFileName());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
        String path2 = string3;
        int index = StringsKt.lastIndexOf$default((CharSequence)path2, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            v2 = ProjectKt.getStateStore((Project)this.project).getProjectBasePath();
        } else {
            String string4 = path2.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            v2 = baseDir2 = Paths.get(string4, new String[0]);
        }
        if (index == -1) {
            string2 = path2;
        } else {
            String string5 = path2.substring(index + 1);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        }
        String name = string2;
        VirtualFileWrapper virtualFileWrapper = dialog.save(baseDir2, name);
        if (virtualFileWrapper == null) {
            return null;
        }
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        return fileWrapper.getFile().getPath();
    }

    private final DialogPanel createPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ CreatePatchConfigurationPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ CreatePatchConfigurationPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$buttonsGroup) {
                        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ CreatePatchConfigurationPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string2 = VcsBundle.message("create.patch.file.path", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                Cell toFileButton = Row.radioButton$default((Row)$this$row, (String)string2, null, (int)2, null);
                                ((JBRadioButton)toFileButton.getComponent()).setSelected(true);
                                TextFieldWithBrowseButtonKt.columns((Cell)$this$row.cell((JComponent)CreatePatchConfigurationPanel.access$getFileNameField$p(this.this$0)), (int)36).align((Align)AlignX.FILL.INSTANCE).enabledIf(ButtonKt.getSelected((Cell)toFileButton));
                            }
                        }), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ CreatePatchConfigurationPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string2 = VcsBundle.message("create.patch.to.clipboard", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                CreatePatchConfigurationPanel.access$setToClipboardRadioButton$p(this.this$0, (JRadioButton)Row.radioButton$default((Row)$this$row, (String)string2, null, (int)2, null).getComponent());
                            }
                        }), (int)1, null);
                    }
                }), (int)3, null);
                String string2 = VcsBundle.message("patch.creation.base.path.field", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ CreatePatchConfigurationPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextFieldWithBrowseButtonKt.columns((Cell)$this$row.cell((JComponent)CreatePatchConfigurationPanel.access$getBasePathField$p(this.this$0)), (int)36).align((Align)AlignX.FILL.INSTANCE);
                    }
                }).topGap(TopGap.SMALL);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ CreatePatchConfigurationPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string2 = VcsBundle.message("create.patch.reverse.checkbox", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        CreatePatchConfigurationPanel.access$setReverseCheckBox$p(this.this$0, (JCheckBox)$this$row.checkBox(string2).getComponent());
                    }
                }), (int)1, null);
                String string3 = VcsBundle.message("create.patch.encoding", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                $this$panel.row(string3, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ CreatePatchConfigurationPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        CreatePatchConfigurationPanel.access$setEncodingComboBox$p(this.this$0, (ComboBox)Row.comboBox$default((Row)$this$row, (ComboBoxModel)new DefaultComboBoxModel<Charset>(CharsetToolkit.getAvailableCharsets()), null, (int)2, null).getComponent());
                        ComboBox comboBox = CreatePatchConfigurationPanel.access$getEncodingComboBox$p(this.this$0);
                        if (comboBox == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"encodingComboBox");
                            comboBox = null;
                        }
                        comboBox.setSelectedItem((Object)EncodingProjectManager.getInstance((Project)this.this$0.getProject()).getDefaultCharset());
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ CreatePatchConfigurationPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        CreatePatchConfigurationPanel.access$setWarningLabel$p(this.this$0, (JLabel)$this$row.label("").applyToComponent((Function1)createPanel.1.INSTANCE).getComponent());
                    }
                }), (int)1, null);
            }
        }));
    }

    public final void selectBasePath(@NotNull String baseDir2) {
        Intrinsics.checkNotNullParameter((Object)baseDir2, (String)"baseDir");
        this.basePathField.setText(baseDir2);
    }

    @NotNull
    public final Charset getEncoding() {
        ComboBox<Charset> comboBox = this.encodingComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"encodingComboBox");
            comboBox = null;
        }
        Object object = comboBox.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (Charset)object;
    }

    public final void setCommonParentPath(@Nullable File commonParentPath) {
        this.commonParentDir = commonParentPath != null && !commonParentPath.isDirectory() ? commonParentPath.getParentFile() : commonParentPath;
    }

    @NotNull
    public final JComponent getPanel() {
        return (JComponent)this.panel;
    }

    @NotNull
    public final String getFileName() {
        String string2 = this.fileNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = FileUtil.expandUserHome((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"expandUserHome(...)");
        return string3;
    }

    @NotNull
    public final String getBaseDirName() {
        String string2 = this.basePathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = FileUtil.expandUserHome((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"expandUserHome(...)");
        return string3;
    }

    public final void setFileName(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileNameField.setText(((Object)file).toString());
    }

    public final boolean isReversePatch() {
        JCheckBox jCheckBox = this.reverseCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox = null;
        }
        return jCheckBox.isSelected();
    }

    public final void setReversePatch(boolean reverse) {
        JCheckBox jCheckBox = this.reverseCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setSelected(reverse);
    }

    public final void setReverseEnabledAndVisible(boolean isAvailable) {
        JCheckBox jCheckBox = this.reverseCheckBox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox = null;
        }
        jCheckBox.setVisible(isAvailable);
        JCheckBox jCheckBox2 = this.reverseCheckBox;
        if (jCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reverseCheckBox");
            jCheckBox2 = null;
        }
        jCheckBox2.setEnabled(isAvailable);
    }

    public final boolean isToClipboard() {
        JRadioButton jRadioButton = this.toClipboardRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toClipboardRadioButton");
            jRadioButton = null;
        }
        return jRadioButton.isSelected();
    }

    public final void setToClipboard(boolean toClipboard) {
        JRadioButton jRadioButton = this.toClipboardRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toClipboardRadioButton");
            jRadioButton = null;
        }
        jRadioButton.setSelected(toClipboard);
    }

    public final boolean isOkToExecute() {
        return this.validateFields() == null;
    }

    @Nullable
    public final ValidationInfo validateFields() {
        this.warnIfFileExists();
        ValidationInfo validationInfo = this.validateFileName();
        if (validationInfo == null) {
            validationInfo = this.validateBaseDirPath();
        }
        return validationInfo;
    }

    private final void warnIfFileExists() {
        JLabel jLabel;
        String string2;
        String fileName = this.getFileName();
        JLabel jLabel2 = this.warningLabel;
        if (jLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"warningLabel");
            jLabel2 = null;
        }
        if (new File(fileName).exists()) {
            Object[] objectArray = new Object[]{fileName};
            string2 = IdeBundle.message((String)"error.file.with.name.already.exists", (Object[])objectArray);
        } else {
            string2 = "";
        }
        jLabel2.setText(string2);
        JLabel jLabel3 = this.warningLabel;
        if (jLabel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"warningLabel");
            jLabel3 = null;
        }
        if ((jLabel = this.warningLabel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"warningLabel");
            jLabel = null;
        }
        String string3 = jLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        jLabel3.setVisible(!StringsKt.isBlank((CharSequence)string3));
    }

    private final ValidationInfo validateFileName() {
        String validateNameError = PatchNameChecker.validateName(this.getFileName());
        if (validateNameError != null) {
            return new ValidationInfo(validateNameError, (JComponent)this.fileNameField);
        }
        return null;
    }

    private final ValidationInfo validateBaseDirPath() {
        String baseDirName = this.getBaseDirName();
        if (StringsKt.isBlank((CharSequence)baseDirName)) {
            return new ValidationInfo(VcsBundle.message("patch.creation.empty.base.path.error", new Object[0]), (JComponent)this.basePathField);
        }
        File baseFile = new File(baseDirName);
        if (!baseFile.exists()) {
            return new ValidationInfo(VcsBundle.message("patch.creation.base.dir.does.not.exist.error", new Object[0]), (JComponent)this.basePathField);
        }
        File file = this.commonParentDir;
        if (file == null) {
            return null;
        }
        File commonParent = file;
        if (!FileUtil.isAncestor((File)baseFile, (File)commonParent, (boolean)false)) {
            Object[] objectArray = new Object[]{commonParent.getPath()};
            return new ValidationInfo(VcsBundle.message("patch.creation.wrong.base.path.for.changes.error", objectArray), (JComponent)this.basePathField);
        }
        return null;
    }

    private static final void _init_$lambda$0(CreatePatchConfigurationPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String fileName = this$0.selectFileName();
        if (fileName != null) {
            this$0.fileNameField.setText(fileName);
        }
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getFileNameField$p(CreatePatchConfigurationPanel $this) {
        return $this.fileNameField;
    }

    public static final /* synthetic */ void access$setToClipboardRadioButton$p(CreatePatchConfigurationPanel $this, JRadioButton jRadioButton) {
        $this.toClipboardRadioButton = jRadioButton;
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getBasePathField$p(CreatePatchConfigurationPanel $this) {
        return $this.basePathField;
    }

    public static final /* synthetic */ void access$setReverseCheckBox$p(CreatePatchConfigurationPanel $this, JCheckBox jCheckBox) {
        $this.reverseCheckBox = jCheckBox;
    }

    public static final /* synthetic */ void access$setEncodingComboBox$p(CreatePatchConfigurationPanel $this, ComboBox comboBox) {
        $this.encodingComboBox = comboBox;
    }

    public static final /* synthetic */ ComboBox access$getEncodingComboBox$p(CreatePatchConfigurationPanel $this) {
        return $this.encodingComboBox;
    }

    public static final /* synthetic */ void access$setWarningLabel$p(CreatePatchConfigurationPanel $this, JLabel jLabel) {
        $this.warningLabel = jLabel;
    }
}

