/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class BlobIndexUtil {
    public static final String NOT_COMMITTED_HASH = StringUtil.repeat((String)"0", (int)40);

    @NotNull
    public static String getSha1(@NotNull File file) throws IOException {
        if (file == null) {
            BlobIndexUtil.$$$reportNull$$$0(0);
        }
        return BlobIndexUtil.getSha1(Files.toByteArray((File)file));
    }

    @NotNull
    public static String getSha1(byte @NotNull [] bytes) {
        if (bytes == null) {
            BlobIndexUtil.$$$reportNull$$$0(1);
        }
        String prefix = "blob " + bytes.length + "\u0000";
        String string2 = Hashing.sha1().newHasher().putBytes(prefix.getBytes(Charsets.UTF_8)).putBytes(bytes).hash().toString();
        if (string2 == null) {
            BlobIndexUtil.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    public static Couple<String> getBeforeAfterSha1(@NotNull Change change) throws VcsException {
        if (change == null) {
            BlobIndexUtil.$$$reportNull$$$0(3);
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        String before2 = beforeRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(beforeRevision));
        String after = afterRevision == null ? NOT_COMMITTED_HASH : BlobIndexUtil.getSha1(BlobIndexUtil.getContentBytes(afterRevision));
        return new Couple((Object)before2, (Object)after);
    }

    private static byte @NotNull [] getContentBytes(@NotNull ContentRevision revision) throws VcsException {
        if (revision == null) {
            BlobIndexUtil.$$$reportNull$$$0(4);
        }
        byte[] byArray = ChangesUtil.loadContentRevision(revision);
        if (byArray == null) {
            BlobIndexUtil.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/BlobIndexUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSha1";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSha1";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeAfterSha1";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContentBytes";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5 -> new IllegalStateException(string2);
        };
    }
}

