/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsShelveUtils {
    private static final Logger LOG = Logger.getInstance((String)VcsShelveUtils.class.getName());

    @NotNull
    public static ApplyPatchStatus doSystemUnshelve(Project project2, ShelvedChangeList shelvedChangeList, @Nullable LocalChangeList targetChangeList, ShelveChangesManager shelveManager, @NlsContexts.Label @Nullable String leftConflictTitle, @NlsContexts.Label @Nullable String rightConflictTitle) {
        VirtualFile baseDir2 = project2.getBaseDir();
        assert (baseDir2 != null);
        String projectPath = baseDir2.getPath() + "/";
        shelvedChangeList.loadChangesIfNeeded(project2);
        List<ShelvedChange> changes = Objects.requireNonNull(shelvedChangeList.getChanges());
        List<ShelvedBinaryFile> binaryFiles = shelvedChangeList.getBinaryFiles();
        LOG.info("refreshing files ");
        VcsShelveUtils.refreshFilesBeforeUnshelve(projectPath, changes, binaryFiles);
        LOG.info("Unshelving shelvedChangeList: " + shelvedChangeList);
        ApplyPatchStatus status = shelveManager.unshelveChangeList(shelvedChangeList, changes, binaryFiles, targetChangeList, false, true, true, leftConflictTitle, rightConflictTitle, true);
        ApplicationManager.getApplication().invokeAndWait(() -> VcsShelveUtils.markUnshelvedFilesNonUndoable(project2, changes));
        ApplyPatchStatus applyPatchStatus = status;
        if (applyPatchStatus == null) {
            VcsShelveUtils.$$$reportNull$$$0(0);
        }
        return applyPatchStatus;
    }

    @RequiresEdt
    private static void markUnshelvedFilesNonUndoable(@NotNull Project project2, @NotNull List<ShelvedChange> changes) {
        if (project2 == null) {
            VcsShelveUtils.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            VcsShelveUtils.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)project2);
        if (undoManager != null && !changes.isEmpty()) {
            ContainerUtil.process(changes, change -> {
                VirtualFile vfUnderProject = VfsUtil.findFileByIoFile((File)new File(project2.getBasePath(), change.getAfterPath()), (boolean)false);
                if (vfUnderProject != null) {
                    DocumentReference documentReference = DocumentReferenceManager.getInstance().create(vfUnderProject);
                    undoManager.nonundoableActionPerformed(documentReference, false);
                    undoManager.invalidateActionsFor(documentReference);
                }
                return true;
            });
        }
    }

    private static void refreshFilesBeforeUnshelve(String projectPath, @NotNull List<ShelvedChange> shelvedChanges, @NotNull List<ShelvedBinaryFile> binaryFiles) {
        if (shelvedChanges == null) {
            VcsShelveUtils.$$$reportNull$$$0(3);
        }
        if (binaryFiles == null) {
            VcsShelveUtils.$$$reportNull$$$0(4);
        }
        HashSet filesToRefresh = new HashSet();
        shelvedChanges.forEach(c -> {
            filesToRefresh.add(new File(projectPath + c.getBeforePath()));
            filesToRefresh.add(new File(projectPath + c.getAfterPath()));
        });
        binaryFiles.forEach(f -> {
            if (f.BEFORE_PATH != null) {
                filesToRefresh.add(new File(projectPath + f.BEFORE_PATH));
            }
            if (f.AFTER_PATH != null) {
                filesToRefresh.add(new File(projectPath + f.AFTER_PATH));
            }
        });
        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
    }

    @Nullable
    public static ShelvedChangeList shelveChanges(Project project2, Collection<? extends Change> changes, @Nls String description2, boolean rollback, boolean markToBeDeleted) throws VcsException {
        try {
            return ShelveChangesManager.getInstance(project2).shelveChanges(changes, description2, rollback, markToBeDeleted);
        }
        catch (IOException e) {
            throw new VcsException(VcsBundle.message("changes.error.shelving.changes.failed", description2), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsShelveUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doSystemUnshelve";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsShelveUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markUnshelvedFilesNonUndoable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshFilesBeforeUnshelve";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }
}

