/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class SwitchAnnotationSourceAction
extends AnAction
implements DumbAware {
    private final AnnotationSourceSwitcher mySwitcher;
    private final List<Consumer<AnnotationSource>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myShowMerged;

    SwitchAnnotationSourceAction(AnnotationSourceSwitcher switcher) {
        this.mySwitcher = switcher;
        this.myShowMerged = this.mySwitcher.getDefaultSource().showMerged();
    }

    public void addSourceSwitchListener(Consumer<AnnotationSource> listener2) {
        this.myListeners.add(listener2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            SwitchAnnotationSourceAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SwitchAnnotationSourceAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setText(this.myShowMerged ? SwitchAnnotationSourceAction.getHideMerged() : SwitchAnnotationSourceAction.getShowMerged());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SwitchAnnotationSourceAction.$$$reportNull$$$0(2);
        }
        this.myShowMerged = !this.myShowMerged;
        AnnotationSource newSource = AnnotationSource.getInstance(this.myShowMerged);
        this.mySwitcher.switchTo(newSource);
        for (Consumer<AnnotationSource> listener2 : this.myListeners) {
            listener2.accept(newSource);
        }
        AnnotateActionGroup.revalidateMarkupInAllEditors();
    }

    @NlsActions.ActionText
    private static String getShowMerged() {
        return VcsBundle.message("annotation.switch.to.merged.text", new Object[0]);
    }

    @NlsActions.ActionText
    private static String getHideMerged() {
        return VcsBundle.message("annotation.switch.to.original.text", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/SwitchAnnotationSourceAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/SwitchAnnotationSourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

