/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonLexer;
import com.intellij.lang.Language;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private static final String PERMISSIVE_ESCAPES;
    public static final TextAttributesKey JSON_BRACKETS;
    public static final TextAttributesKey JSON_BRACES;
    public static final TextAttributesKey JSON_COMMA;
    public static final TextAttributesKey JSON_COLON;
    public static final TextAttributesKey JSON_NUMBER;
    public static final TextAttributesKey JSON_STRING;
    public static final TextAttributesKey JSON_KEYWORD;
    public static final TextAttributesKey JSON_LINE_COMMENT;
    public static final TextAttributesKey JSON_BLOCK_COMMENT;
    public static final TextAttributesKey JSON_IDENTIFIER;
    public static final TextAttributesKey JSON_PROPERTY_KEY;
    public static final TextAttributesKey JSON_VALID_ESCAPE;
    public static final TextAttributesKey JSON_INVALID_ESCAPE;
    public static final TextAttributesKey JSON_PARAMETER;

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project2, @Nullable VirtualFile virtualFile) {
        return new MyHighlighter(virtualFile);
    }

    @NotNull
    protected Lexer getLexer() {
        return new JsonLexer();
    }

    protected boolean isCanEscapeEol() {
        return false;
    }

    static {
        StringBuilder escapesBuilder = new StringBuilder("/");
        for (char c = '\u0001'; c < '\u00ad'; c = (char)(c + 1)) {
            if (c == 120 || c == 117 || Character.isDigit(c) || c == 10 || c == 13) continue;
            escapesBuilder.append(c);
        }
        PERMISSIVE_ESCAPES = escapesBuilder.toString();
        JSON_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"JSON.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        JSON_BRACES = TextAttributesKey.createTextAttributesKey((String)"JSON.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        JSON_COMMA = TextAttributesKey.createTextAttributesKey((String)"JSON.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        JSON_COLON = TextAttributesKey.createTextAttributesKey((String)"JSON.COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
        JSON_NUMBER = TextAttributesKey.createTextAttributesKey((String)"JSON.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        JSON_STRING = TextAttributesKey.createTextAttributesKey((String)"JSON.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        JSON_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"JSON.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        JSON_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JSON.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        JSON_BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JSON.BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        JSON_IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"JSON.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        JSON_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"JSON.PROPERTY_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        JSON_VALID_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JSON.VALID_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        JSON_INVALID_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JSON.INVALID_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        JSON_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"JSON.PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    }

    private final class MyHighlighter
    extends SyntaxHighlighterBase {
        private final Map<IElementType, TextAttributesKey> ourAttributes = new HashMap<IElementType, TextAttributesKey>();
        @Nullable
        private final VirtualFile myFile;

        MyHighlighter(VirtualFile file) {
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_BRACES, (IElementType[])new IElementType[]{JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_BRACKETS, (IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_COMMA, (IElementType[])new IElementType[]{JsonElementTypes.COMMA});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_COLON, (IElementType[])new IElementType[]{JsonElementTypes.COLON});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_STRING, (IElementType[])new IElementType[]{JsonElementTypes.DOUBLE_QUOTED_STRING});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_STRING, (IElementType[])new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_NUMBER, (IElementType[])new IElementType[]{JsonElementTypes.NUMBER});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_KEYWORD, (IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE, JsonElementTypes.NULL});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_LINE_COMMENT, (IElementType[])new IElementType[]{JsonElementTypes.LINE_COMMENT});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_BLOCK_COMMENT, (IElementType[])new IElementType[]{JsonElementTypes.BLOCK_COMMENT});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_IDENTIFIER, (IElementType[])new IElementType[]{JsonElementTypes.IDENTIFIER});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)HighlighterColors.BAD_CHARACTER, (IElementType[])new IElementType[]{TokenType.BAD_CHARACTER});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_VALID_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_INVALID_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_INVALID_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
            this.myFile = file;
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            LayeredLexer layeredLexer = new LayeredLexer(JsonSyntaxHighlighterFactory.this.getLexer());
            final boolean isPermissiveDialect = this.isPermissiveDialect();
            layeredLexer.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\"', JsonElementTypes.DOUBLE_QUOTED_STRING, JsonSyntaxHighlighterFactory.this.isCanEscapeEol(), isPermissiveDialect ? PERMISSIVE_ESCAPES : "/", false, isPermissiveDialect){

                @NotNull
                protected IElementType handleSingleSlashEscapeSequence() {
                    IElementType iElementType = isPermissiveDialect ? this.myOriginalLiteralToken : super.handleSingleSlashEscapeSequence();
                    if (iElementType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return iElementType;
                }

                protected boolean shouldAllowSlashZero() {
                    return isPermissiveDialect;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonSyntaxHighlighterFactory$MyHighlighter$1", "handleSingleSlashEscapeSequence"));
                }
            }, new IElementType[]{JsonElementTypes.DOUBLE_QUOTED_STRING}, IElementType.EMPTY_ARRAY);
            layeredLexer.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\'', JsonElementTypes.SINGLE_QUOTED_STRING, JsonSyntaxHighlighterFactory.this.isCanEscapeEol(), isPermissiveDialect ? PERMISSIVE_ESCAPES : "/", false, isPermissiveDialect){

                @NotNull
                protected IElementType handleSingleSlashEscapeSequence() {
                    IElementType iElementType = isPermissiveDialect ? this.myOriginalLiteralToken : super.handleSingleSlashEscapeSequence();
                    if (iElementType == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return iElementType;
                }

                protected boolean shouldAllowSlashZero() {
                    return isPermissiveDialect;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonSyntaxHighlighterFactory$MyHighlighter$2", "handleSingleSlashEscapeSequence"));
                }
            }, new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING}, IElementType.EMPTY_ARRAY);
            LayeredLexer layeredLexer2 = layeredLexer;
            if (layeredLexer2 == null) {
                MyHighlighter.$$$reportNull$$$0(0);
            }
            return layeredLexer2;
        }

        private boolean isPermissiveDialect() {
            FileType fileType = this.myFile == null ? null : this.myFile.getFileType();
            boolean isPermissiveDialect = false;
            if (fileType instanceof JsonFileType) {
                Language language = ((JsonFileType)fileType).getLanguage();
                isPermissiveDialect = language instanceof JsonLanguage && ((JsonLanguage)language).hasPermissiveStrings();
            }
            return isPermissiveDialect;
        }

        public TextAttributesKey @NotNull [] getTokenHighlights(IElementType type2) {
            TextAttributesKey[] textAttributesKeyArray = MyHighlighter.pack((TextAttributesKey)this.ourAttributes.get(type2));
            if (textAttributesKeyArray == null) {
                MyHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/json/highlighting/JsonSyntaxHighlighterFactory$MyHighlighter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightingLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenHighlights";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

