/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.InlayDimensions;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.ResizeControllerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00128\b\u0002\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010 \u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ResizeController;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "component", "Ljava/awt/Component;", "editor", "Lcom/intellij/openapi/editor/Editor;", "deltaSize", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "dx", "dy", "", "(Ljava/awt/Component;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function2;)V", "defaultCursor", "Ljava/awt/Cursor;", "kotlin.jvm.PlatformType", "nResizeCursor", "prevPoint", "Ljava/awt/Point;", "scaleMode", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ResizeController$ScaleMode;", "mouseClicked", "e", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "setCursor", "cursor", "ScaleMode", "intellij.notebooks.visualization"})
public final class ResizeController
implements MouseListener,
MouseMotionListener {
    @NotNull
    private final Component component;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function2<Integer, Integer, Unit> deltaSize;
    @Nullable
    private Point prevPoint;
    @NotNull
    private ScaleMode scaleMode;
    private final Cursor nResizeCursor;
    private final Cursor defaultCursor;

    public ResizeController(@NotNull Component component, @NotNull Editor editor, @NotNull Function2<? super Integer, ? super Integer, Unit> deltaSize) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(deltaSize, (String)"deltaSize");
        this.component = component;
        this.editor = editor;
        this.deltaSize = deltaSize;
        this.scaleMode = ScaleMode.NONE;
        this.nResizeCursor = Cursor.getPredefinedCursor(8);
        this.defaultCursor = Cursor.getPredefinedCursor(0);
    }

    public /* synthetic */ ResizeController(Component component, Editor editor, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function2 = (Function2)new Function2<Integer, Integer, Unit>((Object)component){

                public final void invoke(int p0, int p1) {
                    ResizeControllerKt.access$swingDeltaSize((Component)this.receiver, p0, p1);
                }
            };
        }
        this(component, editor, (Function2<? super Integer, ? super Integer, Unit>)function2);
    }

    private final void setCursor(Cursor cursor) {
        if (!Intrinsics.areEqual((Object)this.component.getCursor(), (Object)cursor)) {
            this.component.setCursor(cursor);
        }
    }

    @Override
    public void mouseReleased(@Nullable MouseEvent e) {
        if (EditorPainter.isMarginShown((Editor)this.editor) && this.prevPoint != null) {
            Font font = this.editor.getColorsScheme().getFont(EditorFontType.PLAIN);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font font2 = font;
            FontRenderContext context2 = FontInfo.getFontRenderContext((Component)this.editor.getContentComponent());
            FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font2, (FontRenderContext)context2);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            FontMetrics fm = fontMetrics;
            float width = FontLayoutService.Companion.getInstance().charWidth2D(fm, 32);
            float rightMargin = (float)this.editor.getSettings().getRightMargin(this.editor.getProject()) * width;
            Point point = this.prevPoint;
            Intrinsics.checkNotNull((Object)point);
            SwingUtilities.convertPointFromScreen(point, this.editor.getContentComponent());
            Point point2 = this.prevPoint;
            Intrinsics.checkNotNull((Object)point2);
            if (Math.abs((float)point2.x - rightMargin) < (float)JBUI.scale((int)40)) {
                int n = (int)rightMargin;
                Point point3 = this.prevPoint;
                Intrinsics.checkNotNull((Object)point3);
                this.deltaSize.invoke((Object)(n - point3.x), (Object)0);
                SwingUtilities.invokeLater(() -> ResizeController.mouseReleased$lambda$0(this));
            }
        }
        this.prevPoint = null;
        this.scaleMode = ScaleMode.NONE;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int correctedHeight = this.component.getHeight() - InlayDimensions.INSTANCE.getBottomBorder();
        if (e.getPoint().y <= correctedHeight) {
            return;
        }
        this.scaleMode = ScaleMode.N;
        this.prevPoint = e.getLocationOnScreen();
    }

    @Override
    public void mouseDragged(@Nullable MouseEvent e) {
        int n;
        if (this.prevPoint == null) {
            return;
        }
        MouseEvent mouseEvent = e;
        Intrinsics.checkNotNull((Object)mouseEvent);
        Point locationOnScreen = mouseEvent.getLocationOnScreen();
        if (this.scaleMode == ScaleMode.N) {
            int n2 = locationOnScreen.y;
            Point point = this.prevPoint;
            Intrinsics.checkNotNull((Object)point);
            n = n2 - point.y;
        } else {
            n = 0;
        }
        int dy = n;
        this.deltaSize.invoke((Object)0, (Object)dy);
        this.prevPoint = locationOnScreen;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.scaleMode != ScaleMode.NONE) {
            return;
        }
        int correctedHeight = this.component.getHeight() - InlayDimensions.INSTANCE.getBottomBorder();
        Cursor cursor = e.getPoint().y > correctedHeight ? this.nResizeCursor : this.defaultCursor;
        Intrinsics.checkNotNull((Object)cursor);
        this.setCursor(cursor);
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.scaleMode == ScaleMode.NONE) {
            Cursor cursor = this.defaultCursor;
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"defaultCursor");
            this.setCursor(cursor);
        }
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    private static final void mouseReleased$lambda$0(ResizeController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.component.revalidate();
        this$0.component.repaint();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ResizeController$ScaleMode;", "", "(Ljava/lang/String;I)V", "NONE", "N", "intellij.notebooks.visualization"})
    private static final class ScaleMode
    extends Enum<ScaleMode> {
        public static final /* enum */ ScaleMode NONE = new ScaleMode();
        public static final /* enum */ ScaleMode N = new ScaleMode();
        private static final /* synthetic */ ScaleMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScaleMode[] values() {
            return (ScaleMode[])$VALUES.clone();
        }

        public static ScaleMode valueOf(String value) {
            return Enum.valueOf(ScaleMode.class, value);
        }

        @NotNull
        public static EnumEntries<ScaleMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = scaleModeArray = new ScaleMode[]{ScaleMode.NONE, ScaleMode.N};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

