/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;

enum Access {
    PUBLIC,
    PROTECTED,
    PACKAGE,
    PRIVATE;


    public static Access resolve(String s) {
        if (s != null) {
            if ("public".equals(s = s.trim().toLowerCase())) {
                return PUBLIC;
            }
            if ("protected".equals(s)) {
                return PROTECTED;
            }
            if ("private".equals(s)) {
                return PRIVATE;
            }
            if ("package".equals(s)) {
                return PACKAGE;
            }
        }
        return PROTECTED;
    }

    public boolean isAccessible(Set<Modifier> flags) {
        switch (this) {
            case PRIVATE: {
                return true;
            }
            case PACKAGE: {
                return !flags.contains((Object)Modifier.PRIVATE);
            }
            case PROTECTED: {
                return flags.contains((Object)Modifier.PUBLIC) || flags.contains((Object)Modifier.PROTECTED);
            }
            case PUBLIC: {
                return flags.contains((Object)Modifier.PUBLIC);
            }
        }
        throw new IllegalStateException();
    }

    public boolean isAccessible(CompilationInfo javac, TreePath path, boolean alwaysAccessible) {
        Set<Modifier> flags;
        TreePath parent = path.getParentPath();
        Tree leaf = path.getLeaf();
        if (parent != null) {
            Tree.Kind parentKind = parent.getLeaf().getKind();
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)parentKind) && parentKind != Tree.Kind.COMPILATION_UNIT) {
                return false;
            }
            if (!this.isAccessible(javac, parent, alwaysAccessible)) {
                return false;
            }
        }
        switch (leaf.getKind()) {
            case COMPILATION_UNIT: {
                return true;
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                flags = ((ClassTree)leaf).getModifiers().getFlags();
                break;
            }
            case METHOD: {
                flags = ((MethodTree)leaf).getModifiers().getFlags();
                break;
            }
            case VARIABLE: {
                flags = ((VariableTree)leaf).getModifiers().getFlags();
                break;
            }
            default: {
                return false;
            }
        }
        return alwaysAccessible || this.isInterfaceMember(javac, path) || this.isAccessible(flags);
    }

    private boolean isInterfaceMember(CompilationInfo javac, TreePath path) {
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return false;
        }
        Tree parent = parentPath.getLeaf();
        TreeUtilities utils = javac.getTreeUtilities();
        return TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && (utils.isInterface((ClassTree)parent) || utils.isAnnotation((ClassTree)parent));
    }
}

