/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DiffElement
extends SimpleRefactoringElementImplementation {
    private final ModificationResult.Difference diff;
    private final PositionBounds bounds;
    private final FileObject parentFile;
    private final ModificationResult modification;
    private final String displayText;
    private WeakReference<String> newFileContent;

    private DiffElement(ModificationResult.Difference diff, PositionBounds bounds, FileObject parentFile, ModificationResult modification) {
        this.diff = diff;
        this.bounds = bounds;
        this.parentFile = parentFile;
        this.modification = modification;
        this.displayText = diff.getDescription();
    }

    public static DiffElement create(ModificationResult.Difference diff, FileObject fileObject, ModificationResult modification) {
        PositionRef start = diff.getStartPosition();
        PositionRef end = diff.getEndPosition();
        PositionBounds bounds = new PositionBounds(start, end);
        return new DiffElement(diff, bounds, fileObject, modification);
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this.diff});
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public void setEnabled(boolean enabled) {
        this.diff.exclude(!enabled);
        this.newFileContent = null;
        super.setEnabled(enabled);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
        String oldFileName = this.diff.getOldText();
        String newFileName = this.diff.getNewText();
        if (this.parentFile.getName().equals(oldFileName)) {
            try {
                FileLock fileLock = this.parentFile.lock();
                this.parentFile.rename(fileLock, newFileName, "groovy");
                fileLock.releaseLock();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected String getNewFileContent() {
        String result;
        if (this.newFileContent != null && (result = (String)this.newFileContent.get()) != null) {
            return result;
        }
        try {
            result = this.modification.getResultingSource(this.parentFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        this.newFileContent = new WeakReference<String>(result);
        return result;
    }
}

