/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.rest.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.client.rest.wizard.FinishPanelDelegate;
import org.netbeans.modules.web.client.rest.wizard.HtmlPanel;
import org.netbeans.modules.web.client.rest.wizard.JSClientGenerator;
import org.netbeans.modules.web.client.rest.wizard.RestPanel;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JSClientIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    public static final String HELP_ID = "js.client.rest";
    private static final Logger LOGGER = Logger.getLogger(JSClientIterator.class.getName());
    private WizardDescriptor myWizard;
    private RestPanel myRestPanel;
    private WizardDescriptor.Panel[] myPanels;
    private int myIndex;

    public void addChangeListener(ChangeListener listener) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.myPanels[this.myIndex];
    }

    public boolean hasNext() {
        return this.myIndex < this.myPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.myIndex > 0;
    }

    public String name() {
        return null;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.myIndex;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.myIndex;
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    public void initialize(WizardDescriptor descriptor) {
        this.myWizard = descriptor;
        this.myRestPanel = new RestPanel(descriptor);
        Project project = Templates.getProject((WizardDescriptor)descriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        String htmlPanelName = NbBundle.getMessage(JSClientIterator.class, (String)"TXT_HtmlFile");
        HtmlPanel panel = new HtmlPanel(descriptor);
        panel.getComponent().setName(htmlPanelName);
        FileObject projectDirectory = project.getProjectDirectory();
        WebModule webModule = WebModule.getWebModule((FileObject)projectDirectory);
        if (webModule != null) {
            FileObject documentBase = webModule.getDocumentBase();
            if (documentBase != null) {
                Templates.setTargetFolder((WizardDescriptor)this.myWizard, (FileObject)documentBase);
                this.myWizard.putProperty("document_base", (Object)documentBase);
            }
        } else {
            FileObject publicHtml = JSClientIterator.getRootFolder(project);
            if (publicHtml != null) {
                Templates.setTargetFolder((WizardDescriptor)this.myWizard, (FileObject)publicHtml);
            }
        }
        this.myPanels = new WizardDescriptor.Panel[]{new FinishPanelDelegate(Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sources.getSourceGroups("generic")).bottomPanel((WizardDescriptor.Panel)this.myRestPanel).create()), panel};
        this.setSteps();
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        Project project = Templates.getProject((WizardDescriptor)this.myWizard);
        Node restNode = this.myRestPanel.getRestNode();
        RestServiceDescription description = (RestServiceDescription)restNode.getLookup().lookup(RestServiceDescription.class);
        Boolean addBackbone = (Boolean)this.myWizard.getProperty("backbone");
        FileObject existedBackbone = (FileObject)this.myWizard.getProperty("existed-backbone");
        FileObject existedUnderscore = (FileObject)this.myWizard.getProperty("existed-underscore");
        FileObject existedJQuery = (FileObject)this.myWizard.getProperty("existed-jquery");
        RestPanel.JsUi ui = (RestPanel.JsUi)((Object)this.myWizard.getProperty("ui"));
        if (existedBackbone == null && addBackbone != null && addBackbone.booleanValue()) {
            handle.progress(NbBundle.getMessage(JSClientGenerator.class, (String)"TXT_CreateLibs"));
            existedBackbone = this.addLibrary("backbone.js");
            if (existedUnderscore == null) {
                existedUnderscore = this.addLibrary("underscore.js");
            }
            if (existedJQuery == null) {
                existedJQuery = this.addLibrary("jquery");
            }
        }
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.myWizard);
        String targetName = Templates.getTargetName((WizardDescriptor)this.myWizard);
        handle.progress(NbBundle.getMessage(JSClientGenerator.class, (String)"TXT_GenerateModel"));
        JSClientGenerator generator = JSClientGenerator.create(description, ui);
        Map<String, String> map = generator.generate();
        FileObject templateFO = FileUtil.getConfigFile((String)"Templates/ClientSide/rest.js");
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        DataObject createdFile = templateDO.createFromTemplate(dataFolder, targetName, map);
        FileObject jsFile = createdFile.getPrimaryFile();
        File htmlFile = (File)this.myWizard.getProperty("html-file");
        if (htmlFile != null) {
            handle.progress(NbBundle.getMessage(JSClientGenerator.class, (String)"TXT_GenerateHtml"));
            this.createHtml(htmlFile, jsFile, existedBackbone, existedUnderscore, existedJQuery, map, generator);
        }
        handle.finish();
        return Collections.singleton(jsFile);
    }

    public Set instantiate() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void uninitialize(WizardDescriptor descriptor) {
        this.myPanels = null;
    }

    static FileObject getRootFolder(Project project) {
        SourceGroup[] groups = ProjectUtils.getSources((Project)project).getSourceGroups("HTML5-SiteRoot");
        if (groups != null && groups.length > 0) {
            return groups[0].getRootFolder();
        }
        return project.getProjectDirectory();
    }

    private FileObject createHtml(File htmlFile, FileObject appFile, FileObject backbone, FileObject underscore, FileObject jQuery, Map<String, String> map, JSClientGenerator generator) throws IOException {
        String relativePath;
        File parentFile = htmlFile.getParentFile();
        parentFile.mkdirs();
        FileObject folder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)parentFile));
        FileObject templateFO = FileUtil.getConfigFile((String)"Templates/ClientSide/js.html");
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)folder);
        String name = htmlFile.getName();
        if (name.endsWith(".html")) {
            name = name.substring(0, name.length() - ".html".length());
        }
        StringBuilder builder = new StringBuilder();
        if (generator.hasUi()) {
            builder.append("<link rel='stylesheet' href='");
            builder.append("http://mottie.github.com/tablesorter/");
            builder.append("css/theme.blue.css'>\n");
            builder.append("<link rel='stylesheet' href='");
            builder.append("http://mottie.github.com/tablesorter/");
            builder.append("addons/pager/jquery.tablesorter.pager.css'>\n");
        }
        if (underscore == null) {
            builder.append("<script src='http://cdnjs.cloudflare.com/ajax/libs/underscore.js/1.6.0/underscore-min.js'>");
            builder.append("</script>\n");
        } else {
            relativePath = this.getRelativePath(folder, underscore);
            builder.append("<script src='");
            builder.append(relativePath);
            builder.append("'></script>\n");
        }
        if (jQuery == null) {
            builder.append("<script src='http://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.1/jquery.min.js'></script>\n");
        } else {
            relativePath = this.getRelativePath(folder, jQuery);
            builder.append("<script src='");
            builder.append(relativePath);
            builder.append("'></script>\n");
        }
        if (backbone == null) {
            builder.append("<script src='http://cdnjs.cloudflare.com/ajax/libs/backbone.js/1.1.2/backbone-min.js'></script>\n");
        } else {
            relativePath = this.getRelativePath(folder, backbone);
            builder.append("<script src='");
            builder.append(relativePath);
            builder.append("'></script>\n");
        }
        if (generator.hasUi()) {
            builder.append("<script src='");
            builder.append("http://mottie.github.com/tablesorter/");
            builder.append("js/jquery.tablesorter.min.js'></script>\n");
            builder.append("<script src='");
            builder.append("http://mottie.github.com/tablesorter/");
            builder.append("addons/pager/jquery.tablesorter.pager.js'>");
            builder.append("</script>\n");
        }
        relativePath = this.getRelativePath(folder, appFile);
        builder.append("<script src='");
        builder.append(relativePath);
        builder.append("'></script>");
        map.put("script", builder.toString());
        return templateDO.createFromTemplate(dataFolder, name, map).getPrimaryFile();
    }

    private String getRelativePath(FileObject folder, FileObject file) {
        String relativePath = FileUtil.getRelativePath((FileObject)folder, (FileObject)file);
        if (relativePath != null) {
            return relativePath;
        }
        Project project = Templates.getProject((WizardDescriptor)this.myWizard);
        FileObject rootFolder = JSClientIterator.getRootFolder(project);
        relativePath = FileUtil.getRelativePath((FileObject)rootFolder, (FileObject)file);
        if (relativePath == null) {
            rootFolder = project.getProjectDirectory();
            relativePath = FileUtil.getRelativePath((FileObject)rootFolder, (FileObject)file);
        }
        int upCount = this.getNestingCount(rootFolder, folder);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < upCount; ++i) {
            builder.append("../");
        }
        builder.append(relativePath);
        return builder.toString();
    }

    private int getNestingCount(FileObject parent, FileObject child) {
        int count = 0;
        FileObject currentParent = child;
        while (!parent.equals(currentParent)) {
            ++count;
            currentParent = currentParent.getParent();
        }
        return count;
    }

    private void setSteps() {
        Object contentData = this.myWizard.getProperty("WizardPanel_contentData");
        if (contentData instanceof String[]) {
            String[] steps = (String[])contentData;
            String[] newSteps = new String[steps.length + 1];
            System.arraycopy(steps, 0, newSteps, 0, 1);
            newSteps[newSteps.length - 2] = NbBundle.getMessage(JSClientIterator.class, (String)"TXT_JsFile");
            newSteps[newSteps.length - 1] = NbBundle.getMessage(JSClientIterator.class, (String)"TXT_HtmlFile");
            for (int i = 0; i < this.myPanels.length; ++i) {
                WizardDescriptor.Panel panel = this.myPanels[i];
                JComponent component = (JComponent)panel.getComponent();
                component.putClientProperty("WizardPanel_contentData", newSteps);
                component.putClientProperty("WizardPanel_contentSelectedIndex", i);
            }
        }
    }

    private FileObject addLibrary(String libName) {
        return null;
    }
}

