/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.modules.java.j2semodule.J2SEModularProject;
import org.netbeans.modules.java.j2semodule.ui.wizards.ModuleTargetChooserPanel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class NewModuleWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private final transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private transient WizardDescriptor.Panel panel;
    private transient WizardDescriptor wiz;

    public static NewModuleWizardIterator moduleWizard() {
        return new NewModuleWizardIterator();
    }

    public Set instantiate() throws IOException {
        J2SEModularProject project;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        ArrayList<FileObject> createdFolders = new ArrayList<FileObject>();
        FileObject moduleFolder = FileUtil.createFolder((FileObject)dir, (String)targetName);
        createdFolders.add(moduleFolder);
        Project p = Templates.getProject((WizardDescriptor)this.wiz);
        J2SEModularProject j2SEModularProject = project = p != null ? (J2SEModularProject)p.getLookup().lookup(J2SEModularProject.class) : null;
        if (project != null) {
            String[] rootProperties = project.getModuleRoots().getRootProperties();
            String[] rootPathProperties = project.getModuleRoots().getRootPathProperties();
            assert (rootProperties.length == rootPathProperties.length);
            for (int i = 0; i < rootProperties.length; ++i) {
                String rootProp = project.evaluator().getProperty(rootProperties[i]);
                if (rootProp == null || dir != project.getAntProjectHelper().resolveFileObject(rootProp)) continue;
                Collection spVariants = Arrays.stream(PropertyUtils.tokenizePath((String)project.evaluator().getProperty(rootPathProperties[i]))).map(pe -> CommonModuleUtils.parseSourcePathVariants((String)pe)).flatMap(lv -> lv.stream()).collect(Collectors.toList());
                for (String variant : spVariants) {
                    if (variant.isEmpty()) continue;
                    createdFolders.add(FileUtil.createFolder((FileObject)moduleFolder, (String)variant.replace(File.separatorChar, '/')));
                }
            }
        }
        DataFolder df = DataFolder.findFolder((FileObject)((FileObject)createdFolders.get(createdFolders.size() > 1 ? 1 : 0)));
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, null, Collections.singletonMap("moduleName", targetName));
        FileObject createdFile = dobj.getPrimaryFile();
        HashSet<FileObject> res = new HashSet<FileObject>();
        res.addAll(createdFolders);
        res.add(createdFile);
        return Collections.unmodifiableSet(res);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wiz = wizard;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        if (project == null) {
            throw new NullPointerException("No project found for: " + this.wiz);
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("modules");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if (groups.length == 0) {
            groups = sources.getSourceGroups("generic");
        }
        this.panel = new ModuleTargetChooserPanel(project, groups);
        Object prop = this.wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = prop instanceof String[] ? (String[])prop : new String[]{};
        int diff = 0;
        if (beforeSteps.length > 0) {
            diff = "...".equals(beforeSteps[beforeSteps.length - 1]) ? 1 : 0;
        }
        String[] steps = new String[beforeSteps.length - diff + 1];
        for (int i = 0; i < steps.length; ++i) {
            steps[i] = i < beforeSteps.length - diff ? beforeSteps[i] : this.panel.getComponent().getName();
        }
        Component c = this.panel.getComponent();
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wiz = null;
        this.panel = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panel;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        ChangeListener[] ls;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l : ls) {
            l.stateChanged(ev);
        }
    }
}

