/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import javax.swing.text.BadLocationException;
import org.netbeans.lib.editor.util.CharSubSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssFileModel {
    private Collection<Entry> classes;
    private Collection<Entry> ids;
    private Collection<Entry> htmlElements;
    private Collection<Entry> imports;
    private Collection<Entry> colors;
    private final Snapshot snapshot;
    private final Snapshot topLevelSnapshot;

    public static CssFileModel create(Source source) throws ParseException {
        final AtomicReference model = new AtomicReference();
        ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                Parser.Result parserResult;
                ResultIterator cssRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                Snapshot topLevelSnapshot = resultIterator.getSnapshot();
                if (cssRi != null && (parserResult = cssRi.getParserResult()) != null) {
                    model.set(new CssFileModel((CssParserResult)parserResult, topLevelSnapshot));
                    return;
                }
                model.set(new CssFileModel(topLevelSnapshot));
            }
        });
        return (CssFileModel)model.get();
    }

    public static CssFileModel create(CssParserResult result) {
        return new CssFileModel(result, null);
    }

    private CssFileModel(Snapshot topLevelSnapshot) {
        this.snapshot = this.topLevelSnapshot = topLevelSnapshot;
    }

    private CssFileModel(CssParserResult parserResult, Snapshot topLevelSnapshot) {
        this.snapshot = parserResult.getSnapshot();
        this.topLevelSnapshot = topLevelSnapshot;
        if (parserResult.getParseTree() != null) {
            ParseTreeVisitor visitor = new ParseTreeVisitor();
            visitor.visitChildren(parserResult.getParseTree());
        }
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Snapshot getTopLevelSnapshot() {
        return this.topLevelSnapshot;
    }

    public FileObject getFileObject() {
        return this.getSnapshot().getSource().getFileObject();
    }

    public Collection<Entry> get(RefactoringElementType type) {
        switch (type) {
            case CLASS: {
                return this.getClasses();
            }
            case ID: {
                return this.getIds();
            }
            case COLOR: {
                return this.getColors();
            }
            case ELEMENT: {
                return this.htmlElements;
            }
            case IMPORT: {
                return this.imports;
            }
        }
        return null;
    }

    public Collection<Entry> getClasses() {
        return this.classes == null ? Collections.emptyList() : this.classes;
    }

    public Collection<Entry> getIds() {
        return this.ids == null ? Collections.emptyList() : this.ids;
    }

    public Collection<Entry> getHtmlElements() {
        return this.htmlElements == null ? Collections.emptyList() : this.htmlElements;
    }

    public Collection<Entry> getImports() {
        return this.imports == null ? Collections.emptyList() : this.imports;
    }

    public Collection<Entry> getColors() {
        return this.colors == null ? Collections.emptyList() : this.colors;
    }

    public boolean isEmpty() {
        return null == this.classes && null == this.ids && null == this.htmlElements && null == this.imports && null == this.colors;
    }

    private Collection<Entry> getClassesCollectionInstance() {
        if (this.classes == null) {
            this.classes = new ArrayList<Entry>();
        }
        return this.classes;
    }

    private Collection<Entry> getIdsCollectionInstance() {
        if (this.ids == null) {
            this.ids = new ArrayList<Entry>();
        }
        return this.ids;
    }

    private Collection<Entry> getHtmlElementsCollectionInstance() {
        if (this.htmlElements == null) {
            this.htmlElements = new ArrayList<Entry>();
        }
        return this.htmlElements;
    }

    private Collection<Entry> getImportsCollectionInstance() {
        if (this.imports == null) {
            this.imports = new ArrayList<Entry>();
        }
        return this.imports;
    }

    private Collection<Entry> getColorsCollectionInstance() {
        if (this.colors == null) {
            this.colors = new ArrayList<Entry>();
        }
        return this.colors;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(":");
        for (Entry c : this.getImports()) {
            buf.append(" imports=");
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getClasses()) {
            buf.append('.');
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getIds()) {
            buf.append('#');
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getHtmlElements()) {
            buf.append(c);
            buf.append(',');
        }
        return buf.toString();
    }

    private Entry createEntry(String name, OffsetRange range, boolean isVirtual) {
        return this.createEntry(name, range, null, isVirtual);
    }

    private Entry createEntry(String name, OffsetRange range, OffsetRange bodyRange, boolean isVirtual) {
        return new LazyEntry(this.getSnapshot(), this.getTopLevelSnapshot(), name, range, bodyRange, isVirtual);
    }

    private static int[] getTextWSPreAndPostLens(CharSequence text) {
        char c;
        int i;
        int preWSlen = 0;
        int postWSlen = 0;
        for (i = 0; i < text.length() && Character.isWhitespace(c = text.charAt(i)); ++i) {
            ++preWSlen;
        }
        for (i = text.length() - 1; i >= 0 && Character.isWhitespace(c = text.charAt(i)); --i) {
            ++postWSlen;
        }
        return new int[]{preWSlen, postWSlen};
    }

    private static class LazyEntry
    implements Entry {
        private final String name;
        private final OffsetRange range;
        private final OffsetRange bodyRange;
        private final boolean isVirtual;
        private OffsetRange documentRange;
        private OffsetRange documentBodyRange;
        private CharSequence elementText;
        private CharSequence elementLineText;
        private int lineOffset = -1;
        private final CharSequence snapshotText;
        private CharSequence topLevelSnapshotText;
        private final int documentFrom;
        private final int documentTo;
        private int bodyDocFrom;
        private int bodyDocTo;

        public LazyEntry(Snapshot snapshot, Snapshot topLevelSnapshot, String name, OffsetRange range, OffsetRange bodyRange, boolean isVirtual) {
            this.snapshotText = snapshot.getText();
            if (topLevelSnapshot != null) {
                this.topLevelSnapshotText = topLevelSnapshot.getText();
            }
            this.name = name;
            this.range = range;
            this.bodyRange = bodyRange;
            this.isVirtual = isVirtual;
            this.documentFrom = snapshot.getOriginalOffset(range.getStart());
            this.documentTo = snapshot.getOriginalOffset(range.getEnd());
            if (bodyRange != null) {
                this.bodyDocFrom = snapshot.getOriginalOffset(bodyRange.getStart());
                this.bodyDocTo = snapshot.getOriginalOffset(bodyRange.getEnd());
            }
        }

        @Override
        public boolean isVirtual() {
            return this.isVirtual;
        }

        @Override
        public boolean isValidInSourceDocument() {
            return this.getDocumentRange() != OffsetRange.NONE;
        }

        @Override
        public synchronized int getLineOffset() {
            if (this.lineOffset == -1 && this.topLevelSnapshotText != null && this.isValidInSourceDocument()) {
                try {
                    this.lineOffset = LexerUtils.getLineOffset((CharSequence)this.topLevelSnapshotText, (int)this.getDocumentRange().getStart());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.lineOffset;
        }

        @Override
        public synchronized CharSequence getText() {
            if (this.elementText == null) {
                this.elementText = new CharSubSequence(this.snapshotText, this.range.getStart(), this.range.getEnd());
            }
            return this.elementText;
        }

        @Override
        public synchronized CharSequence getLineText() {
            if (this.elementLineText == null) {
                try {
                    int astLineStart = GsfUtilities.getRowStart((CharSequence)this.snapshotText, (int)this.range.getStart());
                    int astLineEnd = GsfUtilities.getRowEnd((CharSequence)this.snapshotText, (int)this.range.getStart());
                    this.elementLineText = astLineStart != -1 && astLineEnd != -1 ? this.snapshotText.subSequence(astLineStart, astLineEnd) : null;
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.elementLineText;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public synchronized OffsetRange getDocumentRange() {
            if (this.documentRange == null) {
                this.documentRange = this.documentFrom != -1 && this.documentTo != -1 ? new OffsetRange(this.documentFrom, this.documentTo) : OffsetRange.NONE;
            }
            return this.documentRange;
        }

        @Override
        public OffsetRange getRange() {
            return this.range;
        }

        @Override
        public OffsetRange getBodyRange() {
            return this.bodyRange;
        }

        @Override
        public synchronized OffsetRange getDocumentBodyRange() {
            if (this.documentBodyRange == null && this.bodyRange != null) {
                this.documentBodyRange = this.bodyDocFrom != -1 && this.bodyDocTo != -1 ? new OffsetRange(this.bodyDocFrom, this.bodyDocTo) : OffsetRange.NONE;
            }
            return this.documentBodyRange;
        }

        public String toString() {
            return "Entry[" + (!this.isValidInSourceDocument() ? "INVALID! " : "") + this.getName() + "; " + this.getRange().getStart() + " - " + this.getRange().getEnd() + "]";
        }
    }

    private class ParseTreeVisitor
    extends NodeVisitor {
        private int[] currentBodyRange;

        private ParseTreeVisitor() {
        }

        public boolean visit(Node node) {
            switch (node.type()) {
                case resourceIdentifier: {
                    CssFileModel.this.getImportsCollectionInstance().addAll(this.getImportsFromString(node));
                }
                case term: {
                    CssFileModel.this.getImportsCollectionInstance().addAll(this.getImportsFromURI(node));
                    break;
                }
                case rule: {
                    this.currentBodyRange = NodeUtil.getRuleBodyRange((Node)node);
                    break;
                }
                case hexColor: {
                    CharSequence image = node.image();
                    int[] wsLens = CssFileModel.getTextWSPreAndPostLens(image);
                    image = image.subSequence(wsLens[0], image.length() - wsLens[1]);
                    OffsetRange range = new OffsetRange(node.from() + wsLens[0], node.to() - wsLens[1]);
                    Entry e = CssFileModel.this.createEntry(image.toString(), range, false);
                    if (e == null) break;
                    CssFileModel.this.getColorsCollectionInstance().add(e);
                    break;
                }
                default: {
                    int start_offset_diff;
                    Collection collection;
                    if (!NodeUtil.isSelectorNode((Node)node) || NodeUtil.containsError((Node)node)) break;
                    switch (node.type()) {
                        case cssClass: {
                            collection = CssFileModel.this.getClassesCollectionInstance();
                            start_offset_diff = 1;
                            break;
                        }
                        case cssId: {
                            collection = CssFileModel.this.getIdsCollectionInstance();
                            start_offset_diff = 1;
                            break;
                        }
                        case elementName: {
                            collection = CssFileModel.this.getHtmlElementsCollectionInstance();
                            start_offset_diff = 0;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    String image = node.unescapedImage().substring(start_offset_diff);
                    OffsetRange range = new OffsetRange(node.from() + start_offset_diff, node.to());
                    boolean isVirtual = CssFileModel.this.getSnapshot().getOriginalOffset(node.from()) == -1;
                    OffsetRange body = this.currentBodyRange != null ? new OffsetRange(this.currentBodyRange[0], this.currentBodyRange[1]) : OffsetRange.NONE;
                    Entry e = CssFileModel.this.createEntry(image.toString(), range, body, isVirtual);
                    if (e == null) break;
                    collection.add(e);
                }
            }
            return false;
        }

        private Collection<Entry> getImportsFromString(Node resourceIdentifier) {
            ArrayList<Entry> files = new ArrayList<Entry>();
            Node token = NodeUtil.getChildTokenNode((Node)resourceIdentifier, (CssTokenId)CssTokenId.STRING);
            if (token != null) {
                String image = token.unescapedImage();
                boolean quoted = WebUtils.isValueQuoted((CharSequence)image);
                files.add(CssFileModel.this.createEntry(WebUtils.unquotedValue((CharSequence)image), new OffsetRange(token.from() + (quoted ? 1 : 0), token.to() - (quoted ? 1 : 0)), false));
            }
            return files;
        }

        private Collection<Entry> getImportsFromURI(Node resourceIdentifier) {
            Matcher m;
            ArrayList<Entry> files = new ArrayList<Entry>();
            Node token = NodeUtil.getChildTokenNode((Node)resourceIdentifier, (CssTokenId)CssTokenId.URI);
            if (token != null && (m = Css3Utils.URI_PATTERN.matcher(token.unescapedImage())).matches()) {
                int groupIndex = 1;
                String content = m.group(groupIndex);
                boolean quoted = WebUtils.isValueQuoted((CharSequence)content);
                int from = token.from() + m.start(groupIndex) + (quoted ? 1 : 0);
                int to = token.from() + m.end(groupIndex) - (quoted ? 1 : 0);
                files.add(CssFileModel.this.createEntry(WebUtils.unquotedValue((CharSequence)content), new OffsetRange(from, to), false));
            }
            return files;
        }
    }
}

