/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Cache<K, V> {
    private final Map<K, V> data;
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();

    public Cache() {
        this(new HashMap());
    }

    public Cache(Map<K, V> data) {
        this.data = data;
    }

    public void save(K key, V value) {
        this.dataLock.writeLock().lock();
        try {
            this.data.put(key, value);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    public V get(K key) {
        this.dataLock.readLock().lock();
        try {
            V v = this.data.get(key);
            return v;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    public boolean has(K token) {
        this.dataLock.readLock().lock();
        try {
            boolean bl = this.data.containsKey(token);
            return bl;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }
}

