/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.parser.CSSParserInstantiationException;
import org.jfree.layouting.input.style.parser.FixNamespaceConditionFactory;
import org.jfree.layouting.input.style.parser.FixNamespaceSelectorFactory;
import org.jfree.layouting.input.style.selectors.CSSSelectorFactory;
import org.jfree.layouting.input.style.selectors.conditions.CSSConditionFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.helpers.ParserFactory;

public class CSSParserFactory {
    private static CSSParserFactory parserFactory;

    public static synchronized CSSParserFactory getInstance() {
        if (parserFactory == null) {
            parserFactory = new CSSParserFactory();
        }
        return parserFactory;
    }

    private CSSParserFactory() {
    }

    public Parser createCSSParser() throws CSSParserInstantiationException {
        Parser parser;
        Configuration configuration = LibLayoutBoot.getInstance().getGlobalConfig();
        String string = configuration.getConfigProperty("org.jfree.layouting.css.Parser");
        if (string != null && (parser = (Parser)ObjectUtilities.loadAndInstantiate((String)string, CSSParserFactory.class, Parser.class)) != null) {
            parser.setConditionFactory((ConditionFactory)new FixNamespaceConditionFactory(new CSSConditionFactory()));
            parser.setSelectorFactory((SelectorFactory)new FixNamespaceSelectorFactory(new CSSSelectorFactory()));
            return parser;
        }
        try {
            parser = new ParserFactory().makeParser();
            if (parser == null) {
                return null;
            }
            parser.setConditionFactory((ConditionFactory)new FixNamespaceConditionFactory(new CSSConditionFactory()));
            parser.setSelectorFactory((SelectorFactory)new FixNamespaceSelectorFactory(new CSSSelectorFactory()));
            return parser;
        }
        catch (Exception exception) {
            throw new CSSParserInstantiationException();
        }
    }
}

